/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.dialogs.SelectSupplementaryResourcesDialog;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTraceSupplementaryFilesHandler
extends AbstractHandler {
    private static final Comparator<TmfCommonProjectElement> ELEMENT_COMPARATOR = Comparator.comparing(e -> e.getPath().toString());
    private static final Comparator<IResource> RESOURCE_COMPARATOR = Comparator.comparing(e -> e.getFullPath().toString());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Object> allResourcesToDelete;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        TreeMultimap resourceMap = TreeMultimap.create(ELEMENT_COMPARATOR, RESOURCE_COMPARATOR);
        for (Object element : (IStructuredSelection)selection) {
            IResource resource;
            int n;
            IResource[] iResourceArray;
            if (element instanceof TmfTraceElement) {
                TmfTraceElement trace = (TmfTraceElement)element;
                trace = trace.getElementUnderTraceFolder();
                iResourceArray = trace.getSupplementaryResources();
                n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    resource = iResourceArray[n2];
                    resourceMap.put((Object)trace, (Object)resource);
                    ++n2;
                }
                continue;
            }
            if (!(element instanceof TmfExperimentElement)) continue;
            TmfExperimentElement experiment = (TmfExperimentElement)element;
            iResourceArray = experiment.getSupplementaryResources();
            n = iResourceArray.length;
            int n3 = 0;
            while (n3 < n) {
                resource = iResourceArray[n3];
                resourceMap.put((Object)experiment, (Object)resource);
                ++n3;
            }
            for (TmfTraceElement trace : experiment.getTraces()) {
                trace = trace.getElementUnderTraceFolder();
                IResource[] iResourceArray2 = trace.getSupplementaryResources();
                int n4 = iResourceArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    IResource resource2 = iResourceArray2[n5];
                    resourceMap.put((Object)trace, (Object)resource2);
                    ++n5;
                }
            }
        }
        boolean confirm = Activator.getDefault().getPreferenceStore().getBoolean("CONFIRM_DELETION_SUPPLEMENTARY_FILES");
        if (confirm) {
            SelectSupplementaryResourcesDialog dialog = new SelectSupplementaryResourcesDialog(window.getShell(), (Multimap<TmfCommonProjectElement, IResource>)resourceMap);
            if (dialog.open() != 0) {
                return null;
            }
            allResourcesToDelete = Arrays.asList(dialog.getResources());
        } else {
            allResourcesToDelete = new ArrayList(resourceMap.values());
        }
        TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation((Multimap)resourceMap){
            private final /* synthetic */ Multimap val$resourceMap;
            {
                this.val$resourceMap = multimap;
            }

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                HashSet<IProject> projectsToRefresh = new HashSet<IProject>();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)allResourcesToDelete.size());
                for (TmfCommonProjectElement element : this.val$resourceMap.keySet()) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ArrayList traceResourcesToDelete = new ArrayList(this.val$resourceMap.get((Object)element));
                    traceResourcesToDelete.retainAll(allResourcesToDelete);
                    if (!traceResourcesToDelete.isEmpty()) {
                        subMonitor.setTaskName(NLS.bind((String)Messages.DeleteSupplementaryFiles_DeletionTask, (Object)element.getElementPath()));
                        Display.getDefault().syncExec(element::closeEditors);
                        element.deleteSupplementaryResources(traceResourcesToDelete.toArray(new IResource[0]));
                        projectsToRefresh.add(element.getProject().getResource());
                    }
                    subMonitor.worked(traceResourcesToDelete.size());
                }
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)projectsToRefresh.size());
                Iterator projectIterator = projectsToRefresh.iterator();
                while (projectIterator.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IProject project = (IProject)projectIterator.next();
                    subMonitor.setTaskName(NLS.bind((String)Messages.DeleteSupplementaryFiles_ProjectRefreshTask, (Object)project.getName()));
                    try {
                        project.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error refreshing project " + project, e);
                    }
                    subMonitor.worked(1);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
            return null;
        }
        return null;
    }
}

