/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractStateSystemAnalysisDataProvider
extends AbstractTmfTraceDataProvider {
    public AbstractStateSystemAnalysisDataProvider(ITmfTrace trace) {
        super(trace);
    }

    protected @Nullable TmfModelResponse<ITmfCommonXAxisModel> verifyParameters(TmfStateSystemAnalysisModule module, TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        if (!module.waitForInitialization()) {
            return TmfCommonXAxisResponseFactory.createFailedResponse(CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        if (monitor != null && monitor.isCanceled()) {
            return TmfCommonXAxisResponseFactory.createCancelledResponse(CommonStatusMessage.TASK_CANCELLED);
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return TmfCommonXAxisResponseFactory.createFailedResponse(CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        long realStart = Math.max(ss.getStartTime(), filter.getStart());
        if (realStart >= filter.getEnd()) {
            return TmfCommonXAxisResponseFactory.createFailedResponse(CommonStatusMessage.INCORRECT_QUERY_INTERVAL);
        }
        return null;
    }
}

