/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readonly.TmfXmlReadOnlyModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.XmlEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.XmlPresentationProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.TmfViewFactory;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.w3c.dom.Element;

public class XmlTimeGraphView
extends AbstractTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph";
    private static final String[] DEFAULT_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId, Messages.XmlTimeGraphView_ColumnParentId};
    private static final String[] DEFAULT_FILTER_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId};
    private static final int[] fWeight = new int[]{1, 2};
    private static final String EMPTY_STRING = "";
    private static final @NonNull String SPLIT_STRING = "/";
    private static final Comparator<XmlEntry> XML_ENTRY_COMPARATOR = Comparator.comparing(XmlEntry::getType).thenComparing(XmlEntry::getElement, Comparator.nullsFirst(Comparator.comparing(element -> element.getAttribute("path")))).thenComparing(TimeGraphEntry::getName).thenComparingLong(TimeGraphEntry::getStartTime);
    private static final Comparator<ITimeGraphEntry> ENTRY_COMPARATOR = Comparator.comparing(x -> (XmlEntry)((Object)x), XML_ENTRY_COMPARATOR);
    private final @NonNull XmlViewInfo fViewInfo = new XmlViewInfo("org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph");
    private final ITmfXmlModelFactory fFactory;
    private final Map<String, Integer> fStringValueMap = new HashMap<String, Integer>();

    public XmlTimeGraphView() {
        super(ID, (TimeGraphPresentationProvider)new XmlPresentationProvider());
        this.setWeight(fWeight);
        this.setTreeColumns(DEFAULT_COLUMN_NAMES);
        this.setTreeLabelProvider(new XmlTreeLabelProvider());
        this.setFilterColumns(DEFAULT_FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new XmlTreeLabelProvider());
        this.setEntryComparator(ENTRY_COMPARATOR);
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newValue;
                if (event.getProperty().equals("xmlOutputData") && (newValue = event.getNewValue()) instanceof String) {
                    String data = (String)newValue;
                    XmlTimeGraphView.this.fViewInfo.setViewData(data);
                    XmlTimeGraphView.this.loadNewXmlView();
                }
            }
        });
        this.fFactory = TmfXmlReadOnlyModelFactory.getInstance();
    }

    public void createPartControl(Composite parent) {
        String name = this.getViewSite().getSecondaryId();
        if (name != null) {
            name = TmfViewFactory.getBaseSecId((String)name);
        }
        if (name != null) {
            this.fViewInfo.setName(name);
        }
        super.createPartControl(parent);
    }

    private void loadNewXmlView() {
        this.rebuild();
    }

    private void setViewTitle(final String title) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XmlTimeGraphView.this.setPartName(title);
            }
        });
    }

    protected String getNextText() {
        return Messages.XmlTimeGraphView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.XmlTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.XmlTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.XmlTimeGraphView_PreviousInterval;
    }

    protected XmlPresentationProvider getPresentationProvider() {
        return (XmlPresentationProvider)super.getPresentationProvider();
    }

    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        String title;
        Element viewElement = this.fViewInfo.getViewElement("timeGraphView");
        if (viewElement == null) {
            return;
        }
        XmlPresentationProvider pres = this.getPresentationProvider();
        if (pres instanceof XmlPresentationProvider) {
            pres.loadNewStates(viewElement);
        }
        if ((title = this.fViewInfo.getViewTitle(viewElement)) == null) {
            title = Messages.XmlTimeGraphView_DefaultTitle;
        }
        this.setViewTitle(title);
        this.fStringValueMap.clear();
        Set analysisIds = TmfXmlUtils.getViewAnalysisIds((Element)viewElement);
        List entries = TmfXmlUtils.getChildElements((Element)viewElement, (String)"entry");
        TreeSet<XmlEntry> entryList = new TreeSet<XmlEntry>(this.getEntryComparator());
        if (monitor.isCanceled()) {
            return;
        }
        HashSet<@NonNull ITmfAnalysisModuleWithStateSystems> stateSystemModules = new HashSet<ITmfAnalysisModuleWithStateSystems>();
        if (analysisIds.isEmpty()) {
            Iterables.addAll(stateSystemModules, (Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class));
        } else {
            for (String moduleId : analysisIds) {
                ITmfAnalysisModuleWithStateSystems module = (ITmfAnalysisModuleWithStateSystems)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class, (String)(moduleId = (String)NonNullUtils.checkNotNull((Object)moduleId)));
                if (module == null) continue;
                stateSystemModules.add(module);
            }
        }
        for (ITmfAnalysisModuleWithStateSystems module : stateSystemModules) {
            IStatus status = module.schedule();
            if (!status.isOK()) {
                return;
            }
            if (!module.waitForInitialization()) {
                return;
            }
            for (ITmfStateSystem ssq : module.getStateSystems()) {
                ssq.waitUntilBuilt();
                long startTime = ssq.getStartTime();
                long endTime = ssq.getCurrentEndTime();
                XmlEntry groupEntry = new XmlEntry(-1, trace, trace.getName(), ssq);
                entryList.add(groupEntry);
                this.setStartTime(Math.min(this.getStartTime(), startTime));
                this.setEndTime(Math.max(this.getEndTime(), endTime));
                for (Element entry : entries) {
                    this.buildEntry(entry, groupEntry, -1, EMPTY_STRING);
                }
            }
        }
        this.addToEntryList(parentTrace, new ArrayList(entryList));
        if (parentTrace.equals(this.getTrace())) {
            this.refresh();
        }
        for (XmlEntry traceEntry : entryList) {
            if (monitor.isCanceled()) {
                return;
            }
            long startTime = traceEntry.getStateSystem().getStartTime();
            long endTime = traceEntry.getStateSystem().getCurrentEndTime() + 1L;
            this.buildStatusEvent(traceEntry, monitor, startTime, endTime);
        }
    }

    private void buildEntry(Element entryElement, XmlEntry parentEntry, int prevBaseQuark, String prevRegex) {
        String attributePath;
        Pattern pattern;
        Matcher matcher;
        ITmfStateSystem parentSs;
        String path = entryElement.getAttribute("path");
        if (path.isEmpty()) {
            path = "*";
        }
        List displayElements = TmfXmlUtils.getChildElements((Element)entryElement, (String)"display");
        List entryElements = TmfXmlUtils.getChildElements((Element)entryElement, (String)"entry");
        if (displayElements.isEmpty() && entryElements.isEmpty()) {
            Activator.logWarning(String.format("XML view: entry for %s should have either a display element or entry elements", path));
            return;
        }
        String analysisId = entryElement.getAttribute("analysisId");
        ITmfStateSystem ss = parentSs = parentEntry.getStateSystem();
        int baseQuark = prevBaseQuark;
        if (!analysisId.isEmpty()) {
            ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)parentEntry.getTrace(), (String)analysisId);
            baseQuark = -1;
            if (ss == null) {
                return;
            }
        }
        if ((matcher = (pattern = Pattern.compile(prevRegex)).matcher(attributePath = prevBaseQuark > 0 ? parentSs.getFullAttributePath(prevBaseQuark) : EMPTY_STRING)).find()) {
            path = matcher.replaceFirst(path);
        }
        String regexName = path.replaceAll("\\*", "(.*)");
        String[] paths = regexName.split(SPLIT_STRING);
        int i = 0;
        List<Integer> quarks = Collections.singletonList(baseQuark);
        while (i < paths.length) {
            LinkedList<Integer> subQuarks = new LinkedList<Integer>();
            String name = paths[i];
            for (int relativeQuark : quarks) {
                Iterator iterator = ss.getSubAttributes(relativeQuark, false, name).iterator();
                while (iterator.hasNext()) {
                    int quark = (Integer)iterator.next();
                    subQuarks.add(quark);
                }
            }
            quarks = subQuarks;
            ++i;
        }
        Element displayElement = null;
        HashMap<String, XmlEntry> entryMap = new HashMap<String, XmlEntry>();
        if (!displayElements.isEmpty()) {
            displayElement = (Element)displayElements.get(0);
        }
        for (int quark : quarks) {
            XmlEntry currentEntry = parentEntry;
            if (displayElement != null) {
                currentEntry = this.processEntry(entryElement, displayElement, parentEntry, quark, ss);
                entryMap.put(currentEntry.getId(), currentEntry);
            }
            for (Element subEntryEl : entryElements) {
                this.buildEntry(subEntryEl, currentEntry, quark, prevRegex.isEmpty() ? regexName : String.valueOf(prevRegex) + '/' + regexName);
            }
        }
        if (!entryMap.isEmpty()) {
            XmlTimeGraphView.buildTree(entryMap, parentEntry);
        }
    }

    private XmlEntry processEntry(@NonNull Element entryElement, @NonNull Element displayEl, @NonNull XmlEntry parentEntry, int quark, ITmfStateSystem ss) {
        ITmfXmlStateAttribute display = this.fFactory.createStateAttribute(displayEl, (IXmlStateSystemContainer)parentEntry);
        int displayQuark = display.getAttributeQuark(quark, null);
        if (displayQuark == -1) {
            return new XmlEntry(quark, parentEntry.getTrace(), String.format("Unknown display quark for %s", ss.getAttributeName(quark)), ss);
        }
        long entryStart = ss.getStartTime();
        long entryEnd = ss.getCurrentEndTime() + 1L;
        try {
            long ts;
            ITmfStateInterval oneInterval = ss.querySingleState(entryStart, displayQuark);
            while (oneInterval.getStateValue().isNull()) {
                ts = oneInterval.getEndTime() + 1L;
                if (ts > ss.getCurrentEndTime()) break;
                oneInterval = ss.querySingleState(ts, displayQuark);
            }
            entryStart = oneInterval.getStartTime();
            oneInterval = ss.querySingleState(entryEnd - 1L, displayQuark);
            while (oneInterval.getStateValue().isNull()) {
                ts = oneInterval.getStartTime() - 1L;
                if (ts < ss.getStartTime()) break;
                oneInterval = ss.querySingleState(ts, displayQuark);
            }
            entryEnd = oneInterval.getEndTime() + 1L;
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return new XmlEntry(quark, displayQuark, parentEntry.getTrace(), ss.getAttributeName(quark), entryStart, entryEnd, XmlEntry.EntryDisplayType.DISPLAY, ss, entryElement);
    }

    private void buildStatusEvent(XmlEntry traceEntry, @NonNull IProgressMonitor monitor, long start, long end) {
        long resolution = Math.max((end - start) / (long)this.getDisplayWidth(), 1L);
        long startTime = Math.max(start, traceEntry.getStartTime());
        long endTime = Math.min(end + 1L, traceEntry.getEndTime());
        List<ITimeEvent> eventList = this.getEventList(traceEntry, startTime, endTime, resolution, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        traceEntry.setEventList(eventList);
        this.redraw();
        for (ITimeGraphEntry entry : traceEntry.getChildren()) {
            if (monitor.isCanceled()) {
                return;
            }
            XmlEntry xmlEntry = (XmlEntry)entry;
            this.buildStatusEvent(xmlEntry, monitor, start, end);
        }
    }

    private static void buildTree(Map<String, XmlEntry> entryMap, XmlEntry rootEntry) {
        for (XmlEntry entry : entryMap.values()) {
            XmlEntry parent;
            boolean root = true;
            if (!entry.getParentId().isEmpty() && (parent = entryMap.get(entry.getParentId())) != null && entry.getStartTime() <= parent.getEndTime() && entry.getEndTime() >= parent.getStartTime()) {
                parent.addChild(entry);
                root = false;
            }
            if (!root) continue;
            rootEntry.addChild(entry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (!(entry instanceof XmlEntry)) {
            return Collections.emptyList();
        }
        XmlEntry xmlEntry = (XmlEntry)entry;
        ITmfStateSystem ssq = xmlEntry.getStateSystem();
        long realStart = Math.max(startTime, entry.getStartTime());
        long realEnd = Math.min(endTime, entry.getEndTime());
        if (realEnd <= realStart) {
            return null;
        }
        ArrayList<Object> eventList = null;
        int quark = xmlEntry.getDisplayQuark();
        try {
            if (xmlEntry.getType() != XmlEntry.EntryDisplayType.DISPLAY) return eventList;
            List statusIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ssq, (int)quark, (long)realStart, (long)(realEnd - 1L), (long)resolution, (IProgressMonitor)monitor);
            eventList = new ArrayList<Object>(statusIntervals.size());
            long lastEndTime = -1L;
            Iterator iterator = statusIntervals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return eventList;
                }
                ITmfStateInterval statusInterval = (ITmfStateInterval)iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                int status = this.getStatusFromInterval(statusInterval);
                long time = statusInterval.getStartTime();
                long duration = statusInterval.getEndTime() - time + 1L;
                if (!statusInterval.getStateValue().isNull()) {
                    if (lastEndTime != time && lastEndTime != -1L) {
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                    }
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                } else if (lastEndTime == -1L || time + duration >= endTime) {
                    eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                }
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | StateValueTypeException | TimeRangeException throwable) {
            // empty catch block
        }
        return eventList;
    }

    private int getStringIndex(String stateStr) {
        XmlPresentationProvider pres = this.getPresentationProvider();
        Integer statusInt = this.fStringValueMap.get(stateStr);
        if (statusInt != null) {
            return statusInt;
        }
        int status = pres.addState(stateStr);
        this.fStringValueMap.put(stateStr, status);
        return status;
    }

    private int getStatusFromInterval(ITmfStateInterval statusInterval) {
        ITmfStateValue stateValue = statusInterval.getStateValue();
        int status = -1;
        switch (stateValue.getType()) {
            case NULL: 
            case INTEGER: {
                status = stateValue.unboxInt();
                XmlPresentationProvider pres = this.getPresentationProvider();
                if (pres.hasIndex(status)) break;
                status = this.getStringIndex(String.valueOf(status));
                break;
            }
            case LONG: {
                status = (int)stateValue.unboxLong();
                XmlPresentationProvider pres = this.getPresentationProvider();
                if (pres.hasIndex(status)) break;
                status = this.getStringIndex("0x" + Long.toHexString(stateValue.unboxLong()));
                break;
            }
            case STRING: {
                String statusStr = stateValue.unboxStr();
                status = this.getStringIndex(statusStr);
                break;
            }
            case DOUBLE: {
                status = (int)stateValue.unboxDouble();
                break;
            }
        }
        return status;
    }

    protected List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return trace != null ? Collections.singleton(trace) : Collections.emptyList();
    }

    private static class XmlTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private XmlTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            XmlEntry entry = (XmlEntry)((Object)element);
            if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnName)) {
                return entry.getName();
            }
            if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnId)) {
                return entry.getId();
            }
            if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnParentId)) {
                return entry.getParentId();
            }
            return XmlTimeGraphView.EMPTY_STRING;
        }
    }
}

