/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageTreeViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageXYViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.XYChartLegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;

public class CpuUsageView
extends TmfChartView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage";
    public static final @NonNull String CPU_USAGE_FOLLOW_CPU = "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage.FOLLOW_CPU";
    private static final double RESOLUTION = 0.4;

    public CpuUsageView() {
        super(Messages.CpuUsageView_Title);
    }

    public void createPartControl(Composite parent) {
        ITmfTrace trace;
        super.createPartControl(parent);
        TmfViewer tree = this.getLeftChildViewer();
        TmfXYChartViewer chart = this.getChartViewer();
        if (tree instanceof CpuUsageTreeViewer && chart instanceof CpuUsageXYViewer) {
            XYChartLegendImageProvider legendImageProvider = new XYChartLegendImageProvider((TmfCommonXAxisChartViewer)chart);
            CpuUsageTreeViewer cpuTree = (CpuUsageTreeViewer)tree;
            cpuTree.setTreeListener((ICheckboxTreeViewerListener)((CpuUsageXYViewer)chart));
            cpuTree.setLegendImageProvider((ILegendImageProvider)legendImageProvider);
        }
        if ((trace = TmfTraceManager.getInstance().getActiveTrace()) != null) {
            TmfXYChartViewer xyViewer;
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            TmfViewer treeViewer = this.getLeftChildViewer();
            if (treeViewer instanceof CpuUsageTreeViewer) {
                ((CpuUsageTreeViewer)treeViewer).traceSelected(signal);
            }
            if ((xyViewer = this.getChartViewer()) != null) {
                xyViewer.traceSelected(signal);
            }
        }
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        TmfXYChartSettings settings = new TmfXYChartSettings(Messages.CpuUsageXYViewer_Title, Messages.CpuUsageXYViewer_TimeXAxis, Messages.CpuUsageXYViewer_CpuYAxis, 0.4);
        CpuUsageXYViewer viewer = new CpuUsageXYViewer(parent, settings);
        viewer.setSendTimeAlignSignals(true);
        return viewer;
    }

    public TmfViewer createLeftChildViewer(Composite parent) {
        return new CpuUsageTreeViewer(parent);
    }

    private static void saveData(@NonNull ITmfTrace trace, @NonNull String key, @NonNull Object data) {
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData(key, data));
    }

    private static Object getData(@NonNull ITmfTrace trace, @NonNull String key) {
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
        return ctx.getData(key);
    }

    protected static @NonNull Set<@NonNull Integer> getCpus(@NonNull ITmfTrace trace) {
        Set<@NonNull Integer> data = (Set<Integer>)CpuUsageView.getData(trace, CPU_USAGE_FOLLOW_CPU);
        return data != null ? data : Collections.emptySet();
    }

    public void setFocus() {
        TmfXYChartViewer xyViewer = this.getChartViewer();
        if (xyViewer != null) {
            xyViewer.getControl().setFocus();
        }
    }

    @TmfSignalHandler
    public void cpuSelect(TmfCpuSelectedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        TmfXYChartViewer xyViewer = this.getChartViewer();
        TmfViewer viewer = this.getLeftChildViewer();
        if (xyViewer instanceof CpuUsageXYViewer && viewer instanceof CpuUsageTreeViewer) {
            int core;
            TreeSet<Integer> data = (TreeSet<Integer>)CpuUsageView.getData(trace, CPU_USAGE_FOLLOW_CPU);
            if (data == null) {
                data = new TreeSet<Integer>();
                CpuUsageView.saveData(trace, CPU_USAGE_FOLLOW_CPU, data);
            }
            if ((core = signal.getCore()) >= 0) {
                data.add(core);
            } else {
                data.clear();
            }
            xyViewer.refresh();
            ((CpuUsageXYViewer)xyViewer).setTitle();
            CpuUsageTreeViewer treeViewer = (CpuUsageTreeViewer)viewer;
            treeViewer.updateContent(treeViewer.getWindowStartTime(), treeViewer.getWindowEndTime(), false);
        }
    }
}

