/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNWithPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.refactor.CopyResourceFromHookOperation;
import org.eclipse.team.svn.core.operation.local.refactor.CopyResourceWithHistoryOperation;
import org.eclipse.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.eclipse.team.svn.core.operation.local.refactor.MoveResourceOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ILoggedOperationFactory;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SVNTeamMoveDeleteHook
implements IMoveDeleteHook {
    private static ScheduledExecutorService sPool = Executors.newScheduledThreadPool(1);
    private static ScheduledFuture sf;
    private static ArrayList<IResource> deleteQueue;

    static {
        deleteQueue = new ArrayList();
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        return this.doScheduledDelete(tree, (IResource)file, updateFlags, monitor);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        return this.doScheduledDelete(tree, (IResource)folder, updateFlags, monitor);
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        return this.doMove(tree, (IResource)source, (IResource)destination, updateFlags, monitor);
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        return this.doMove(tree, (IResource)source, (IResource)destination, updateFlags, monitor);
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    protected boolean doMove(IResourceTree tree, IResource source, IResource destination, int updateFlags, IProgressMonitor monitor) {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(source);
        if (!IStateFilter.SF_VERSIONED.accept(local)) {
            return FileUtility.isSVNInternals(source);
        }
        MoveResourceOperation moveOp = new MoveResourceOperation(source, destination);
        CompositeOperation op = new CompositeOperation(moveOp.getId(), moveOp.getMessagesClass());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(new IResource[]{source, destination});
        op.add(saveOp);
        if ((updateFlags & 2) != 0) {
            op.add(new SaveToLocalHistoryOperation(tree, source));
        }
        if (IStateFilter.SF_INTERNAL_INVALID.accept(local = SVNRemoteStorage.instance().asLocalResource((IResource)destination.getParent())) || IStateFilter.SF_LINKED.accept(local) || IStateFilter.SF_OBSTRUCTED.accept(local) || !moveOp.isAllowed()) {
            CopyResourceFromHookOperation copyLocalResourceOp = new CopyResourceFromHookOperation(source, destination, 0);
            op.add(copyLocalResourceOp);
            DeleteResourceOperation deleteOp = new DeleteResourceOperation(source);
            op.add(deleteOp, new IActionOperation[]{copyLocalResourceOp});
            op.add(new TrackMoveResultOperation(tree, source, destination, new IActionOperation[]{copyLocalResourceOp, deleteOp}));
            op.add(new RestoreProjectMetaOperation(saveOp));
            op.add(new RefreshResourcesOperation(new IResource[]{source, destination}, 2, RefreshResourcesOperation.REFRESH_ALL));
        } else if (IStateFilter.SF_UNVERSIONED.accept(local)) {
            IResource[] scheduledForAddition = FileUtility.getOperableParents(new IResource[]{destination}, IStateFilter.SF_UNVERSIONED, true);
            AddToSVNWithPropertiesOperation addToSVNOp = new AddToSVNWithPropertiesOperation(scheduledForAddition, false);
            op.add(addToSVNOp);
            if (this.checkBug281557(source, monitor)) {
                CopyResourceWithHistoryOperation copyOp = new CopyResourceWithHistoryOperation(source, destination);
                op.add(copyOp);
                CopyResourceFromHookOperation copyLocalResourceOp = new CopyResourceFromHookOperation(source, destination, 2);
                op.add(copyLocalResourceOp);
                DeleteResourceOperation deleteOp = new DeleteResourceOperation(source);
                op.add(deleteOp, new IActionOperation[]{copyOp, copyLocalResourceOp});
                op.add(new TrackMoveResultOperation(tree, source, destination, new IActionOperation[]{copyOp, copyLocalResourceOp, deleteOp}));
            } else {
                op.add(moveOp, new IActionOperation[]{addToSVNOp});
                op.add(new TrackMoveResultOperation(tree, source, destination, new IActionOperation[]{moveOp}));
            }
            op.add(new RestoreProjectMetaOperation(saveOp));
            ArrayList<IResource> fullSet = new ArrayList<IResource>(Arrays.asList(scheduledForAddition));
            fullSet.addAll(Arrays.asList(source, destination));
            op.add(new RefreshResourcesOperation(fullSet.toArray(new IResource[fullSet.size()]), 2, RefreshResourcesOperation.REFRESH_ALL));
        } else {
            if (this.checkBug281557(source, monitor)) {
                CopyResourceWithHistoryOperation copyOp = new CopyResourceWithHistoryOperation(source, destination);
                op.add(copyOp);
                CopyResourceFromHookOperation copyLocalResourceOp = new CopyResourceFromHookOperation(source, destination, 2);
                op.add(copyLocalResourceOp);
                DeleteResourceOperation deleteOp = new DeleteResourceOperation(source);
                op.add(deleteOp, new IActionOperation[]{copyOp, copyLocalResourceOp});
                op.add(new TrackMoveResultOperation(tree, source, destination, new IActionOperation[]{copyOp, copyLocalResourceOp, deleteOp}));
            } else {
                op.add(moveOp);
                op.add(new TrackMoveResultOperation(tree, source, destination, new IActionOperation[]{moveOp}));
            }
            op.add(new RestoreProjectMetaOperation(saveOp));
            op.add(new RefreshResourcesOperation(new IResource[]{source, destination}, 2, RefreshResourcesOperation.REFRESH_ALL));
        }
        this.runOperation(op, monitor);
        return true;
    }

    protected boolean checkBug281557(IResource source, IProgressMonitor monitor) {
        if (source.getType() == 1 && SVNTeamPlugin.instance().getOptionProvider().getString("svnConnectorId").startsWith("org.eclipse.team.svn.connector.javahl")) {
            GetPropertiesOperation op = new GetPropertiesOperation(source);
            this.runOperation(op, monitor);
            SVNProperty[] props = op.getProperties();
            if (props != null) {
                int i = 0;
                while (i < props.length) {
                    if ("svn:keywords".equals(props[i].name)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected void runOperation(IActionOperation op, IProgressMonitor monitor) {
        ProgressMonitorUtility.doTaskExternal(op, monitor, new ILoggedOperationFactory(){

            public IActionOperation getLogged(IActionOperation operation) {
                IActionOperation wrappedOperation = SVNTeamPlugin.instance().getOptionProvider().getLoggedOperationFactory().getLogged(operation);
                operation.setConsoleStream(wrappedOperation.getConsoleStream());
                return operation;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doScheduledDelete(IResourceTree tree, IResource resource, int updateFlags, IProgressMonitor monitor) {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if (IStateFilter.SF_INTERNAL_INVALID.accept(local) || IStateFilter.SF_NOTEXISTS.accept(local) || IStateFilter.SF_UNVERSIONED.accept(local)) {
            return FileUtility.isSVNInternals(resource);
        }
        if (resource.getType() == 1) {
            if ((updateFlags & 2) != 0) {
                tree.addToLocalHistory((IFile)resource);
            }
            tree.deletedFile((IFile)resource);
        } else {
            tree.deletedFolder((IFolder)resource);
        }
        ArrayList<IResource> arrayList = deleteQueue;
        synchronized (arrayList) {
            deleteQueue.add(resource);
            if (deleteQueue.size() > 1 && sf != null) {
                sf.cancel(false);
                sf = null;
            }
            if (deleteQueue.size() > 0) {
                sf = sPool.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        IResource[] resources;
                        ArrayList arrayList = deleteQueue;
                        synchronized (arrayList) {
                            resources = deleteQueue.toArray(new IResource[deleteQueue.size()]);
                            deleteQueue.clear();
                        }
                        if (resources.length > 0) {
                            resources = FileUtility.shrinkChildNodes(resources);
                            DeleteResourceOperation mainOp = new DeleteResourceOperation(resources);
                            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
                            op.add(saveOp);
                            op.add(mainOp);
                            op.add(new RestoreProjectMetaOperation(saveOp));
                            op.add(new RefreshResourcesOperation(resources, 2, RefreshResourcesOperation.REFRESH_CACHE));
                            IActionOperation wrappedOperation = SVNTeamPlugin.instance().getOptionProvider().getLoggedOperationFactory().getLogged(op);
                            ProgressMonitorUtility.doTaskScheduledDefault(wrappedOperation);
                        }
                    }
                }, 200L, TimeUnit.MILLISECONDS);
            }
        }
        return true;
    }

    protected static class SaveToLocalHistoryOperation
    extends AbstractActionOperation {
        protected IResourceTree tree;
        protected IResource resource;

        public SaveToLocalHistoryOperation(IResourceTree tree, IResource resource) {
            super("Operation_TrackDeleteResult", SVNMessages.class);
            this.tree = tree;
            this.resource = resource;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            if (this.resource.getType() == 1) {
                this.tree.addToLocalHistory((IFile)this.resource);
            }
        }
    }

    protected static class TrackMoveResultOperation
    extends AbstractActionOperation {
        protected IResourceTree tree;
        protected IResource source;
        protected IResource destination;
        protected IActionOperation[] operationsToTrack;

        public TrackMoveResultOperation(IResourceTree tree, IResource source, IResource destination, IActionOperation[] operationsToTrack) {
            super("Operation_TrackMoveResult", SVNMessages.class);
            this.tree = tree;
            this.source = source;
            this.destination = destination;
            this.operationsToTrack = operationsToTrack;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            boolean failed = false;
            if (this.operationsToTrack != null) {
                int i = 0;
                while (i < this.operationsToTrack.length) {
                    if (this.operationsToTrack[i].getExecutionState() == 1) {
                        this.tree.failed(this.operationsToTrack[i].getStatus());
                        failed = true;
                    }
                    ++i;
                }
            }
            if (!failed) {
                if (this.source.getType() == 1) {
                    this.tree.movedFile((IFile)this.source, (IFile)this.destination);
                } else if (this.source.getType() == 2) {
                    this.tree.movedFolderSubtree((IFolder)this.source, (IFolder)this.destination);
                }
            }
        }
    }
}

