/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;

public final class ProblemsAssistContributor
extends PropertyEditorAssistContributor {
    private SapphirePart part;
    private Listener partValidationListener;

    public ProblemsAssistContributor() {
        this.setId("System.ProblemsContributor");
        this.setPriority(210);
    }

    @Override
    public void init(SapphirePart part) {
        this.part = part;
        if (this.part != null) {
            this.partValidationListener = new FilteredListener<PartValidationEvent>(){

                protected void handleTypedEvent(PartValidationEvent event) {
                    ProblemsAssistContributor.this.broadcast();
                }
            };
            this.part.attach(this.partValidationListener);
        }
    }

    @Override
    public void contribute(PropertyEditorAssistContext context) {
        Status validation = this.part.validation();
        if (validation.children().isEmpty()) {
            ProblemsAssistContributor.contribute(context, validation);
        } else {
            for (Status child : validation.children()) {
                ProblemsAssistContributor.contribute(context, child);
            }
        }
    }

    private static void contribute(PropertyEditorAssistContext context, Status status) {
        Status.Severity valResultSeverity = status.severity();
        ImageData image = null;
        if (valResultSeverity == Status.Severity.ERROR) {
            image = (ImageData)ImageData.readFromClassLoader(SwtResourceCache.class, (String)"Error.png").required();
        } else if (valResultSeverity == Status.Severity.WARNING) {
            image = (ImageData)ImageData.readFromClassLoader(SwtResourceCache.class, (String)"Warning.png").required();
        }
        if (image != null) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<li style=\"image\" value=\"problem\">" + ProblemsAssistContributor.escapeForXml(status.message()) + "</li>");
            contribution.image("problem", image);
            PropertyEditorAssistSection section = context.getSection("problems");
            section.addContribution(contribution.create());
        }
    }

    @Override
    public void dispose() {
        if (this.partValidationListener != null) {
            this.part.detach(this.partValidationListener);
        }
    }
}

