/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.policies;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ui.LineStyle;
import org.eclipse.sapphire.ui.diagram.shape.def.SelectionPresentation;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.sapphire.ui.swt.gef.figures.IShapeFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramNodeResizeTracker;
import org.eclipse.swt.graphics.Cursor;

public class DiagramNodeResizableEditPolicy
extends ResizableEditPolicy {
    private DiagramResourceCache resourceCache;

    public DiagramNodeResizableEditPolicy(DiagramResourceCache resourceCache) {
        this.resourceCache = resourceCache;
    }

    private SelectionPresentation getSelectionPresentation() {
        DiagramNodeEditPart owner = (DiagramNodeEditPart)this.getHost();
        return owner.getCastedModel().getShapeModel().getShapePresentation().getSelectionPresentation();
    }

    private org.eclipse.swt.graphics.Color getOutlineColor() {
        SelectionPresentation selectionPresentation = this.getSelectionPresentation();
        if (selectionPresentation != null) {
            return this.resourceCache.getColor((Color)selectionPresentation.getColor().content());
        }
        return this.resourceCache.getOutlineColor();
    }

    protected void createResizeHandle(List handles, int direction) {
        if ((this.getResizeDirections() & direction) == direction) {
            ResizeHandle handle = new ResizeHandle((GraphicalEditPart)this.getHost(), direction){

                protected org.eclipse.swt.graphics.Color getBorderColor() {
                    return this.isPrimary() ? ColorConstants.white : DiagramNodeResizableEditPolicy.this.getOutlineColor();
                }

                protected org.eclipse.swt.graphics.Color getFillColor() {
                    return this.isPrimary() ? DiagramNodeResizableEditPolicy.this.getOutlineColor() : ColorConstants.white;
                }
            };
            handle.setDragTracker((DragTracker)this.getResizeTracker(direction));
            handle.setCursor(Cursors.getDirectionalCursor((int)direction, (boolean)this.getHostFigure().isMirrored()));
            handles.add(handle);
        } else {
            this.createDragHandle(handles, direction);
        }
    }

    protected void createMoveHandle(List handles) {
        if (this.isDragAllowed()) {
            MoveHandle moveHandle = new MoveHandle((GraphicalEditPart)this.getHost());
            moveHandle.setDragTracker((DragTracker)this.getDragTracker());
            moveHandle.setCursor(Cursors.SIZEALL);
            LineBorder border = new LineBorder(this.resourceCache.getOutlineColor(), 1, 2);
            SelectionPresentation selectionPresentation = this.getSelectionPresentation();
            if (selectionPresentation != null) {
                border.setColor(this.resourceCache.getColor((Color)selectionPresentation.getColor().content()));
                border.setStyle(FigureUtil.convertLineStyle((LineStyle)selectionPresentation.getStyle().content()));
                border.setWidth(((Integer)selectionPresentation.getWeight().content()).intValue());
            }
            moveHandle.setBorder((Border)border);
            handles.add(moveHandle);
        } else {
            ResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), (List)handles, (DragTracker)this.getSelectTracker(), (Cursor)SharedCursors.ARROW);
        }
    }

    protected ResizeTracker getResizeTracker(int direction) {
        return new DiagramNodeResizeTracker((GraphicalEditPart)this.getHost(), direction);
    }

    private IShapeFigure getNodeFigure() {
        DiagramNodeEditPart part = (DiagramNodeEditPart)this.getHost();
        if (part.getFigure() instanceof IShapeFigure) {
            return (IShapeFigure)part.getFigure();
        }
        return null;
    }

    protected void showFocus() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setFocus(true);
        }
    }

    protected void hideSelection() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setSelected(false);
            shapeFigure.setFocus(false);
            this.removeSelectionHandles();
        }
    }

    protected void showPrimarySelection() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setSelected(true);
            shapeFigure.setFocus(true);
            this.addSelectionHandles();
        }
    }

    protected void showSelection() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setSelected(true);
            shapeFigure.setFocus(false);
            this.addSelectionHandles();
        }
    }
}

