/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeFactoryModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeUtil;
import org.eclipse.sapphire.ui.swt.gef.policies.ShapeFactoryLayoutEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapeFactoryPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ShapeFactoryEditPart
extends ShapeEditPart {
    public ShapeFactoryEditPart(DiagramConfigurationManager configManager) {
        super(configManager);
    }

    @Override
    protected IFigure createFigure() {
        return null;
    }

    public IFigure getContentPane() {
        ShapeFactoryModel model = (ShapeFactoryModel)this.getModel();
        ContainerShapePresentation parentPresentation = this.getParentContainer(model.getShapePresentation());
        IFigure parentFigure = parentPresentation.getFigure();
        return parentFigure;
    }

    protected List<ShapeModel> getModelChildren() {
        ArrayList<ShapeModel> returnedModelChildren = new ArrayList<ShapeModel>();
        ShapeFactoryModel containerModel = this.getCastedModel();
        returnedModelChildren.addAll(containerModel.getChildren());
        return returnedModelChildren;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        ShapeFactoryPresentation factory = (ShapeFactoryPresentation)this.getCastedModel().getShapePresentation();
        int newIndex = index + factory.getIndex();
        ShapeModel shapeModel = (ShapeModel)childEditPart.getModel();
        ShapePresentation shapePresentation = shapeModel.getShapePresentation();
        ContainerShapePresentation parentPresentation = this.getParentContainer(shapePresentation);
        Object layoutConstraint = ShapeUtil.getLayoutConstraint(shapePresentation, parentPresentation.getLayout());
        IFigure parentFigure = parentPresentation.getFigure();
        parentFigure.add(child, layoutConstraint, newIndex);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        IFigure parentFig = this.getContentPane();
        parentFig.remove(child);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ShapeFactoryLayoutEditPolicy());
    }

    public ShapeFactoryModel getCastedModel() {
        return (ShapeFactoryModel)this.getModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("SHAPE_ADD") || prop.equals("SHAPE_DELETE") || prop.equals("SHAPE_REORDER")) {
            this.refreshChildren();
            this.getNodeEditPart().refresh();
        }
    }
}

