/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.util.ListFactory;

public final class DeferredFunction
extends Function {
    @Text(value="Function {0} with {1} parameters is undefined.")
    private static LocalizableText undefinedFunctionMessageExt;
    @Text(value="Function {0} with one parameter is undefined.")
    private static LocalizableText undefinedFunctionMessageExt1;
    @Text(value="Function {0}( {1} ) is undefined.")
    private static LocalizableText undefinedFunctionMessage;
    private final String name;

    static {
        LocalizableText.init(DeferredFunction.class);
    }

    public DeferredFunction(String name) {
        this.name = name;
    }

    public static DeferredFunction create(String name, List<Function> operands) {
        DeferredFunction function = new DeferredFunction(name);
        function.init(operands);
        return function;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        final int arity = this.operands().size();
        List<Function> functions = SapphireModelingExtensionSystem.functions(this.name, arity);
        if (functions.isEmpty()) {
            if (arity == 1) {
                throw new FunctionException(undefinedFunctionMessageExt1.format(this.name));
            }
            throw new FunctionException(undefinedFunctionMessageExt.format(this.name, arity));
        }
        ListFactory<Function> typedFunctionsListFactory = ListFactory.start();
        Function genericFunction = null;
        for (Function f : functions) {
            f.init(this.operands());
            if (f.signature() == null) {
                if (genericFunction != null) continue;
                genericFunction = f;
                continue;
            }
            typedFunctionsListFactory.add(f);
        }
        final List typedFunctions = typedFunctionsListFactory.result();
        final int typedFunctionsCount = typedFunctions.size();
        final Function genericFunctionFinal = genericFunction;
        if (genericFunction != null && typedFunctionsCount == 0) {
            return genericFunction.evaluate(context);
        }
        return new FunctionResult(this, context){
            private Function baseFunction;
            private FunctionResult baseFunctionResult;
            private Listener listener;

            @Override
            protected Object evaluate() {
                Function function = this.findFunction();
                if (function == null) {
                    if (this.baseFunctionResult != null) {
                        this.baseFunctionResult.dispose();
                    }
                    this.baseFunction = null;
                    this.baseFunctionResult = null;
                    StringBuilder buf = new StringBuilder();
                    for (FunctionResult operand : this.operands()) {
                        Object value;
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        if ((value = operand.value()) == null) {
                            buf.append("null");
                            continue;
                        }
                        buf.append(value.getClass().getName());
                    }
                    throw new FunctionException(undefinedFunctionMessage.format(DeferredFunction.this.name(), buf.toString()));
                }
                if (function != this.baseFunction) {
                    if (this.baseFunctionResult != null) {
                        this.baseFunctionResult.dispose();
                    }
                    this.baseFunction = function;
                    this.baseFunctionResult = function.evaluate(this.context());
                    if (this.listener == null) {
                        this.listener = new Listener(){

                            @Override
                            public void handle(Event event) {
                                this.refresh();
                            }
                        };
                    }
                    this.baseFunctionResult.attach(this.listener);
                }
                return this.baseFunctionResult.value();
            }

            private Function findFunction() {
                Function function = null;
                int[] scores = new int[typedFunctionsCount];
                int i = 0;
                while (i < arity) {
                    Object parameter = this.operand(i);
                    if (parameter != null) {
                        int j = 0;
                        while (j < typedFunctionsCount) {
                            int score = scores[j];
                            if (score != -1) {
                                Class<?> declaredParameterType = ((Function)typedFunctions.get(j)).signature().get(i);
                                int scoreForParameter = this.score(declaredParameterType, parameter.getClass());
                                if (scoreForParameter == -1) {
                                    Object converted = null;
                                    try {
                                        converted = this.cast(parameter, declaredParameterType);
                                    }
                                    catch (Exception exception) {}
                                    scores[j] = converted == null ? -1 : score + 100;
                                } else {
                                    scores[j] = score + scoreForParameter;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                int lowestScore = Integer.MAX_VALUE;
                int i2 = 0;
                while (i2 < typedFunctionsCount) {
                    int score = scores[i2];
                    if (score != -1 && score < lowestScore) {
                        function = (Function)typedFunctions.get(i2);
                        lowestScore = score;
                    }
                    ++i2;
                }
                if (function == null) {
                    function = genericFunctionFinal;
                }
                return function;
            }

            private int score(Class<?> declaredParameterType, Class<?> actualParameterType) {
                int distance;
                if (actualParameterType == null) {
                    distance = -1;
                } else if (declaredParameterType == actualParameterType) {
                    distance = 0;
                } else {
                    distance = this.score(declaredParameterType, actualParameterType.getSuperclass());
                    if (distance != -1) {
                        ++distance;
                    } else {
                        Class<?>[] classArray = actualParameterType.getInterfaces();
                        int n = classArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> intrfc = classArray[n2];
                            distance = this.score(declaredParameterType, intrfc);
                            if (distance != -1) {
                                ++distance;
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                return distance;
            }

            @Override
            public void dispose() {
                super.dispose();
                if (this.baseFunctionResult != null) {
                    this.baseFunctionResult.dispose();
                }
            }
        };
    }
}

