/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.ui.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlStateRuleType;
import org.eclipse.swt.widgets.Button;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlStateRuleUtil {
    private static final boolean DEBUG = false;

    public static void addSources(ControlStateRuleType controlStateRuleType, Map<String, Button> buttonMap, Set<Button> buttonSources) throws CoreException {
        if (controlStateRuleType.getNot() != null) {
            ControlStateRuleUtil.addSources(controlStateRuleType.getNot(), buttonMap, buttonSources);
        }
        if (controlStateRuleType.getAnd() != null) {
            ControlStateRuleUtil.addSources(controlStateRuleType.getAnd(), buttonMap, buttonSources);
        }
        if (controlStateRuleType.getOr() != null) {
            ControlStateRuleUtil.addSources(controlStateRuleType.getOr(), buttonMap, buttonSources);
        }
        if (controlStateRuleType.getButton() != null) {
            String buttonKey = controlStateRuleType.getButton();
            Button button = buttonMap.get(buttonKey);
            if (button != null) {
                buttonSources.add(button);
            } else {
                throw CoreExceptionUtils.newException((String)NLS.bind((String)Messages.ControlStateRuleUtil_0, (Object)controlStateRuleType.getButton()));
            }
        }
        if (controlStateRuleType.getAttribute() != null) {
            String attribute = controlStateRuleType.getAttribute();
            if (attribute == null) {
                throw CoreExceptionUtils.newException((String)NLS.bind((String)Messages.ControlStateRuleUtil_1, (Object)controlStateRuleType.getAttribute()));
            }
            String value = controlStateRuleType.getValue();
            if (value == null) {
                throw CoreExceptionUtils.newException((String)NLS.bind((String)Messages.ControlStateRuleUtil_2, (Object)controlStateRuleType.getAttribute()));
            }
        }
    }

    public static void addSources(ControlStateRuleType.Not controlStateRuleTypeNot, Map<String, Button> buttonMap, Set<Button> buttonSources) throws CoreException {
        ControlStateRuleUtil.addSources(controlStateRuleTypeNot.getRule(), buttonMap, buttonSources);
    }

    public static void addSources(ControlStateRuleType.And controlStateRuleTypeAnd, Map<String, Button> buttonMap, Set<Button> buttonSources) throws CoreException {
        List list = controlStateRuleTypeAnd.getRule();
        for (ControlStateRuleType rule : list) {
            ControlStateRuleUtil.addSources(rule, buttonMap, buttonSources);
        }
    }

    public static void addSources(ControlStateRuleType.Or controlStateRuleTypeOr, Map<String, Button> buttonMap, Set<Button> buttonSources) throws CoreException {
        List list = controlStateRuleTypeOr.getRule();
        for (ControlStateRuleType rule : list) {
            ControlStateRuleUtil.addSources(rule, buttonMap, buttonSources);
        }
    }

    public static boolean evaluate(ControlStateRuleType controlStateRuleType, Map<String, Button> buttonMap, IVariableMap varianbleMap) {
        if (controlStateRuleType.getNot() != null) {
            boolean result = ControlStateRuleUtil.evaluate(controlStateRuleType.getNot(), buttonMap, varianbleMap);
            return result;
        }
        if (controlStateRuleType.getAnd() != null) {
            boolean result = ControlStateRuleUtil.evaluate(controlStateRuleType.getAnd(), buttonMap, varianbleMap);
            return result;
        }
        if (controlStateRuleType.getOr() != null) {
            boolean result = ControlStateRuleUtil.evaluate(controlStateRuleType.getOr(), buttonMap, varianbleMap);
            return result;
        }
        if (controlStateRuleType.getButton() != null) {
            boolean result = ControlStateRuleUtil.evaluate(controlStateRuleType.getButton(), buttonMap, controlStateRuleType.isSelected());
            return result;
        }
        if (controlStateRuleType.getAttribute() != null) {
            boolean result = ControlStateRuleUtil.evaluate(controlStateRuleType.getAttribute(), varianbleMap, controlStateRuleType.getValue());
            return result;
        }
        boolean result = true;
        return result;
    }

    public static boolean evaluate(ControlStateRuleType.Not controlStateRuleTypeNot, Map<String, Button> buttonMap, IVariableMap varianbleMap) {
        boolean result = !ControlStateRuleUtil.evaluate(controlStateRuleTypeNot.getRule(), buttonMap, varianbleMap);
        return result;
    }

    public static boolean evaluate(ControlStateRuleType.And controlStateRuleTypeAnd, Map<String, Button> buttonMap, IVariableMap varianbleMap) {
        List list = controlStateRuleTypeAnd.getRule();
        for (ControlStateRuleType rule : list) {
            if (ControlStateRuleUtil.evaluate(rule, buttonMap, varianbleMap)) continue;
            boolean result = false;
            return result;
        }
        boolean result = true;
        return result;
    }

    public static boolean evaluate(ControlStateRuleType.Or controlStateRuleTypeOr, Map<String, Button> buttonMap, IVariableMap varianbleMap) {
        List list = controlStateRuleTypeOr.getRule();
        for (ControlStateRuleType rule : list) {
            if (!ControlStateRuleUtil.evaluate(rule, buttonMap, varianbleMap)) continue;
            boolean result = true;
            return result;
        }
        boolean result = false;
        return result;
    }

    public static boolean evaluate(String ruleButton, Map<String, Button> buttonMap, boolean ruleSelected) {
        Button button = buttonMap.get(ruleButton);
        if (button != null) {
            boolean result = ruleSelected == button.getSelection();
            return result;
        }
        boolean result = false;
        return result;
    }

    public static boolean evaluate(String ruleAttribute, IVariableMap variableMap, String ruleValue) {
        AttributeType attributeType;
        if (ruleValue != null) {
            attributeType = variableMap.get(ruleAttribute);
            if (attributeType != null && attributeType.getValue() != null) {
                boolean result = ruleValue.equals(attributeType.getValue().toString());
                return result;
            }
        } else {
            attributeType = variableMap.get(ruleAttribute);
            if (attributeType != null) {
                boolean result = true;
                return result;
            }
        }
        boolean result = false;
        return result;
    }
}

