/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.popup.actions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.Utility;
import org.eclipse.ptp.pldt.common.util.ViewActivator;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBarrierAnalysisResults;
import org.eclipse.ptp.pldt.mpi.analysis.messages.Messages;
import org.eclipse.ptp.pldt.mpi.analysis.view.MPIArtifactMarkingVisitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionDelegate;

public class ShowMatchSet
extends ActionDelegate
implements IEditorActionDelegate {
    protected CEditor editor_ = null;
    protected MPIBarrierAnalysisResults results_ = null;
    private static final boolean traceOn = false;
    protected static final String TITLE = Messages.ShowMatchSet_showMatchSet;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof CEditor) {
            this.editor_ = (CEditor)targetEditor;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        TextSelection selection = null;
        if (this.editor_ != null && this.editor_.getSelectionProvider().getSelection() instanceof TextSelection) {
            selection = (TextSelection)this.editor_.getSelectionProvider().getSelection();
        }
        if (selection != null) {
            this.showMatchSet(selection);
        } else {
            this.showMessage(TITLE, Messages.ShowMatchSet_noSelectionsMade);
        }
    }

    protected void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)ShowMatchSet.getStandardDisplay().getActiveShell(), (String)title, (String)message);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void showMatchSet(TextSelection selection) {
        String fileName;
        BarrierTable.BarrierInfo barrier;
        if (selection.getOffset() == 0 && selection.getLength() == 0) {
            this.showMessage(TITLE, Messages.ShowMatchSet_noSelectionsMande);
            return;
        }
        IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            int depth = 2;
            wsResource.deleteMarkers("org.eclipse.ptp.pldt.mpi.analysis.mpiBarrierMatchingSetMarker", false, depth);
        }
        catch (CoreException e) {
            System.out.println("RM: exception deleting markers.");
            e.printStackTrace();
        }
        this.results_ = MPIBarrierAnalysisResults.getAnalysisResults();
        if (this.results_ == null) {
            this.showMessage(TITLE, Messages.ShowMatchSet_noBarrierAnalysisHasBeenPerformed);
            return;
        }
        IEditorInput ieu = this.editor_.getEditorInput();
        IFile file = null;
        if (ieu instanceof IFileEditorInput) {
            file = ((IFileEditorInput)ieu).getFile();
        }
        if ((barrier = this.findSelectedBarrier(fileName = file.getFullPath().toOSString(), selection.getOffset())) == null) {
            this.showMessage(TITLE, Messages.ShowMatchSet_PleaseSelectABarrier);
            return;
        }
        this.removeMarkers(this.editor_.getDocumentProvider().getAnnotationModel((Object)this.editor_.getEditorInput()));
        MPIArtifactMarkingVisitor visitor = new MPIArtifactMarkingVisitor("org.eclipse.ptp.pldt.mpi.analysis.mpiBarrierMatchingSetMarker");
        String parentName = "BarrierSetName";
        for (BarrierTable.BarrierInfo matchedBar : barrier.getMatchingSet()) {
            this.showNode((IASTNode)matchedBar.getFunc().getFunctionNameExpression(), "org.eclipse.ptp.pldt.mpi.analysis.matchset");
            ScanReturn sr = new ScanReturn();
            visitor.visitFile(matchedBar.getResource(), sr.getArtifactList());
        }
        ViewActivator.activateView((String)"org.eclipse.ptp.pldt.mpi.analysis.view.MPIBarrierMatchingSetTableView");
    }

    protected BarrierTable.BarrierInfo findSelectedBarrier(String filename, int offset) {
        BarrierTable table = this.results_.getBarrierTable();
        Enumeration<List<BarrierTable.BarrierInfo>> e = table.getTable().elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            for (BarrierTable.BarrierInfo bar : list) {
                if (!bar.getFileName().endsWith(filename) || bar.getSourceInfo().getStart() != offset) continue;
                return bar;
            }
        }
        return null;
    }

    protected void removeMarkers(IAnnotationModel am) {
        LinkedList ais = new LinkedList();
        Iterator ai = am.getAnnotationIterator();
        while (ai.hasNext()) {
            ais.add(ai.next());
        }
        for (Annotation a : ais) {
            if (!a.getType().equals("org.eclipse.ptp.pldt.mpi.analysis.matchset")) continue;
            am.removeAnnotation(a);
        }
    }

    protected void showNode(IASTNode node, String markerType) {
        Utility.Location l = Utility.getLocation((IASTNode)node);
        IAnnotationModel am = this.editor_.getDocumentProvider().getAnnotationModel((Object)this.editor_.getEditorInput());
        Annotation a = new Annotation(markerType, true, "Hi");
        int end = l.high_ - l.low_ + 1;
        Position p = new Position(l.low_, end);
        am.addAnnotation(a, p);
    }
}

