/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.ImportDeclaration;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.compiler.ast.nodes.StaticDispatch;
import org.eclipse.php.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasField;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.model.PerFileModelAccessCache;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPNamespaceConstantType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPSelectionEngine
extends ScriptSelectionEngine {
    private static final String OPEN_BRACE = "(";
    private static final String PROTECTED = "protected";
    private static final String PUBLIC = "public";
    private static final String OBJECT_OPERATOR = "->";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    private static final String CONST = "const";
    private static final String THIS = "this";
    private static final String STATIC = "static";
    private static final String PRIVATE = "private";
    private static final String VAR = "var";
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";
    private static final String NEW = "new";
    private static final String INTERFACE = "interface";
    private static final String CLASS = "class";
    private static final String FUNCTION = "function";
    private static final String INSTEADOF = "insteadof";
    private static final String AS = "as";
    private static final String GOTO = "goto";
    private static final IType[] EMPTY = new IType[0];
    private PHPVersion phpVersion;

    public IModelElement[] select(IModuleSource sourceUnit, int offset, int end) {
        IStructuredDocument document;
        PerFileModelAccessCache cache;
        ISourceModule sourceModule;
        block36: {
            block34: {
                if (!PHPCorePlugin.toolkitInitialized) {
                    return EMPTY;
                }
                if (end < offset) {
                    end = offset + 1;
                }
                sourceModule = (ISourceModule)sourceUnit.getModelElement();
                this.phpVersion = ProjectOptions.getPHPVersion(sourceModule.getScriptProject().getProject());
                cache = new PerFileModelAccessCache(sourceModule);
                try {
                    IModelElement[] elements = this.internalASTResolve(sourceModule, cache, offset, end);
                    if (elements != null) {
                        Collection<IModelElement> filtered = PHPModelUtils.filterElements(sourceModule, Arrays.asList(elements), null, null);
                        return filtered.toArray(new IModelElement[filtered.size()]);
                    }
                }
                catch (ModelException e) {
                    if (e.isDoesNotExist()) break block34;
                    PHPCorePlugin.log(e);
                }
            }
            document = null;
            IStructuredModel structuredModel = null;
            try {
                try {
                    IFile file = (IFile)sourceUnit.getModelElement().getResource();
                    if (file != null) {
                        if (file.exists()) {
                            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                            document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                        } else {
                            document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                            document.set(sourceUnit.getSourceContents());
                        }
                    }
                }
                catch (Exception e) {
                    PHPCorePlugin.log(e);
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        if (document == null) {
            return EMPTY;
        }
        IModelElement[] elements = null;
        try {
            elements = this.internalResolve(document, sourceModule, cache, offset, end);
        }
        catch (BadLocationException e1) {
            PHPCorePlugin.log(e1);
        }
        catch (ModelException e) {
            if (!e.isDoesNotExist()) {
                PHPCorePlugin.log(e);
            }
        }
        catch (CoreException e1) {
            PHPCorePlugin.log(e1);
        }
        if (elements == null) {
            return EMPTY;
        }
        Collection<IModelElement> filtered = PHPModelUtils.filterElements(sourceModule, Arrays.asList(elements), cache, null);
        if (filtered.size() == 0) {
            return EMPTY;
        }
        IStructuredDocumentRegion sRegion = document.getRegionAtCharacterOffset(offset);
        if (sRegion != null) {
            ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
            IStructuredDocumentRegion container = sRegion;
            if (tRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
                int elementStart;
                TextSequence statement;
                IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
                try {
                    tRegion = phpScriptRegion.getPHPToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                }
                catch (BadLocationException badLocationException) {
                    tRegion = null;
                }
                if (tRegion != null && (statement = PHPTextSequenceUtilities.getStatement((elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart()) + tRegion.getLength(), sRegion, true)).length() != 0) {
                    int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statement.length());
                    int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, endPosition, true);
                    String elementName = startPosition < 0 ? "" : statement.subSequence(startPosition, endPosition).toString();
                    if ((elementName = PHPModelUtils.extractElementName(elementName)) != null && elementName.length() > 0) {
                        LinkedList<IModelElement> result = new LinkedList<IModelElement>();
                        for (IModelElement modelElement : filtered) {
                            if (modelElement instanceof AliasField) {
                                AliasField aliasField = (AliasField)modelElement;
                                if (!aliasField.getAlias().equals(elementName)) continue;
                                result.add(aliasField.getField());
                                continue;
                            }
                            if (modelElement instanceof IField) {
                                String fieldName = elementName;
                                if (!fieldName.startsWith("$")) {
                                    fieldName = "$" + fieldName;
                                }
                                if (!modelElement.getElementName().equals(fieldName) && !modelElement.getElementName().equals(elementName)) continue;
                                result.add(modelElement);
                                continue;
                            }
                            if (!modelElement.getElementName().equals(elementName)) continue;
                            result.add(modelElement);
                        }
                        return result.toArray(new IModelElement[result.size()]);
                    }
                }
            }
        }
        return filtered.toArray(new IModelElement[filtered.size()]);
    }

    private IModelElement[] internalASTResolve(ISourceModule sourceModule, IModelAccessCache cache, int offset, int end) throws ModelException {
        ASTNode node;
        int methodEnd;
        String source;
        try {
            source = sourceModule.getSource();
            offset = PHPTextSequenceUtilities.readIdentifierStartIndex(source, offset, true);
            if (offset < 0) {
                return null;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        end = PHPTextSequenceUtilities.readIdentifierEndIndex(source, end, true);
        ModuleDeclaration parsedUnit = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        if (parsedUnit instanceof PHPModuleDeclaration) {
            PHPModuleDeclaration phpModuleDeclaration = (PHPModuleDeclaration)parsedUnit;
            List<PHPDocBlock> phpBlocks = phpModuleDeclaration.getPHPDocBlocks();
            for (PHPDocBlock phpDocBlock : phpBlocks) {
                int realStart = phpDocBlock.sourceStart();
                int realEnd = phpDocBlock.sourceEnd();
                if (realStart > offset || realEnd < end) continue;
                PHPDocTag[] tags = phpDocBlock.getTags();
                boolean isMethodOrFunction = PHPTextSequenceUtilities.getMethodEndIndex(source, end, false) != -1;
                return this.lookForMatchingElements(tags, sourceModule, parsedUnit, offset, end, isMethodOrFunction, cache);
            }
        }
        if ((methodEnd = PHPTextSequenceUtilities.getMethodEndIndex(source, end, true)) != -1) {
            end = methodEnd;
        }
        if ((node = ASTUtils.findMinimalNode(parsedUnit, offset, end)) == null) {
            return null;
        }
        IContext context = ASTUtils.findContext(sourceModule, parsedUnit, node);
        if (context == null) {
            return null;
        }
        if (context instanceof IModelCacheContext) {
            ((IModelCacheContext)context).setCache(cache);
        }
        if (node instanceof PHPCallExpression) {
            return this.processPHPCallExpression((PHPCallExpression)node, sourceModule, parsedUnit, offset, context, cache);
        }
        if (node instanceof StaticDispatch) {
            IEvaluatedType dispatcherType;
            Expression field;
            StaticDispatch dispatch = (StaticDispatch)node;
            String fieldName = null;
            if (dispatch instanceof StaticConstantAccess) {
                fieldName = ((StaticConstantAccess)dispatch).getConstant().getName();
            } else if (dispatch instanceof StaticFieldAccess && (field = ((StaticFieldAccess)dispatch).getField()) instanceof VariableReference) {
                fieldName = ((VariableReference)field).getName();
            }
            if (fieldName != null && dispatch.getDispatcher() != null && (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)dispatch.getDispatcher())) != null) {
                IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
                LinkedList<IField> fields = new LinkedList<IField>();
                if (elements != null) {
                    IType[] iTypeArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType element;
                        IType type = element = iTypeArray[n2];
                        try {
                            fields.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyField(type, cache.getSuperTypeHierarchy(type, (IProgressMonitor)new NullProgressMonitor()), fieldName, true, (IProgressMonitor)new NullProgressMonitor())));
                        }
                        catch (Exception e) {
                            PHPCorePlugin.log(e);
                        }
                        ++n2;
                    }
                }
                return fields.toArray(new IModelElement[fields.size()]);
            }
        } else if (node instanceof FieldAccess) {
            IEvaluatedType dispatcherType;
            FieldAccess fieldAccess = (FieldAccess)node;
            Expression field = fieldAccess.getField();
            String fieldName = null;
            if (field instanceof SimpleReference) {
                fieldName = ((SimpleReference)field).getName();
            }
            if (fieldName != null && fieldAccess.getDispatcher() != null && (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)fieldAccess.getDispatcher())) != null) {
                IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
                LinkedList<IField> fields = new LinkedList<IField>();
                if (elements != null) {
                    IType[] iTypeArray = elements;
                    int n = elements.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IType element = iTypeArray[n3];
                        if (element instanceof IType) {
                            IType type = element;
                            try {
                                fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, fieldName, true)));
                            }
                            catch (ModelException e) {
                                PHPCorePlugin.log(e);
                            }
                        }
                        ++n3;
                    }
                }
                return fields.toArray(new IModelElement[fields.size()]);
            }
        } else {
            IModelElement element;
            if (node instanceof NamespaceReference) {
                String name = ((NamespaceReference)node).getName();
                IType[] namespace = PHPModelUtils.getNamespaceOf(String.valueOf(name) + '\\', sourceModule, offset, cache, null);
                return namespace;
            }
            if (node instanceof TypeReference) {
                if (node instanceof FullyQualifiedReference && ((FullyQualifiedReference)node).getElementType() == 2 && (element = sourceModule.getElementAt(offset)) instanceof ImportDeclaration) {
                    String fullyQualifiedName = ((ImportDeclaration)element).getElementName();
                    String namespace = PHPModelUtils.extractNameSpaceName(fullyQualifiedName);
                    if (namespace != null && fullyQualifiedName.length() > 0 && fullyQualifiedName.charAt(0) != '\\') {
                        fullyQualifiedName = "\\" + fullyQualifiedName;
                    }
                    return PHPModelUtils.getFunctions(fullyQualifiedName, sourceModule, offset, cache, null);
                }
                TypeReference typeReference = (TypeReference)node;
                IEvaluatedType evaluatedType = PHPTypeInferenceUtils.resolveExpression(sourceModule, node);
                if (evaluatedType == null) {
                    return EMPTY;
                }
                IModelElement[] elements = new IModelElement[]{};
                String name = evaluatedType.getTypeName();
                int nodeType = 1;
                if (node instanceof FullyQualifiedReference) {
                    nodeType = ((FullyQualifiedReference)node).getElementType();
                }
                if (nodeType == 3 && evaluatedType instanceof PHPNamespaceConstantType) {
                    String constantName = ((PHPNamespaceConstantType)evaluatedType).getConstantName();
                    elements = PHPModelUtils.getFields(constantName, sourceModule, offset, cache, null);
                } else if (nodeType == 2) {
                    elements = PHPModelUtils.getFunctions(name, sourceModule, offset, cache, null);
                    if (elements.length == 0) {
                        elements = PHPModelUtils.getFunctions(typeReference.getName(), sourceModule, offset, cache, null);
                    }
                } else if (nodeType == 1) {
                    elements = PHPModelUtils.getTypes(name, sourceModule, offset, cache, null);
                    if (elements.length == 0) {
                        elements = PHPModelUtils.getTraits(name, sourceModule, offset, cache, null);
                    }
                    if (elements.length == 0) {
                        if (name.length() > 0 && name.charAt(0) == '\\') {
                            name = name.substring(1);
                        }
                        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                        elements = PHPModelAccess.getDefault().findNamespaces(null, name, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                    }
                }
                return elements;
            }
            if (node instanceof ClassInstanceCreation) {
                ClassInstanceCreation newNode = (ClassInstanceCreation)node;
                Expression className = newNode.getClassName();
                if (className instanceof SimpleReference || className instanceof FullyQualifiedReference) {
                    IEvaluatedType evaluatedType = PHPTypeInferenceUtils.resolveExpression(sourceModule, node);
                    if (evaluatedType != null) {
                        return PHPSelectionEngine.getConstructorsIfAny(PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(evaluatedType.getTypeName(), sourceModule, offset, cache, null)));
                    }
                } else if (className instanceof StaticFieldAccess) {
                    StaticFieldAccess staticFieldAccess = (StaticFieldAccess)className;
                    if (offset >= staticFieldAccess.getDispatcher().sourceStart() && offset <= staticFieldAccess.getDispatcher().sourceEnd()) {
                        className = staticFieldAccess.getDispatcher();
                        IEvaluatedType evaluatedType = PHPTypeInferenceUtils.resolveExpression(sourceModule, (ASTNode)className);
                        if (evaluatedType != null) {
                            return PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(evaluatedType.getTypeName(), sourceModule, offset, cache, null));
                        }
                    } else if (offset >= staticFieldAccess.getField().sourceStart() && offset <= staticFieldAccess.getField().sourceEnd()) {
                        IEvaluatedType dispatcherType;
                        className = staticFieldAccess.getField();
                        String fieldName = null;
                        Expression field = staticFieldAccess.getField();
                        if (field instanceof VariableReference) {
                            fieldName = ((VariableReference)field).getName();
                        }
                        if (fieldName != null && staticFieldAccess.getDispatcher() != null && (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)staticFieldAccess.getDispatcher())) != null) {
                            IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
                            LinkedList<IField> fields = new LinkedList<IField>();
                            if (elements != null) {
                                IType[] e = elements;
                                int type = elements.length;
                                int n = 0;
                                while (n < type) {
                                    IType element2 = e[n];
                                    if (element2 instanceof IType) {
                                        IType type2 = element2;
                                        try {
                                            fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type2, fieldName, true)));
                                        }
                                        catch (ModelException e2) {
                                            PHPCorePlugin.log(e2);
                                        }
                                    }
                                    ++n;
                                }
                            }
                            return fields.toArray(new IModelElement[fields.size()]);
                        }
                    }
                }
            } else if ((node instanceof TypeDeclaration || node instanceof MethodDeclaration) && ((Declaration)node).getNameStart() <= offset && ((Declaration)node).getNameEnd() >= offset) {
                element = sourceModule.getElementAt(node.sourceStart());
                if (element != null) {
                    return new IModelElement[]{element};
                }
            } else if (node instanceof SimpleReference) {
                SimpleReference reference = (SimpleReference)node;
                if ((node = ASTUtils.findMinimalNode(parsedUnit, offset, node.end() + 1)) instanceof TraitAliasStatement && (node = ASTUtils.findMinimalNode(parsedUnit, offset, node.end() + 1)) instanceof TraitUseStatement) {
                    TraitUseStatement statement = (TraitUseStatement)node;
                    LinkedList<IModelElement> methods = new LinkedList<IModelElement>();
                    for (TypeReference typeReference : statement.getTraitList()) {
                        IType[] types;
                        IType[] iTypeArray = types = PHPModelUtils.getTypes(typeReference.getName(), sourceModule, offset, cache, null, false);
                        int n = types.length;
                        int n4 = 0;
                        while (n4 < n) {
                            IModelElement[] children;
                            IType t = iTypeArray[n4];
                            IModelElement[] iModelElementArray = children = t.getChildren();
                            int n5 = children.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IModelElement modelElement = iModelElementArray[n6];
                                String name = modelElement.getElementName();
                                if (name.startsWith("$")) {
                                    name = name.substring(1);
                                }
                                if (name.equals(reference.getName())) {
                                    methods.add(modelElement);
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                    }
                    return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                }
            }
        }
        return null;
    }

    private IModelElement[] lookForMatchingElements(PHPDocTag[] tags, ISourceModule sourceModule, ModuleDeclaration parsedUnit, int offset, int end, boolean isMethodOrFunction, IModelAccessCache cache) throws ModelException {
        if (tags == null) {
            return null;
        }
        PHPDocTag[] pHPDocTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag phpDocTag = pHPDocTagArray[n2];
            if (phpDocTag.sourceStart() <= offset && phpDocTag.sourceEnd() >= end) {
                if (phpDocTag.getTagKind() == PHPDocTag.TagKind.INHERITDOC) {
                    IModelElement element;
                    Declaration declaration = ASTUtils.findDeclarationAfterPHPdoc(parsedUnit, offset);
                    if (declaration != null && (element = sourceModule.getElementAt(declaration.sourceStart())) != null) {
                        try {
                            if (element.getElementType() == 9) {
                                IType type = (IType)element.getParent();
                                return PHPModelUtils.getSuperTypeHierarchyMethod(type, null, element.getElementName(), true, null);
                            }
                            if (element.getElementType() == 8) {
                                IType type = (IType)element.getParent();
                                return PHPModelUtils.getSuperTypeHierarchyField(type, null, element.getElementName(), true, null);
                            }
                            if (element.getElementType() == 7) {
                                return PHPModelUtils.getSuperClasses((IType)element, null);
                            }
                        }
                        catch (CoreException e) {
                            Logger.logException(e);
                        }
                    }
                } else {
                    for (TypeReference typeReference : phpDocTag.getTypeReferences()) {
                        boolean isVariable;
                        String[] parts;
                        if (typeReference.sourceStart() > offset || typeReference.sourceEnd() < end) continue;
                        boolean isNamespacePart = false;
                        String name = typeReference.getName();
                        if (typeReference.sourceEnd() > end) {
                            isNamespacePart = name.charAt(end - typeReference.sourceStart()) == '\\';
                            int idx = (name = name.substring(0, end - typeReference.sourceStart())).lastIndexOf(91, offset - typeReference.sourceStart() - 1);
                            if (idx != -1) {
                                name = name.substring(idx + 1);
                            }
                        }
                        if ((parts = name.split(Pattern.quote(PAAMAYIM_NEKUDOTAIM), 3)).length > 1) {
                            if (parts.length != 2 || parts[0].length() <= 0 || parts[1].length() <= 0) continue;
                            boolean isVariable2 = parts[1].charAt(0) == '$';
                            boolean isClassOrNamespacePartSelected = offset <= typeReference.sourceStart() + parts[0].length();
                            IType[] types = this.filterNS(PHPModelUtils.getTypes(parts[0], sourceModule, offset, cache, null));
                            if (isClassOrNamespacePartSelected) {
                                return types;
                            }
                            if (isMethodOrFunction && !isVariable2) {
                                LinkedList<IMethod> methods = new LinkedList<IMethod>();
                                IType[] iTypeArray = types;
                                int n3 = types.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IType type = iTypeArray[n4];
                                    methods.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(type, parts[1], true)));
                                    ++n4;
                                }
                                return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                            }
                            LinkedList<IField> fields = new LinkedList<IField>();
                            IType[] iTypeArray = types;
                            int n5 = types.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IType type = iTypeArray[n6];
                                fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, parts[1], true)));
                                ++n6;
                            }
                            return (IModelElement[])fields.toArray(new IField[fields.size()]);
                        }
                        if (name.length() <= 0) continue;
                        boolean bl = isVariable = name.charAt(0) == '$';
                        if (isVariable) {
                            return PHPModelUtils.getFields(name, sourceModule, offset, cache, null);
                        }
                        if (isMethodOrFunction) {
                            return PHPModelUtils.getFunctions(name, sourceModule, offset, cache, null);
                        }
                        if (isNamespacePart) {
                            return PHPModelUtils.getNamespaceOf(String.valueOf(name) + '\\', sourceModule, offset, cache, null);
                        }
                        IType[] types = this.filterNS(PHPModelUtils.getTypes(name, sourceModule, offset, cache, null));
                        if (types.length == 0) {
                            return PHPModelUtils.getFields(name, sourceModule, offset, cache, null);
                        }
                        return types;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private IType[] filterNS(IType[] types) throws ModelException {
        if (types == null) {
            return EMPTY;
        }
        HashSet<IType> result = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (PHPFlags.isClass(type.getFlags()) || PHPFlags.isInterface((int)type.getFlags())) {
                result.add(type);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private IModelElement[] internalResolve(IStructuredDocument sDoc, ISourceModule sourceModule, IModelAccessCache cache, int offset, int end) throws BadLocationException, CoreException {
        block46: {
            Object fields;
            LinkedList<IMethod> methods;
            IType containerType;
            String nextWord;
            String prevWord;
            String elementName;
            int startPosition;
            TextSequence statement;
            int elementStart;
            ITextRegion tRegion;
            block47: {
                IModelElement[] generalizationTypes;
                boolean isClassDeclaration;
                int endPosition;
                block49: {
                    block48: {
                        IStructuredDocumentRegion sRegion = sDoc.getRegionAtCharacterOffset(offset);
                        if (sRegion == null) {
                            return EMPTY;
                        }
                        tRegion = sRegion.getRegionAtCharacterOffset(offset);
                        IStructuredDocumentRegion container = sRegion;
                        if (tRegion instanceof ITextRegionContainer) {
                            container = (ITextRegionContainer)tRegion;
                            tRegion = container.getRegionAtCharacterOffset(offset);
                        }
                        if (tRegion == null || tRegion.getType() != "PHP_CONTENT") break block46;
                        IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
                        tRegion = phpScriptRegion.getPHPToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                        elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                        statement = PHPTextSequenceUtilities.getStatement(elementStart + tRegion.getLength(), sRegion, true);
                        if (statement.length() == 0) {
                            return EMPTY;
                        }
                        endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statement.length());
                        startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, endPosition, true);
                        elementName = startPosition < 0 ? "" : statement.subSequence(startPosition, endPosition).toString();
                        int prevWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, startPosition);
                        int prevWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, prevWordEnd, false);
                        prevWord = prevWordStart < 0 ? "" : statement.subSequence(prevWordStart, prevWordEnd).toString();
                        ITextRegion nextRegion = tRegion;
                        while ((PHPPartitionTypes.isPHPCommentState((nextRegion = phpScriptRegion.getPHPToken(nextRegion.getEnd())).getType()) || nextRegion.getType() == "WHITESPACE") && nextRegion.getEnd() < phpScriptRegion.getLength()) {
                        }
                        nextWord = sDoc.get(container.getStartOffset() + phpScriptRegion.getStart() + nextRegion.getStart(), nextRegion.getTextLength());
                        if (elementName.isEmpty()) {
                            return EMPTY;
                        }
                        if (tRegion.getType() == "PHP_ENCAPSED_VARIABLE") {
                            elementName = "$" + elementName;
                        }
                        if ((containerType = PHPModelUtils.getCurrentType(sourceModule, offset)) == null) {
                            containerType = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                        }
                        if (!this.phpVersion.isLessThan(PHPVersion.PHP5_3) && GOTO.equalsIgnoreCase(prevWord) && elementName.charAt(0) != '$') {
                            return PHPModelUtils.getGotoLabels(elementName, sourceModule, offset, null);
                        }
                        if (FUNCTION.equalsIgnoreCase(prevWord)) {
                            if (containerType != null) {
                                return PHPModelUtils.getTypeMethod(containerType, elementName, true);
                            }
                            return PHPSelectionEngine.getFunction(sourceModule, elementName);
                        }
                        if (CLASS.equalsIgnoreCase(prevWord) || INTERFACE.equalsIgnoreCase(prevWord)) {
                            if (containerType != null) {
                                if (containerType.getElementName().equalsIgnoreCase(elementName)) {
                                    containerType = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                                }
                                if (containerType != null) {
                                    return PHPModelUtils.getTypeType(containerType, elementName, true);
                                }
                            }
                            return PHPSelectionEngine.getClass(sourceModule, elementName);
                        }
                        if (NEW.equalsIgnoreCase(prevWord)) {
                            return PHPSelectionEngine.getConstructorsIfAny(PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(elementName, sourceModule, offset, cache, null)));
                        }
                        isClassDeclaration = false;
                        if (statement.length() <= 6) break block47;
                        if (!CLASS.equals(statement.subSequence(0, 5).toString())) break block48;
                        isClassDeclaration = true;
                        if (true) break block49;
                    }
                    if (statement.length() <= 10 || !INTERFACE.equals(statement.subSequence(0, 9).toString())) break block47;
                }
                if ((generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, prevWord, elementName, offset)) != null) {
                    return generalizationTypes;
                }
                int listStartPosition = PHPTextSequenceUtilities.readIdentifierListStartIndex(statement, endPosition);
                int preListWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, listStartPosition);
                int preListWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, preListWordEnd, false);
                String preListWord = preListWordStart < 0 ? "" : statement.subSequence(preListWordStart, preListWordEnd).toString();
                generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, preListWord, elementName, offset);
                if (generalizationTypes != null) {
                    return generalizationTypes;
                }
            }
            String trigger = null;
            if (startPosition > 2) {
                trigger = statement.subSequence(startPosition - 2, startPosition).toString();
            }
            int firstWordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(statement, 0);
            String firstWord = statement.subSequence(0, firstWordEnd).toString();
            if (elementName.charAt(0) == '$' && !PAAMAYIM_NEKUDOTAIM.equals(trigger)) {
                if (PHPPartitionTypes.isPHPQuotesState(tRegion.getType())) {
                    try {
                        char charBefore = sDoc.get(elementStart - 2, 1).charAt(0);
                        if (charBefore == '\\') {
                            return EMPTY;
                        }
                    }
                    catch (BadLocationException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                if (containerType != null) {
                    if (VAR.equalsIgnoreCase(firstWord) || PRIVATE.equalsIgnoreCase(firstWord) || STATIC.equalsIgnoreCase(firstWord) || PUBLIC.equalsIgnoreCase(firstWord) || PROTECTED.equalsIgnoreCase(firstWord)) {
                        return PHPModelUtils.getTypeField(containerType, elementName, true);
                    }
                    if (THIS.equalsIgnoreCase(elementName)) {
                        return new IModelElement[]{containerType};
                    }
                }
                return PHPSelectionEngine.getGlobalOrMethodFields(sourceModule, offset, elementName);
            }
            if (containerType != null && CONST.equalsIgnoreCase(prevWord)) {
                return PHPModelUtils.getTypeField(containerType, elementName, true);
            }
            if (PAAMAYIM_NEKUDOTAIM.equals(nextWord)) {
                return PHPModelUtils.getTypes(elementName, sourceModule, offset, cache, null);
            }
            if ("\\".equals(nextWord)) {
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                return PHPModelAccess.getDefault().findNamespaces(null, elementName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            }
            Object[] types = CodeAssistUtils.getTypesFor(sourceModule, statement, startPosition, offset);
            if (OPEN_BRACE.equals(nextWord) || PHPPartitionTypes.isPHPDocState(tRegion.getType())) {
                if (ArrayUtils.isNotEmpty((Object[])types)) {
                    methods = new LinkedList<IMethod>();
                    Object[] objectArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object t = objectArray[n2];
                        methods.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyMethod((IType)t, cache.getSuperTypeHierarchy((IType)t, null), elementName, true, null)));
                        ++n2;
                    }
                    return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                }
                return PHPModelUtils.getFunctions(elementName, sourceModule, offset, cache, null);
            }
            if ((INSTEADOF.equals(nextWord) || AS.equals(nextWord)) && !PAAMAYIM_NEKUDOTAIM.equals(trigger) && !OBJECT_OPERATOR.equals(trigger) && ArrayUtils.isNotEmpty((Object[])types)) {
                methods = new LinkedList();
                Object[] objectArray = types;
                int n = types.length;
                int n3 = 0;
                while (n3 < n) {
                    Object t = objectArray[n3];
                    methods.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyMethod((IType)t, cache.getSuperTypeHierarchy((IType)t, null), elementName, true, null)));
                    ++n3;
                }
                return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
            }
            if (ArrayUtils.isNotEmpty((Object[])types)) {
                if (startPosition > 0 && PAAMAYIM_NEKUDOTAIM.equals(trigger) && elementName.charAt(0) != '$') {
                    fields = new LinkedList();
                    Object[] objectArray = types;
                    int n = types.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IField[] typeFields;
                        Object t = objectArray[n4];
                        IField[] iFieldArray = typeFields = PHPModelUtils.getTypeField((IType)t, elementName, true);
                        int n5 = typeFields.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IField currentField = iFieldArray[n6];
                            fields.add(currentField);
                            ++n6;
                        }
                        ++n4;
                    }
                    return fields.toArray(new IModelElement[fields.size()]);
                }
                fields = new ArrayList();
                Object[] objectArray = types;
                int n = types.length;
                int n7 = 0;
                while (n7 < n) {
                    Object t = objectArray[n7];
                    fields.addAll(Arrays.asList(PHPSelectionEngine.getTypeHierarchyField((IType)t, cache.getSuperTypeHierarchy((IType)t, null), elementName, true, null)));
                    ++n7;
                }
                return fields.toArray(new IModelElement[fields.size()]);
            }
            fields = PHPModelUtils.getFields(elementName, sourceModule, offset, cache, null);
            if (ArrayUtils.isNotEmpty((Object[])fields)) {
                return fields;
            }
            ModuleDeclaration parsedUnit = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
            fields = this.findFieldAliases(elementName, sourceModule, parsedUnit, containerType, offset);
            if (ArrayUtils.isNotEmpty((Object[])fields)) {
                return fields;
            }
            return PHPModelUtils.getTypes(elementName, sourceModule, offset, cache, null);
        }
        return EMPTY;
    }

    private IModelElement[] processPHPCallExpression(PHPCallExpression callExpression, ISourceModule sourceModule, ModuleDeclaration parsedUnit, int offset, IContext context, IModelAccessCache cache) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        if (callExpression.getReceiver() != null) {
            IEvaluatedType receiverType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, callExpression.getReceiver());
            if (receiverType != null) {
                IType element;
                int n;
                int n2;
                IType[] iTypeArray;
                IType[] elements = null;
                if (receiverType instanceof PHPClassType && ((PHPClassType)receiverType).isGlobal()) {
                    elements = PHPModelAccess.getDefault().findTypes(receiverType.getTypeName(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                    LinkedList<IType> result = new LinkedList<IType>();
                    iTypeArray = elements;
                    n2 = elements.length;
                    n = 0;
                    while (n < n2) {
                        element = iTypeArray[n];
                        IModelElement parent = element.getParent();
                        while (parent.getParent() instanceof IType) {
                            parent = parent.getParent();
                        }
                        if (!(parent instanceof IType) || !PHPFlags.isNamespace(((IType)parent).getFlags())) {
                            result.add(element);
                        }
                        ++n;
                    }
                    elements = (IModelElement[])result.toArray(new IType[result.size()]);
                } else {
                    elements = PHPTypeInferenceUtils.getModelElements(receiverType, (ISourceModuleContext)context, offset);
                }
                if (elements == null) {
                    return EMPTY;
                }
                LinkedList<IMethod> methods = new LinkedList<IMethod>();
                iTypeArray = elements;
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iTypeArray[n];
                    if (element instanceof IType) {
                        IType type = element;
                        try {
                            ITypeHierarchy hierarchy = cache.getSuperTypeHierarchy(type, null);
                            IMethod[] method = PHPModelUtils.getFirstTypeHierarchyMethod(type, hierarchy, callExpression.getName(), true, null);
                            methods.addAll(Arrays.asList(method));
                        }
                        catch (CoreException e) {
                            PHPCorePlugin.log(e);
                        }
                    }
                    ++n;
                }
                return methods.toArray(new IModelElement[methods.size()]);
            }
        } else {
            IType currentNamespace;
            Map<String, UsePart> useParts;
            SimpleReference callName = callExpression.getCallName();
            String methodName = callName instanceof FullyQualifiedReference ? ((FullyQualifiedReference)callName).getFullyQualifiedName() : callName.getName();
            IMethod[] members = PHPModelUtils.getFunctions(methodName, sourceModule, offset, cache, null);
            if (members.length == 0 && (useParts = PHPModelUtils.getAliasToNSMap(methodName, parsedUnit, offset, currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, callExpression.sourceStart()), true)).containsKey(methodName)) {
                String fullName = useParts.get(methodName).getNamespace().getFullyQualifiedName();
                if (fullName.length() > 0 && fullName.charAt(0) != '\\') {
                    fullName = String.valueOf('\\') + fullName;
                }
                members = PHPModelUtils.getFunctions(fullName, sourceModule, offset, null, null);
            }
            return members;
        }
        return EMPTY;
    }

    private IField[] findFieldAliases(String fieldName, ISourceModule sourceModule, ModuleDeclaration parsedUnit, IType currentNamespace, int offset) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        Map<String, UsePart> useParts = PHPModelUtils.getAliasToNSMap(fieldName, parsedUnit, offset, currentNamespace, true);
        if (useParts.containsKey(fieldName)) {
            String fullName = useParts.get(fieldName).getNamespace().getFullyQualifiedName();
            IField[] elements = PHPModelAccess.getDefault().findFields(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            if (elements != null) {
                ArrayList<AliasField> result = new ArrayList<AliasField>();
                IField[] iFieldArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    result.add(new AliasField((ModelElement)field, field.getFullyQualifiedName(), fieldName));
                    ++n2;
                }
                return result.toArray(new IField[0]);
            }
        }
        return null;
    }

    public static IField[] getTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        ArrayList<IField> fields = new ArrayList<IField>();
        fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, prefix, exactName)));
        if (ArrayUtils.isNotEmpty((Object[])type.getSuperClasses())) {
            IField[] temp;
            TreeSet<IModelElement> fieldSet = new TreeSet<IModelElement>(new SourceFieldComparator());
            fieldSet.addAll(Arrays.asList(PHPModelUtils.getSuperTypeHierarchyField(type, hierarchy, prefix, exactName, monitor)));
            IField[] iFieldArray = temp = fieldSet.toArray(new IField[fieldSet.size()]);
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                fields.add(field);
                ++n2;
            }
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IModelElement[] getGeneralizationTypes(ISourceModule sourceModule, boolean isClassDeclaration, String generalization, String elementName, int offset) throws ModelException {
        if (EXTENDS.equalsIgnoreCase(generalization)) {
            if (isClassDeclaration) {
                return PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(elementName, sourceModule, offset, null, null));
            }
            return PHPSelectionEngine.extractInterfaces(PHPModelUtils.getTypes(elementName, sourceModule, offset, null, null));
        }
        if (IMPLEMENTS.equalsIgnoreCase(generalization)) {
            return PHPSelectionEngine.extractInterfaces(PHPModelUtils.getTypes(elementName, sourceModule, offset, null, null));
        }
        return null;
    }

    private static IModelElement[] getFunction(ISourceModule sourceModule, String elementName) throws ModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = ((AbstractSourceModule)sourceModule).getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{method};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IModelElement[] getClass(ISourceModule sourceModule, String elementName) throws ModelException {
        IType[] types;
        IType[] iTypeArray = types = sourceModule.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{type};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IType[] extractInterfaces(IType[] types) {
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                if (PHPFlags.isInterface((int)type.getFlags())) {
                    result.add(type);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IType[] extractClasses(IType[] types) {
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                if (PHPFlags.isClass(type.getFlags())) {
                    result.add(type);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IModelElement[] getConstructorsIfAny(IType[] types) throws ModelException {
        LinkedList<Object> result = new LinkedList<Object>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            boolean hasConstructor = false;
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                if (method.isConstructor()) {
                    result.add(method);
                    hasConstructor = true;
                    break;
                }
                ++n4;
            }
            if (!hasConstructor) {
                result.add(type);
            }
            ++n2;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    private static IModelElement[] getGlobalOrMethodFields(ISourceModule sourceModule, int offset, String prefix) throws ModelException {
        try {
            IModelElement enclosingElement = sourceModule.getElementAt(offset);
            if (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (enclosingElement instanceof IMethod) {
                IMethod method = (IMethod)enclosingElement;
                return PHPModelUtils.getMethodFields(method, prefix, true, null);
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return PHPModelUtils.getFields(prefix, sourceModule, offset, null, null);
    }

    private static class SourceFieldComparator
    implements Comparator<IModelElement> {
        private SourceFieldComparator() {
        }

        @Override
        public int compare(IModelElement o1, IModelElement o2) {
            SourceRefElement e2;
            SourceRefElement e1;
            block4: {
                try {
                    e1 = (SourceRefElement)o1;
                    e2 = (SourceRefElement)o2;
                    IType type1 = (IType)e1.getAncestor(7);
                    IType type2 = (IType)e2.getAncestor(7);
                    if (type1 == null || type2 == null || type1 == type2) break block4;
                    return -1;
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                    return 0;
                }
            }
            if (e1.getSourceModule() == e2.getSourceModule()) {
                ISourceRange r1 = e1.getSourceRange();
                ISourceRange r2 = e2.getSourceRange();
                return (int)Math.signum(r1.getOffset() - r2.getOffset());
            }
            return -1;
        }
    }
}

