/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.commands.CreationCommandRegistry;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindLabelProvider;
import org.eclipse.papyrus.uml.diagram.wizards.kind.RepresentationKindComposite;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelWizardData;
import org.eclipse.papyrus.uml.diagram.wizards.profile.ProfileChooserComposite;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;
import org.eclipse.papyrus.uml.diagram.wizards.template.SelectModelTemplateComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.NamedElement;

public class SelectRepresentationKindPage
extends WizardPage {
    public static final String PAGE_ID = "SelectDiagramKind";
    private Text nameText;
    private boolean nameTextModified;
    private SelectModelTemplateComposite selectTemplateComposite;
    private RepresentationKindComposite representationKindComposite;
    private ProfileChooserComposite profileChooserComposite;
    private final ContextProvider myContextProvider;
    private final boolean allowTemplates;
    private final ICreationCommandRegistry myCreationCommandRegistry;
    private NewModelWizardData wizardData;
    private IValueChangeListener<String> defaultModelNameListener;
    private static EObject modelRoot;
    public static final ICreationCommandRegistry DEFAULT_CREATION_COMMAND_REGISTRY;

    static {
        DEFAULT_CREATION_COMMAND_REGISTRY = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.ui");
    }

    public SelectRepresentationKindPage(ContextProvider contextProvider) {
        this(true, contextProvider, DEFAULT_CREATION_COMMAND_REGISTRY);
    }

    public SelectRepresentationKindPage(boolean allowTemplates, ContextProvider contextProvider, ICreationCommandRegistry creationCommandRegistry) {
        super(PAGE_ID);
        this.setTitle(Messages.SelectRepresentationKindPage_page_title);
        this.setDescription(Messages.SelectRepresentationKindPage_page_desc);
        this.allowTemplates = allowTemplates;
        this.myContextProvider = contextProvider;
        this.myCreationCommandRegistry = creationCommandRegistry;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new GridLayout());
        pageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite nameFormComposite = new Composite(pageComposite, 0);
        nameFormComposite.setLayout((Layout)new GridLayout());
        nameFormComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createNameForm(nameFormComposite);
        Composite representationKindComposite = new Composite(pageComposite, 0);
        representationKindComposite.setLayout((Layout)new GridLayout());
        representationKindComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPresentationKindForm(representationKindComposite);
        Composite modelTemplateComposite = new Composite(pageComposite, 0);
        modelTemplateComposite.setLayout((Layout)new GridLayout());
        modelTemplateComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createModelTemplateComposite(modelTemplateComposite);
        this.fillInTables(this.getContexts(), this.getViewpoints());
        Composite profileChooserComposite = new Composite(pageComposite, 0);
        profileChooserComposite.setLayout((Layout)new GridLayout());
        profileChooserComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createProfileFileChooser(profileChooserComposite);
        this.setControl((Control)pageComposite);
    }

    private void createProfileFileChooser(Composite parent) {
        Group group = SelectRepresentationKindPage.createGroup(parent, Messages.SelectRepresentationKindPage_0);
        this.profileChooserComposite = new ProfileChooserComposite((Composite)group);
        this.profileChooserComposite.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                SelectRepresentationKindPage.this.validatePage();
            }
        });
    }

    public String getProfileURI() {
        return this.profileChooserComposite.getProfileURI();
    }

    public IStatus getProfileDefinitionStatus() {
        return this.profileChooserComposite.getProfileDefinitionStatus();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillInTables(this.getContexts(), this.getViewpoints());
            this.validatePage();
            Combo templateCombo = this.selectTemplateComposite.getTemplateCombo();
            if (templateCombo.getItemCount() == 0) {
                templateCombo.setEnabled(false);
            } else {
                templateCombo.setEnabled(true);
            }
            if (!this.allowTemplates) {
                this.selectTemplateComposite.disable();
            }
        }
    }

    private void fillInTables(String[] contexts, String[] viewpoints) {
        if (viewpoints == null || contexts == null) {
            return;
        }
        this.representationKindComposite.setInput(viewpoints);
        this.selectTemplateComposite.setInput(contexts);
    }

    public String getTemplatePath() {
        return this.selectTemplateComposite.getTemplatePath();
    }

    public String getNotationTemplatePath() {
        return this.selectTemplateComposite.getNotationTemplatePath();
    }

    public String getDiTemplatePath() {
        return this.selectTemplateComposite.getDiTemplatePath();
    }

    public String getTemplatePluginId() {
        return this.selectTemplateComposite.getTemplatePluginId();
    }

    private String[] getContexts() {
        return this.myContextProvider.getCurrentContexts();
    }

    private String[] getViewpoints() {
        return this.myContextProvider.getCurrentViewpoints();
    }

    public List<String> getDiagramName() {
        return this.representationKindComposite.getDiagramName();
    }

    public String getRootElementName() {
        return this.nameText.getText();
    }

    public boolean templatesEnabled() {
        return this.allowTemplates;
    }

    public List<RepresentationKind> getSelectedRepresentationKinds(String contextId) {
        MergedArchitectureContext context = ArchitectureDomainManager.getInstance().getArchitectureContextById(contextId);
        HashSet allowedKinds = new HashSet();
        for (MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
            allowedKinds.addAll(viewpoint.getRepresentationKinds());
        }
        ArrayList<RepresentationKind> selectedKinds = new ArrayList<RepresentationKind>();
        RepresentationKind[] representationKindArray = this.getSelectedRepresentationKinds();
        int n = representationKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            RepresentationKind kind = representationKindArray[n2];
            if (allowedKinds.contains(kind)) {
                selectedKinds.add(kind);
            }
            ++n2;
        }
        return selectedKinds;
    }

    private void createModelTemplateComposite(Composite composite) {
        Group group = SelectRepresentationKindPage.createGroup(composite, Messages.SelectRepresentationKindPage_load_template_group);
        this.selectTemplateComposite = new SelectModelTemplateComposite((Composite)group);
    }

    private void createPresentationKindForm(Composite composite) {
        Group group = SelectRepresentationKindPage.createGroup(composite, Messages.SelectRepresentationKindPage_select_kind_group);
        this.representationKindComposite = new RepresentationKindComposite((Composite)group);
    }

    protected IBaseLabelProvider createDiagramKindLabelProvider() {
        return new DiagramKindLabelProvider();
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, true);
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        return group;
    }

    private void createNameForm(Composite composite) {
        IFile selectedIFile;
        IStructuredSelection sSelection;
        Object selectedObject;
        Group group = SelectRepresentationKindPage.createGroup(composite, Messages.SelectRepresentationKindPage_diagram_name_group);
        this.nameText = new Text((Composite)group, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText.setText((String)this.getDefaultModelName().getValue());
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0 && (selectedObject = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (selectedIFile = (IFile)((IAdaptable)selectedObject).getAdapter(IFile.class)) != null) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createURI((String)selectedIFile.getLocationURI().toString()), true);
                if (resource.getContents().size() > 0) {
                    modelRoot = (EObject)resource.getContents().get(0);
                    if (modelRoot instanceof NamedElement) {
                        NamedElement element = (NamedElement)modelRoot;
                        this.nameText.setText(element.getName());
                    } else {
                        modelRoot = null;
                    }
                }
            }
            catch (Exception e) {
                this.setErrorMessage(Messages.SelectRepresentationKindPage_Set_Root_Name_Error);
                Activator.log.error((Throwable)e);
            }
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectRepresentationKindPage.this.validatePage();
            }
        });
    }

    public static EObject getModelRoot() {
        return modelRoot;
    }

    private boolean validatePage() {
        IStatus profileStatus;
        if (!Objects.equals(this.nameText.getText(), this.getDefaultModelName().getValue())) {
            this.nameTextModified = true;
        }
        if (!(profileStatus = this.profileChooserComposite.getProfileDefinitionStatus()).isOK()) {
            this.setErrorMessage(profileStatus.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.SelectRepresentationKindPage_page_desc);
        return true;
    }

    public String[] getSelectedDiagramKinds(String categoryId) {
        return new String[0];
    }

    protected RepresentationKind[] getSelectedRepresentationKinds() {
        ArrayList<RepresentationKind> checked = this.representationKindComposite.getCheckElement();
        RepresentationKind[] result = checked.toArray(new RepresentationKind[checked.size()]);
        return result;
    }

    protected final ICreationCommandRegistry getCreationCommandRegistry() {
        return this.myCreationCommandRegistry;
    }

    public List<ModelTemplateDescription> getTemplateTransfo() {
        return this.selectTemplateComposite.getTemplateTransfoPath();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.Kind");
    }

    public void setNewModelWizardData(NewModelWizardData wizardData) {
        if (this.wizardData == wizardData) {
            return;
        }
        if (this.getDefaultModelName() != null && this.defaultModelNameListener != null) {
            this.getDefaultModelName().removeValueChangeListener(this.defaultModelNameListener);
        }
        this.wizardData = wizardData;
        if (this.getDefaultModelName() != null) {
            this.getDefaultModelName().addValueChangeListener(this.getDefaultModelNameListener());
            this.updateDefaultModelName();
        }
    }

    protected IObservableValue<String> getDefaultModelName() {
        return this.wizardData == null ? null : this.wizardData.getDefaultModelName();
    }

    private IValueChangeListener<String> getDefaultModelNameListener() {
        if (this.defaultModelNameListener == null) {
            this.defaultModelNameListener = event -> this.updateDefaultModelName((String)event.diff.getNewValue());
        }
        return this.defaultModelNameListener;
    }

    protected void updateDefaultModelName(String newName) {
        if (this.nameText != null && !this.nameTextModified) {
            this.nameText.setText(newName);
            this.nameText.selectAll();
        }
    }

    private void updateDefaultModelName() {
        if (this.getDefaultModelName() != null) {
            this.updateDefaultModelName((String)this.getDefaultModelName().getValue());
        }
    }

    public static interface ContextProvider {
        public String[] getCurrentContexts();

        public String[] getCurrentViewpoints();
    }
}

