/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringWithClearEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractFilteredContentProvider
implements IGraphicalContentProvider {
    protected StructuredViewer viewer;
    public static final String BASE_PATTERN = "*";
    protected boolean showIfHasVisibleParent = false;
    private PatternViewerFilter patternFilter;
    private String currentFilterPattern;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
        }
    }

    @Override
    public void createBefore(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.createPatternFilter(composite);
        this.createCaseSensitiveButton(composite);
    }

    protected void createCaseSensitiveButton(Composite parent) {
        final Button checkBoxCaseSensitive = new Button(parent, 32);
        checkBoxCaseSensitive.setText(Messages.AbstractFilteredContentProvider_CaseSensitiveLabel);
        checkBoxCaseSensitive.setToolTipText(Messages.AbstractFilteredContentProvider_CaseSensitiveTooltip);
        checkBoxCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AbstractFilteredContentProvider.this.patternFilter instanceof PatternViewerFilter) {
                    AbstractFilteredContentProvider.this.patternFilter.setIgnoreCase(!checkBoxCaseSensitive.getSelection());
                }
                AbstractFilteredContentProvider.this.viewer.refresh();
            }
        });
    }

    protected void createPatternFilter(Composite parent) {
        StringWithClearEditor filterField = new StringWithClearEditor(parent, 2048);
        filterField.setToolTipText(Messages.AbstractFilteredContentProvider_FilterFieldTooltip);
        filterField.setValidateOnDelay(Activator.getValidationDelay());
        filterField.setValidateOnDelay(Activator.isFilterValidateOnDelay());
        if (Activator.isStereotypeDelimitersReplaced()) {
            filterField.addStringToReplace("<<", "\u00ab");
            filterField.addStringToReplace(">>", "\u00bb");
        } else {
            filterField.clearStringToReplace();
        }
        GridLayoutFactory.fillDefaults().applyTo((Composite)filterField);
        filterField.setLayoutData(new GridData(4, 4, true, false));
        this.patternFilter = this.getViewerFilter();
        this.currentFilterPattern = BASE_PATTERN;
        this.patternFilter.setPattern(BASE_PATTERN);
        filterField.addCommitListener(editor -> {
            String filterPattern = ((StringWithClearEditor)editor).getValue();
            this.patternFilter.setPattern(filterPattern);
            List<ViewerFilter> filtersAsList = Arrays.asList(this.viewer.getFilters());
            if (!filtersAsList.contains((Object)this.patternFilter)) {
                this.viewer.addFilter((ViewerFilter)this.patternFilter);
            }
            this.viewer.refresh();
            if (!"".equals(filterPattern) && !this.currentFilterPattern.equals(filterPattern)) {
                this.currentFilterPattern = filterPattern;
            }
        });
        filterField.getText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AbstractFilteredContentProvider.this.viewer.getControl().setFocus();
                }
            }
        });
    }

    @Override
    public void createAfter(Composite parent) {
    }

    protected PatternViewerFilter getViewerFilter() {
        PatternViewerFilter filter = new PatternViewerFilter();
        filter.setStrict(false);
        this.currentFilterPattern = BASE_PATTERN;
        filter.setPattern(this.currentFilterPattern);
        filter.setShowIfHasVisibleParent(this.showIfHasVisibleParent);
        return filter;
    }
}

