/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.iteration;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaConstants;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.iteration.AbstractIteration2Java;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public abstract class AbstractAccumulation2Java
extends AbstractIteration2Java {
    @Override
    public void appendAccumulatorInit(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGTypeId cgAccumulatorId = cgIterationCallExp.getTypeId();
        CollectionTypeId elementId = (CollectionTypeId)cgAccumulatorId.getElementId();
        String name = elementId.getGeneralizedId().getName();
        js.appendClassReference(ValueUtil.class);
        js.append(".create" + name + "AccumulatorValue(");
        js.appendIdReference((ElementId)elementId);
        js.append(")");
    }

    @Override
    public boolean appendFinalValue(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGIterator cgAccumulator = this.getAccumulator(cgIterationCallExp);
        return js.appendAssignment(cgIterationCallExp, cgAccumulator);
    }

    protected @NonNull CGIterator getAccumulator(@NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        return cgIterationCallExp.getAccumulator();
    }

    protected @NonNull Class<?> getAccumulatorClass(@NonNull CodeGenAnalyzer analyzer, @NonNull CollectionTypeId typeId) {
        JavaCodeGenerator codeGenerator = (JavaCodeGenerator)analyzer.getCodeGenerator();
        BoxedDescriptor boxedTypeDescriptor = codeGenerator.getBoxedDescriptor((ElementId)typeId);
        Class<?> boxedClass = boxedTypeDescriptor.getJavaClass();
        Class<?>[] classArray = boxedClass.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> nestedClass = classArray[n2];
            if ("Accumulator".equals(nestedClass.getSimpleName())) {
                return nestedClass;
            }
            ++n2;
        }
        return Object.class;
    }

    @Override
    public @Nullable CGTypeId getAccumulatorTypeId(@NonNull CodeGenAnalyzer analyzer, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGTypeId cgAccumulatorId = cgIterationCallExp.getTypeId();
        ElementId elementId = cgAccumulatorId.getElementId();
        Class<Object> accumulatorClass = elementId instanceof CollectionTypeId ? this.getAccumulatorClass(analyzer, (CollectionTypeId)elementId) : Object.class;
        return analyzer.getTypeId(JavaConstants.getJavaTypeId(accumulatorClass));
    }
}

