/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.BaseCallRedirection;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.OTConstants;
import org.eclipse.objectteams.otre.RepositoryAccess;
import org.eclipse.objectteams.otre.jplis.JPLISEnhancer;
import org.eclipse.objectteams.otre.util.AnnotationHelper;
import org.eclipse.objectteams.otre.util.AttributeReadingGuard;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.RoleBaseBinding;
import org.objectteams.OTREInternalError;

public abstract class ObjectTeamsTransformation
implements OTConstants {
    InstructionFactory factory;
    protected Object loader;
    static boolean logging = false;
    static String TEAM_CONFIG_FILE;
    protected static boolean IS_COMPILER_GREATER_123;
    protected static boolean IS_COMPILER_13X_PLUS;
    protected static boolean IS_COMPILER_14X_PLUS;
    protected static boolean COMPILER_VERSION_READ;
    public static boolean WORKAROUND_REPOSITORY;
    public static boolean debugging;
    static ImplicitActivationMode implicitActivationMode;
    public HashSet<String> adaptedBases = new HashSet();

    static {
        if (System.getProperty("ot.log") != null) {
            logging = true;
        }
        TEAM_CONFIG_FILE = null;
        TEAM_CONFIG_FILE = System.getProperty("ot.teamconfig");
        IS_COMPILER_GREATER_123 = false;
        IS_COMPILER_13X_PLUS = false;
        IS_COMPILER_14X_PLUS = false;
        COMPILER_VERSION_READ = false;
        WORKAROUND_REPOSITORY = false;
        if (System.getProperty("ot.equinox") != null) {
            WORKAROUND_REPOSITORY = true;
        }
        debugging = false;
        if (System.getProperty("ot.debug") != null) {
            debugging = true;
        }
        implicitActivationMode = ImplicitActivationMode.ANNOTATED;
        String prop = System.getProperty("ot.implicit.team.activation");
        ImplicitActivationMode[] implicitActivationModeArray = ImplicitActivationMode.values();
        int n = implicitActivationModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImplicitActivationMode mode = implicitActivationModeArray[n2];
            if (mode.name().equals(prop)) {
                implicitActivationMode = mode;
                break;
            }
            ++n2;
        }
    }

    static boolean isCallinWrapper(Method m, ClassGen cg) {
        return ObjectTeamsTransformation.methodHasCallinFlags(m, cg, 2);
    }

    static boolean isCallin(Method m, ClassGen cg) {
        return ObjectTeamsTransformation.methodHasCallinFlags(m, cg, 0) && !ObjectTeamsTransformation.isCallinWrapper(m, cg);
    }

    static String genOrigMethName(String methName) {
        return "_OT$" + methName + "$orig";
    }

    static String genChainMethName(String methName) {
        return "_OT$" + methName + "$chain";
    }

    public ObjectTeamsTransformation(Object loader) {
        this.loader = loader;
    }

    public static void printLogMessage(String message) {
        System.out.println(message);
    }

    static String[] enhanceArgumentNames(String[] argumentNames) {
        return ObjectTeamsTransformation.enhanceArgumentNames(argumentNames, 0);
    }

    static String[] enhanceArgumentNames(String[] argumentNames, int idx) {
        String[] enhancedArgumentNames = new String[argumentNames.length + 6];
        int j = 0;
        while (j < idx) {
            enhancedArgumentNames[j] = argumentNames[j];
            ++j;
        }
        enhancedArgumentNames[idx + 1 - 1] = "_OT$teams";
        enhancedArgumentNames[idx + 2 - 1] = "_OT$teamIDs";
        enhancedArgumentNames[idx + 3 - 1] = "_OT$idx";
        enhancedArgumentNames[idx + 4 - 1] = "_OT$bindIdx";
        enhancedArgumentNames[idx + 5 - 1] = "_OT$baseMethTag";
        enhancedArgumentNames[idx + 6 - 1] = "_OT$unusedArgs";
        j = idx;
        while (j < argumentNames.length) {
            enhancedArgumentNames[j + 6] = argumentNames[j];
            ++j;
        }
        return enhancedArgumentNames;
    }

    static Type[] enhanceArgumentTypes(String signature) {
        Type[] types = Type.getArgumentTypes((String)signature);
        return ObjectTeamsTransformation.enhanceArgumentTypes(types);
    }

    static Type[] enhanceArgumentTypes(Type[] originalArgumentTypes) {
        return ObjectTeamsTransformation.enhanceArgumentTypes(originalArgumentTypes, 0, true);
    }

    static Type[] enhanceArgumentTypes(Type[] originalArgumentTypes, int idx, boolean createUnused) {
        int offset = createUnused ? 6 : 5;
        Type[] enhancedArgumentTypes = new Type[originalArgumentTypes.length + offset];
        int j = 0;
        while (j < idx) {
            enhancedArgumentTypes[j] = originalArgumentTypes[j];
            ++j;
        }
        enhancedArgumentTypes[idx + 1 - 1] = teamArray;
        enhancedArgumentTypes[idx + 2 - 1] = intArray;
        enhancedArgumentTypes[idx + 3 - 1] = Type.INT;
        enhancedArgumentTypes[idx + 4 - 1] = Type.INT;
        enhancedArgumentTypes[idx + 5 - 1] = Type.INT;
        if (createUnused) {
            enhancedArgumentTypes[idx + 6 - 1] = objectArray;
        }
        j = idx;
        while (j < originalArgumentTypes.length) {
            enhancedArgumentTypes[j + 6] = originalArgumentTypes[j];
            ++j;
        }
        return enhancedArgumentTypes;
    }

    public static Type[] _retrenchArgumentTypes(Type[] enhancedArgumentTypes, boolean staticFlag) {
        int offset = staticFlag ? -1 : 0;
        Type[] retrenchedArgumentTypes = new Type[enhancedArgumentTypes.length - 6 + offset];
        int j = 6;
        while (j < enhancedArgumentTypes.length + offset) {
            retrenchedArgumentTypes[j - 6] = enhancedArgumentTypes[j];
            ++j;
        }
        return retrenchedArgumentTypes;
    }

    static Type generalizeReturnType(String signature) {
        Type type = Type.getReturnType((String)signature);
        return ObjectTeamsTransformation.generalizeReturnType(type);
    }

    static Type generalizeReturnType(Type type) {
        if (type instanceof ReferenceType) {
            return type;
        }
        return object;
    }

    static Type generalizeReturnType(String sign1, String sign2) {
        Type type = Type.getReturnType((String)sign2);
        if (type == Type.VOID) {
            return object;
        }
        return ObjectTeamsTransformation.generalizeReturnType(sign1);
    }

    InstructionHandle adjustValue(InstructionList il, InstructionHandle ih, Type oldType, Type newType) {
        if (ih == null) {
            ih = il.getEnd();
        }
        if (oldType.equals((Object)newType)) {
            return null;
        }
        if (newType == Type.VOID) {
            return il.append(ih, (Instruction)new POP());
        }
        if (oldType == Type.VOID) {
            return il.append(ih, InstructionFactory.ACONST_NULL);
        }
        if (oldType instanceof BasicType) {
            return il.append(ih, this.createBoxing((BasicType)oldType));
        }
        if (newType instanceof BasicType) {
            return il.append(ih, this.createUnboxing((BasicType)newType));
        }
        return il.append(ih, this.factory.createCast(oldType, newType));
    }

    static String toObjectTypeName(BasicType basicType) {
        String result = "";
        switch (basicType.getType()) {
            case 4: {
                result = "java.lang.Boolean";
                break;
            }
            case 10: {
                result = "java.lang.Integer";
                break;
            }
            case 6: {
                result = "java.lang.Float";
                break;
            }
            case 7: {
                result = "java.lang.Double";
                break;
            }
            case 9: {
                result = "java.lang.Short";
                break;
            }
            case 8: {
                result = "java.lang.Byte";
                break;
            }
            case 5: {
                result = "java.lang.Character";
                break;
            }
            case 11: {
                result = "java.lang.Long";
                break;
            }
            default: {
                throw new Error("OTRE failure: Basic Type not supported!!" + basicType);
            }
        }
        return result;
    }

    InstructionList createBoxing(BasicType basicType) {
        InstructionList il = new InstructionList();
        String boxedTypeName = ObjectTeamsTransformation.toObjectTypeName(basicType);
        il.append((Instruction)this.factory.createNew(boxedTypeName));
        if (basicType.equals((Object)Type.DOUBLE) || basicType.equals((Object)Type.LONG)) {
            il.append((Instruction)new DUP_X2());
            il.append((Instruction)new DUP_X2());
        } else {
            il.append((Instruction)new DUP_X1());
            il.append((Instruction)new DUP_X1());
        }
        il.append((Instruction)new POP());
        il.append((Instruction)this.factory.createInvoke(boxedTypeName, "<init>", (Type)Type.VOID, new Type[]{basicType}, (short)183));
        return il;
    }

    InstructionList createUnboxing(BasicType basicType) {
        InstructionList il = new InstructionList();
        String boxedTypeName = ObjectTeamsTransformation.toObjectTypeName(basicType);
        il.append(this.factory.createCast((Type)object, (Type)new ObjectType(boxedTypeName)));
        il.append((Instruction)this.factory.createInvoke(boxedTypeName, String.valueOf(basicType.toString()) + "Value", (Type)basicType, Type.NO_ARGS, (short)182));
        return il;
    }

    Instruction createIntegerPush(ConstantPoolGen cpg, int val) {
        if (val <= 5) {
            return new ICONST(val);
        }
        if (val <= 127) {
            return new BIPUSH((byte)val);
        }
        if (val <= Short.MAX_VALUE) {
            return new SIPUSH((short)val);
        }
        return new LDC(cpg.addInteger(val));
    }

    InstructionHandle createThrowInternalError(ConstantPoolGen cpg, InstructionList il, InstructionList messagePush) {
        InstructionHandle start = il.append((Instruction)this.factory.createNew(OTConstants.internalError));
        il.append((Instruction)new DUP());
        il.append(messagePush);
        il.append((Instruction)this.factory.createInvoke(OTConstants.internalError.getClassName(), "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        il.append((Instruction)new ATHROW());
        return start;
    }

    static BranchInstruction createLookupSwitch(int[] matches, InstructionHandle[] targets, GOTO[] breaks, InstructionHandle defaultBranch, InstructionHandle afterSwitch) {
        int numberOfCases = matches.length;
        int i = 0;
        while (i < numberOfCases) {
            breaks[i].setTarget(afterSwitch);
            ++i;
        }
        HashMap<Integer, InstructionHandle> match_target_mapping = new HashMap<Integer, InstructionHandle>();
        int i2 = 0;
        while (i2 < numberOfCases) {
            match_target_mapping.put(matches[i2], targets[i2]);
            ++i2;
        }
        Arrays.sort(matches);
        i2 = 0;
        while (i2 < numberOfCases) {
            targets[i2] = (InstructionHandle)match_target_mapping.get(matches[i2]);
            ++i2;
        }
        LOOKUPSWITCH inst = new LOOKUPSWITCH(matches, targets, defaultBranch);
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkReadClassAttributes(ClassEnhancer ce, ClassGen cg, String class_name, ConstantPoolGen cpg) {
        ArrayList<String> classesToLoad;
        AttributeReadingGuard guard = AttributeReadingGuard.getInstanceForLoader(this.loader);
        boolean addTeamInitializations = false;
        AttributeReadingGuard attributeReadingGuard = guard;
        synchronized (attributeReadingGuard) {
            if (!guard.iAmTheFirst(class_name)) {
                return;
            }
            if (AttributeReadingGuard.isFirstLoadedClass()) {
                addTeamInitializations = true;
            }
            Attribute[] attrsClass = cg.getAttributes();
            classesToLoad = this.scanClassOTAttributes(attrsClass, class_name, cpg, cg);
            guard.workDone(class_name);
        }
        if (addTeamInitializations) {
            this.addTeamInitializations(cg, ce);
        }
        for (String next : classesToLoad) {
            if (logging) {
                ObjectTeamsTransformation.printLogMessage("Loading of class " + next + " will be forced now!");
            }
            ce.loadClass(next, this);
        }
        Method[] possibleRoleMethods = cg.getMethods();
        int i = 0;
        while (i < possibleRoleMethods.length) {
            Method meth = possibleRoleMethods[i];
            Attribute[] attrsMethod = meth.getAttributes();
            ObjectTeamsTransformation.scanMethodOTAttributes(attrsMethod, class_name, meth.getName(), cpg);
            ++i;
        }
        if (logging) {
            ObjectTeamsTransformation.printLogMessage(String.valueOf(this.getClass().getName()) + " picked up the attributes for class " + class_name);
        }
    }

    Pair<InstructionHandle, Integer>[] saveLineNumbers(MethodGen method, ConstantPoolGen cpg) {
        LineNumberTable lnt = method.getLineNumberTable(cpg);
        InstructionHandle[] ihs = method.getInstructionList().getInstructionHandles();
        Pair[] oldLines = new Pair[lnt.getTableLength()];
        int cur = -1;
        int n = 0;
        int i = 0;
        while (i < ihs.length) {
            int next = lnt.getSourceLine(ihs[i].getPosition());
            if (next > cur) {
                oldLines[n++] = new Pair<InstructionHandle, Integer>(ihs[i], new Integer(next));
            }
            cur = next;
            ++i;
        }
        return oldLines;
    }

    void restoreLineNumbers(MethodGen method, Pair<InstructionHandle, Integer>[] oldLines) {
        int i = 0;
        while (i < oldLines.length) {
            if (oldLines[i] != null) {
                InstructionHandle ih = (InstructionHandle)oldLines[i].first;
                int line = (Integer)oldLines[i].second;
                method.addLineNumber(ih, line);
            }
            ++i;
        }
    }

    private void addTeamInitializations(ClassGen cg, ClassEnhancer ce) {
        LineNumberTable lnt;
        String main_class_name = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        InstructionFactory factory = new InstructionFactory(cpg);
        Method main = cg.containsMethod("main", "([Ljava/lang/String;)V");
        if (main == null) {
            AttributeReadingGuard.reset();
            return;
        }
        MethodGen mainMethod = ObjectTeamsTransformation.newMethodGen(main, main_class_name, cpg);
        InstructionList il = mainMethod.getInstructionList();
        int startLine = -1;
        Pair<InstructionHandle, Integer>[] oldLines = null;
        if (debugging && (lnt = mainMethod.getLineNumberTable(cpg)) != null) {
            startLine = lnt.getSourceLine(0);
            oldLines = this.saveLineNumbers(mainMethod, cpg);
        }
        if (TEAM_CONFIG_FILE != null) {
            InstructionList teamInitializations = new InstructionList();
            List<String> teamsToInitialize = ObjectTeamsTransformation.getTeamsFromConfigFile();
            for (String nextTeam : teamsToInitialize) {
                JavaClass teamClass = null;
                try {
                    teamClass = RepositoryAccess.lookupClassFully(nextTeam);
                }
                catch (ClassNotFoundException cfne) {
                    System.err.println("Config error: Team class '" + nextTeam + "' in config file '" + TEAM_CONFIG_FILE + "' can not be found!");
                    continue;
                }
                ClassGen teamClassGen = new ClassGen(teamClass);
                if (teamClassGen.containsMethod("<init>", "()V") == null) {
                    System.err.println("Activation failed: Team class '" + nextTeam + "' has no default constuctor!");
                    continue;
                }
                ce.loadClass(nextTeam, this);
                if (logging) {
                    ObjectTeamsTransformation.printLogMessage("Adding initialization of team " + nextTeam + " to main method of class " + main_class_name);
                }
                teamInitializations.append((Instruction)factory.createNew(nextTeam));
                teamInitializations.append((Instruction)new DUP());
                teamInitializations.append((Instruction)factory.createInvoke(nextTeam, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
                teamInitializations.append((Instruction)factory.createGetStatic("org.objectteams.Team", "ALL_THREADS", (Type)OTConstants.threadType));
                teamInitializations.append((Instruction)factory.createInvoke(nextTeam, "activate", (Type)Type.VOID, new Type[]{OTConstants.threadType}, (short)182));
            }
            il.insert(teamInitializations);
        }
        InstructionHandle cursor = il.insert((Instruction)new ICONST(1));
        cursor = il.append(cursor, (Instruction)new ACONST_NULL());
        cursor = il.append(cursor, (Instruction)factory.createInvoke("org.objectteams.TeamThreadManager", "newThreadStarted", (Type)Type.BOOLEAN, new Type[]{Type.BOOLEAN, OTConstants.threadType}, (short)184));
        cursor = il.append(cursor, (Instruction)new POP());
        il.setPositions();
        if (debugging && startLine > 0) {
            mainMethod.removeLineNumbers();
            mainMethod.addLineNumber(il.getStart(), startLine - 1);
            this.restoreLineNumbers(mainMethod, oldLines);
        }
        mainMethod.setInstructionList(il);
        mainMethod.setMaxStack();
        mainMethod.setMaxLocals();
        cg.replaceMethod(main, mainMethod.getMethod());
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
    }

    private static List<String> getTeamsFromConfigFile() {
        LinkedList<String> result = new LinkedList<String>();
        try {
            FileInputStream fstream = new FileInputStream(TEAM_CONFIG_FILE);
            BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
            while (in.ready()) {
                String nextLine = in.readLine();
                String nextTeam = nextLine.trim();
                if (nextTeam.startsWith("#") || nextTeam.equals("")) continue;
                result.add(nextTeam.trim());
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("File input error: config file '" + TEAM_CONFIG_FILE + "' can not be found!");
        }
        return result;
    }

    public Collection<String> fetchAdaptedBases() {
        HashSet<String> result = new HashSet<String>(this.adaptedBases);
        this.adaptedBases.clear();
        return result;
    }

    ArrayList<String> scanClassOTAttributes(Attribute[] attributes, String class_name, ConstantPoolGen cpg, ClassGen cg) {
        if (logging) {
            ObjectTeamsTransformation.printLogMessage("Inspecting " + class_name);
        }
        ArrayList<String> classesToLoad = new ArrayList<String>();
        String base_class_name = null;
        int k = 0;
        while (k < attributes.length) {
            block47: {
                String[] names;
                int numberOfEntries;
                int count;
                byte[] indizes;
                String attrName;
                block55: {
                    boolean is_14x_plus;
                    boolean is_13x_plus;
                    boolean greater_123;
                    int revision;
                    int minor;
                    int major;
                    block57: {
                        block69: {
                            block68: {
                                block67: {
                                    block65: {
                                        block66: {
                                            block63: {
                                                block64: {
                                                    block61: {
                                                        block62: {
                                                            block59: {
                                                                block60: {
                                                                    block58: {
                                                                        block56: {
                                                                            block54: {
                                                                                block53: {
                                                                                    block52: {
                                                                                        block51: {
                                                                                            block50: {
                                                                                                block49: {
                                                                                                    block48: {
                                                                                                        Attribute actAttr = attributes[k];
                                                                                                        Unknown attr = ObjectTeamsTransformation.isOTAttribute(actAttr);
                                                                                                        if (attr == null) break block47;
                                                                                                        attrName = attr.getName();
                                                                                                        if (logging) {
                                                                                                            ObjectTeamsTransformation.printLogMessage("CallinBindingAttribute: " + attrName);
                                                                                                        }
                                                                                                        indizes = attr.getBytes();
                                                                                                        count = ObjectTeamsTransformation.combineTwoBytes(indizes, 0);
                                                                                                        numberOfEntries = 0;
                                                                                                        if (!attrName.equals("OTClassFlags")) break block48;
                                                                                                        int classFlags = ObjectTeamsTransformation.combineTwoBytes(indizes, 0);
                                                                                                        String flagsString = "";
                                                                                                        if ((classFlags & 1) != 0) {
                                                                                                            flagsString = "team ";
                                                                                                        }
                                                                                                        if ((classFlags & 2) != 0) {
                                                                                                            flagsString = String.valueOf(flagsString) + "role";
                                                                                                            CallinBindingManager.addRole(class_name);
                                                                                                        }
                                                                                                        if (logging) {
                                                                                                            ObjectTeamsTransformation.printLogMessage("OTClassFlags:");
                                                                                                            ObjectTeamsTransformation.printLogMessage("\t" + flagsString);
                                                                                                        }
                                                                                                        break block47;
                                                                                                    }
                                                                                                    if (!attrName.equals("CallinRoleBaseBindings")) break block49;
                                                                                                    numberOfEntries = 2;
                                                                                                    int i = 2;
                                                                                                    int n = 2 * count * numberOfEntries;
                                                                                                    names = new String[numberOfEntries];
                                                                                                    while (i <= n) {
                                                                                                        i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                        String role_name = names[0];
                                                                                                        String base_name = names[1];
                                                                                                        boolean baseIsInterface = false;
                                                                                                        if (base_name.charAt(0) == '^') {
                                                                                                            baseIsInterface = true;
                                                                                                            base_name = base_name.substring(1);
                                                                                                        }
                                                                                                        if (logging) {
                                                                                                            ObjectTeamsTransformation.printLogMessage("**** Binding: " + role_name + " playedBy " + base_name);
                                                                                                        }
                                                                                                        CallinBindingManager.addRoleBaseBinding(role_name, base_name, baseIsInterface, class_name);
                                                                                                        CallinBindingManager.addTeamBaseRelation(class_name, base_name);
                                                                                                        this.adaptedBases.add(base_name);
                                                                                                        classesToLoad.add(role_name);
                                                                                                    }
                                                                                                    break block47;
                                                                                                }
                                                                                                if (!attrName.equals("BoundClassesHierarchy")) break block50;
                                                                                                numberOfEntries = 2;
                                                                                                int i = 2;
                                                                                                int n = 2 * count * numberOfEntries;
                                                                                                names = new String[numberOfEntries];
                                                                                                while (i <= n) {
                                                                                                    i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                    String sub_name = names[0];
                                                                                                    String super_name = names[1];
                                                                                                    CallinBindingManager.addBoundSuperclassLink(sub_name, super_name);
                                                                                                    if (!logging) continue;
                                                                                                    ObjectTeamsTransformation.printLogMessage("**** super-class link: " + sub_name + " -> " + super_name);
                                                                                                }
                                                                                                break block47;
                                                                                            }
                                                                                            if (!attrName.equals("CallinMethodMappings")) break block51;
                                                                                            int i = 2;
                                                                                            int n = 0;
                                                                                            while (n < count) {
                                                                                                names = new String[1];
                                                                                                i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                String binding_file_name = names[0];
                                                                                                int binding_line_number = ObjectTeamsTransformation.combineTwoBytes(indizes, i);
                                                                                                int binding_line_offset = ObjectTeamsTransformation.combineTwoBytes(indizes, i += 2);
                                                                                                i += 2;
                                                                                                boolean is_static_role_method = false;
                                                                                                boolean covariant_base_return = false;
                                                                                                numberOfEntries = 3;
                                                                                                names = new String[numberOfEntries];
                                                                                                i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                String wrapper_name = null;
                                                                                                String wrapper_signature = null;
                                                                                                int index = 0;
                                                                                                String binding_label = names[index++];
                                                                                                String role_method_name = names[index++];
                                                                                                String role_method_signature = names[index++];
                                                                                                int flags = ObjectTeamsTransformation.combineTwoBytes(indizes, i);
                                                                                                is_static_role_method = (flags & 1) != 0;
                                                                                                covariant_base_return = (flags & 8) != 0;
                                                                                                i += 2;
                                                                                                numberOfEntries = 3;
                                                                                                names = new String[numberOfEntries];
                                                                                                i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                index = 0;
                                                                                                String lift_method_name = names[index++];
                                                                                                String lift_method_signature = names[index++];
                                                                                                String binding_modifier = names[index++];
                                                                                                int base_len = ObjectTeamsTransformation.combineTwoBytes(indizes, i);
                                                                                                i += 2;
                                                                                                names = new String[4];
                                                                                                int n_base = 0;
                                                                                                while (n_base < base_len) {
                                                                                                    byte baseFlags;
                                                                                                    i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                    String base_method_name = names[0];
                                                                                                    String base_method_signature = names[1];
                                                                                                    wrapper_name = names[2];
                                                                                                    wrapper_signature = names[3];
                                                                                                    boolean baseIsCallin = ((baseFlags = indizes[i++]) & 1) != 0;
                                                                                                    boolean baseIsStatic = (baseFlags & 2) != 0;
                                                                                                    int translationFlags = (ObjectTeamsTransformation.combineTwoBytes(indizes, i) << 16) + ObjectTeamsTransformation.combineTwoBytes(indizes, i + 2);
                                                                                                    i += 4;
                                                                                                    if (logging) {
                                                                                                        ObjectTeamsTransformation.printLogMessage("**** Binding: " + binding_label + ":" + role_method_name + role_method_signature + " <- " + binding_modifier + " " + base_method_name + base_method_signature);
                                                                                                        ObjectTeamsTransformation.printLogMessage("**** Wrapper: " + wrapper_name + wrapper_signature);
                                                                                                    }
                                                                                                    CallinBindingManager.addMethodBinding(class_name, base_class_name, binding_file_name, binding_line_number, binding_line_offset, binding_label, role_method_name, role_method_signature, is_static_role_method, wrapper_name, wrapper_signature, binding_modifier, base_method_name, base_method_signature, baseIsStatic, baseIsCallin, covariant_base_return, translationFlags, lift_method_name, lift_method_signature);
                                                                                                    ++n_base;
                                                                                                }
                                                                                                ++n;
                                                                                            }
                                                                                            break block47;
                                                                                        }
                                                                                        if (!attrName.equals("OTSpecialAccess")) break block52;
                                                                                        numberOfEntries = 3;
                                                                                        int i = 2;
                                                                                        int j = 0;
                                                                                        while (j < count) {
                                                                                            byte kind = indizes[i++];
                                                                                            switch (kind) {
                                                                                                case 1: {
                                                                                                    names = new String[numberOfEntries];
                                                                                                    i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                    if (logging) {
                                                                                                        ObjectTeamsTransformation.printLogMessage("**** Callout: " + names[0] + "." + names[1] + " " + names[2]);
                                                                                                    }
                                                                                                    CallinBindingManager.addCalloutBinding(names[0], names[1], names[2]);
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    byte flags = indizes[i++];
                                                                                                    String accessMode = (flags & 1) == 1 ? "set" : "get";
                                                                                                    boolean isStaticField = (flags & 2) != 0;
                                                                                                    names = new String[numberOfEntries];
                                                                                                    i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                    if (logging) {
                                                                                                        ObjectTeamsTransformation.printLogMessage("**** Callout bound field: " + accessMode + (isStaticField ? " static " : " ") + names[2] + " " + names[1]);
                                                                                                    }
                                                                                                    CallinBindingManager.addCalloutBoundFileds(names[0], names[1], names[2], accessMode, isStaticField);
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    numberOfEntries = 4;
                                                                                                    names = new String[numberOfEntries];
                                                                                                    i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                                    if (logging) {
                                                                                                        ObjectTeamsTransformation.printLogMessage("**** SuperAccess: " + names[0] + "." + names[2] + names[3] + " superclass " + names[1]);
                                                                                                    }
                                                                                                    CallinBindingManager.addSuperAccess(names[0], names[1], names[2], names[3]);
                                                                                                }
                                                                                            }
                                                                                            ++j;
                                                                                        }
                                                                                        count = ObjectTeamsTransformation.combineTwoBytes(indizes, i);
                                                                                        i += 2;
                                                                                        names = new String[1];
                                                                                        j = 0;
                                                                                        while (j < count) {
                                                                                            byte flag;
                                                                                            i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                            if ((flag = indizes[i++]) == 1) {
                                                                                                CallinBindingManager.addBaseClassForModifierChange(names[0]);
                                                                                            } else {
                                                                                                this.adaptedBases.add(names[0]);
                                                                                            }
                                                                                            ++j;
                                                                                        }
                                                                                        break block47;
                                                                                    }
                                                                                    if (!attrName.equals("ReferencedTeams")) break block53;
                                                                                    numberOfEntries = 1;
                                                                                    int i = 2;
                                                                                    int n = 2 * count * numberOfEntries;
                                                                                    names = new String[numberOfEntries];
                                                                                    while (i <= n) {
                                                                                        i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                                                                                        String referenced_team = names[0];
                                                                                        if (logging) {
                                                                                            ObjectTeamsTransformation.printLogMessage("**** found ReferencedTeams: " + referenced_team);
                                                                                        }
                                                                                        classesToLoad.add(referenced_team);
                                                                                    }
                                                                                    break block47;
                                                                                }
                                                                                if (!attrName.equals("PlayedBy")) break block54;
                                                                                names = new String[1];
                                                                                ObjectTeamsTransformation.scanStrings(names, indizes, 0, cpg);
                                                                                base_class_name = names[0];
                                                                                int langle = base_class_name.indexOf(60);
                                                                                if (langle > -1) {
                                                                                    base_class_name = base_class_name.substring(0, langle - 1);
                                                                                }
                                                                                if (logging) {
                                                                                    ObjectTeamsTransformation.printLogMessage("**** found PlayedBy:  " + base_class_name);
                                                                                }
                                                                                CallinBindingManager.addSuperRoleLink(cg.getClassName(), cg.getSuperclassName());
                                                                                break block47;
                                                                            }
                                                                            if (!attrName.equals("OTCompilerVersion")) break block55;
                                                                            int encodedVersion = ObjectTeamsTransformation.combineTwoBytes(indizes, 0);
                                                                            major = encodedVersion >>> 9;
                                                                            minor = encodedVersion >>> 5 & 0xF;
                                                                            revision = encodedVersion & 0x1F;
                                                                            if (logging) {
                                                                                ObjectTeamsTransformation.printLogMessage("**** class file was produced by compiler version " + major + "." + minor + "." + revision + " ****");
                                                                            }
                                                                            greater_123 = false;
                                                                            is_13x_plus = false;
                                                                            is_14x_plus = false;
                                                                            if ((encodedVersion & 0x8000) != 0) {
                                                                                throw new UnsupportedClassVersionError("OTRE: Class " + class_name + " was compiled for incompatible weaving target OTDRE");
                                                                            }
                                                                            if (major != 1 || minor != 7) break block56;
                                                                            greater_123 = true;
                                                                            is_13x_plus = true;
                                                                            is_14x_plus = true;
                                                                            break block57;
                                                                        }
                                                                        if (major != 1 || minor != 6) break block58;
                                                                        greater_123 = true;
                                                                        is_13x_plus = true;
                                                                        is_14x_plus = true;
                                                                        break block57;
                                                                    }
                                                                    if (major != 1 || minor != 5) break block59;
                                                                    if (revision >= 0) break block60;
                                                                    if (!class_name.startsWith("org.objectteams.Team")) {
                                                                        throw new InternalError("OTRE: Class " + class_name + " has unsupported revision " + revision);
                                                                    }
                                                                    break block47;
                                                                }
                                                                greater_123 = true;
                                                                is_13x_plus = true;
                                                                is_14x_plus = true;
                                                                break block57;
                                                            }
                                                            if (major != 1 || minor != 4) break block61;
                                                            if (revision >= 1) break block62;
                                                            if (!class_name.startsWith("org.objectteams.Team")) {
                                                                throw new InternalError("OTRE: Class " + class_name + " has unsupported revision " + revision);
                                                            }
                                                            break block47;
                                                        }
                                                        greater_123 = true;
                                                        is_13x_plus = true;
                                                        is_14x_plus = true;
                                                        break block57;
                                                    }
                                                    if (major != 1 || minor != 3) break block63;
                                                    if (revision >= 0) break block64;
                                                    if (!class_name.startsWith("org.objectteams.Team")) {
                                                        throw new InternalError("OTRE: Class " + class_name + " has unsupported revision " + revision);
                                                    }
                                                    break block47;
                                                }
                                                greater_123 = true;
                                                is_13x_plus = true;
                                                break block57;
                                            }
                                            if (major != 1 || minor != 2) break block65;
                                            if (revision >= 0) break block66;
                                            if (!class_name.startsWith("org.objectteams.Team")) {
                                                throw new InternalError("OTRE: Class " + class_name + " has unsupported revision " + revision);
                                            }
                                            break block47;
                                        }
                                        if (revision > 3) {
                                            greater_123 = true;
                                        }
                                        break block57;
                                    }
                                    if (major != 1 || minor != 1) break block67;
                                    if (revision >= 0) break block57;
                                    if (!class_name.startsWith("org.objectteams.Team")) {
                                        throw new InternalError("OTRE: Class " + class_name + " has unsupported revision " + revision);
                                    }
                                    break block47;
                                }
                                if (major != 1 || minor != 0) break block68;
                                if (revision >= 0) break block57;
                                if (!class_name.startsWith("org.objectteams.Team")) {
                                    throw new InternalError("OTRE: Class " + class_name + " has unsupported revision " + revision);
                                }
                                break block47;
                            }
                            if (major != 0 || minor != 9) break block69;
                            if (revision >= 26) break block57;
                            if (!class_name.startsWith("org.objectteams.Team")) {
                                throw new InternalError("OTRE: Class " + class_name + " has unsupported revision " + revision);
                            }
                            break block47;
                        }
                        if (major != 1) {
                            throw new InternalError("OTRE: Class " + class_name + " has unsupported major version " + major);
                        }
                        if (minor != 6) {
                            throw new InternalError("OTRE: Class " + class_name + " has unsupported minor version " + minor);
                        }
                        throw new InternalError("OTRE: Class " + class_name + " has unrecognized version " + major + "." + minor + "." + revision);
                    }
                    if (COMPILER_VERSION_READ) {
                        if (IS_COMPILER_GREATER_123 != greater_123 || IS_COMPILER_13X_PLUS != is_13x_plus || IS_COMPILER_14X_PLUS != is_14x_plus) {
                            throw new InternalError("OTRE: Illegal mix of class file versions at " + class_name + " " + major + '.' + minor + '.' + revision + '\n' + " previous flags : " + IS_COMPILER_GREATER_123 + ',' + IS_COMPILER_13X_PLUS + ',' + IS_COMPILER_14X_PLUS);
                        }
                    } else {
                        IS_COMPILER_GREATER_123 = greater_123;
                        IS_COMPILER_13X_PLUS = is_13x_plus;
                        IS_COMPILER_14X_PLUS = is_14x_plus;
                        COMPILER_VERSION_READ = true;
                    }
                    break block47;
                }
                if (attrName.equals("CallinPrecedence")) {
                    LinkedList<String> precedenceList = new LinkedList<String>();
                    numberOfEntries = 1;
                    int i = 2;
                    int n = 2 * count * numberOfEntries;
                    names = new String[numberOfEntries];
                    while (i <= n) {
                        i = ObjectTeamsTransformation.scanStrings(names, indizes, i, cpg);
                        String binding_label = names[0];
                        precedenceList.add(binding_label);
                    }
                    if (logging) {
                        ObjectTeamsTransformation.printLogMessage("**** found precedence list for " + class_name + ": " + precedenceList + " ****");
                    }
                    CallinBindingManager.addPrecedenceList(precedenceList, class_name);
                }
            }
            ++k;
        }
        return classesToLoad;
    }

    public static int scanStrings(String[] entries, byte[] indizes, int i, ConstantPoolGen cpg) {
        int j = 0;
        while (j < entries.length) {
            String content;
            int nextIndex = ObjectTeamsTransformation.combineTwoBytes(indizes, i);
            ConstantUtf8 cons = (ConstantUtf8)cpg.getConstant(nextIndex);
            entries[j] = content = cons.getBytes();
            i += 2;
            ++j;
        }
        return i;
    }

    static void scanMethodOTAttributes(Attribute[] attributes, String class_name, String method_name, ConstantPoolGen cpg) {
        int k = 0;
        while (k < attributes.length) {
            Attribute actAttr = attributes[k];
            Unknown attr = ObjectTeamsTransformation.isOTAttribute(actAttr);
            if (attr != null) {
                String attrName = attr.getName();
                if (logging) {
                    ObjectTeamsTransformation.printLogMessage("CallinBindingAttribute(" + method_name + ") :" + attrName);
                }
                if (attrName.equals("CallinParamMappings")) {
                    byte[] indizes = attr.getBytes();
                    int[] positions = null;
                    if (indizes == null) {
                        throw new RuntimeException("Unexpected null attr");
                    }
                    int count = ObjectTeamsTransformation.combineTwoBytes(indizes, 0);
                    positions = new int[count];
                    int p = 2;
                    int i = 0;
                    while (i < count) {
                        positions[i] = ObjectTeamsTransformation.combineTwoBytes(indizes, p);
                        ++i;
                        p += 2;
                    }
                    CallinBindingManager.addParameterBinding(class_name, method_name, positions);
                }
            }
            ++k;
        }
    }

    static Unknown isOTAttribute(Attribute attr) {
        Unknown unknown;
        String attrName;
        if (attr instanceof Unknown && ((attrName = (unknown = (Unknown)attr).getName()).equals("CallinRoleBaseBindings") || attrName.equals("BoundClassesHierarchy") || attrName.equals("CallinMethodMappings") || attrName.equals("CallinParamMappings") || attrName.equals("CallinFlags") || attrName.equals("OTSpecialAccess") || attrName.equals("WrappedRoleSignature") || attrName.equals("WrappedBaseSignature") || attrName.equals("ReferencedTeams") || attrName.equals("PlayedBy") || attrName.equals("Modifiers") || attrName.equals("OTCompilerVersion") || attrName.equals("OTClassFlags") || attrName.equals("OTJoinPoints") || attrName.equals("CallinPrecedence") || attrName.equals("StaticReplaceBindings"))) {
            return unknown;
        }
        return null;
    }

    public static int combineTwoBytes(byte[] indizes, int start) {
        byte first = indizes[start];
        byte second = indizes[start + 1];
        int twoBytes = 0;
        twoBytes |= first & 0xFF;
        twoBytes <<= 8;
        return twoBytes |= second & 0xFF;
    }

    protected static MethodGen newMethodGen(Method m, String class_name, ConstantPoolGen cp) {
        MethodGen mg = new MethodGen(m, class_name, cp);
        ArrayList<Attribute> attributesToRemove = new ArrayList<Attribute>();
        Attribute[] attributeArray = mg.getCodeAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            if (attr instanceof Unknown || attr instanceof StackMap) {
                attributesToRemove.add(attr);
            }
            ++n2;
        }
        for (Attribute attr : attributesToRemove) {
            mg.removeCodeAttribute(attr);
        }
        return mg;
    }

    protected static MethodGen wipeMethod(Method m, String class_name, ConstantPoolGen cpg) {
        MethodGen mg = new MethodGen(m, class_name, cpg);
        mg.getInstructionList().dispose();
        mg.removeLineNumbers();
        mg.removeLocalVariables();
        mg.removeExceptionHandlers();
        mg.removeAttributes();
        mg.removeCodeAttributes();
        return mg;
    }

    static void addToConstructor(Method m, InstructionList addedCode, ClassGen cg, ConstantPoolGen cpg) {
        String class_name = cg.getClassName();
        MethodGen mg = ObjectTeamsTransformation.newMethodGen(m, class_name, cpg);
        InstructionList il = mg.getInstructionList().copy();
        InstructionHandle[] ihs = il.getInstructionHandles();
        MethodGen newConstructor = new MethodGen(mg.getAccessFlags(), mg.getReturnType(), mg.getArgumentTypes(), mg.getArgumentNames(), mg.getName(), class_name, il, cpg);
        ObjectTeamsTransformation.updateCopiedMethod(mg, il, ihs, newConstructor);
        int stackDepth = 0;
        int actInstrIndex = 0;
        boolean pauseStackCounting = false;
        InstructionHandle gotoTarget = null;
        while (!(ihs[actInstrIndex].getInstruction() instanceof INVOKESPECIAL) || stackDepth - ihs[actInstrIndex].getInstruction().consumeStack(cpg) != 0) {
            Instruction actInstruction = ihs[actInstrIndex].getInstruction();
            if (gotoTarget != null && actInstruction.equals((Object)gotoTarget.getInstruction())) {
                pauseStackCounting = false;
                gotoTarget = null;
            }
            if (actInstruction instanceof GotoInstruction) {
                GotoInstruction gotoInsruction = (GotoInstruction)actInstruction;
                gotoTarget = gotoInsruction.getTarget();
                pauseStackCounting = true;
            }
            if (!pauseStackCounting) {
                stackDepth -= actInstruction.consumeStack(cpg);
                stackDepth += actInstruction.produceStack(cpg);
            }
            ++actInstrIndex;
        }
        InstructionHandle ih = ihs[actInstrIndex];
        INVOKESPECIAL invoke = (INVOKESPECIAL)ih.getInstruction();
        String specialName = invoke.getName(cpg);
        if (!specialName.equals("<init>")) {
            System.err.println("###ALERT: " + specialName);
            return;
        }
        if (logging) {
            ObjectTeamsTransformation.printLogMessage("Adding code to " + class_name + "." + m.getName());
        }
        int addedCodeLength = ObjectTeamsTransformation.padCodeToAdd(addedCode);
        InstructionHandle startOfAddedCode = il.append(ih, addedCode);
        il.setPositions();
        newConstructor.setInstructionList(il);
        newConstructor.setMaxStack();
        newConstructor.setMaxLocals();
        newConstructor.setMaxLocals(Math.max(newConstructor.getMaxLocals(), mg.getMaxLocals()));
        ObjectTeamsTransformation.copyAndAdjustLineNumbers(mg, newConstructor, addedCodeLength, startOfAddedCode);
        cg.replaceMethod(m, newConstructor.getMethod());
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
    }

    static int padCodeToAdd(InstructionList addedCode) {
        int addedCodeLength = 0;
        Instruction[] instr = addedCode.getInstructions();
        int i = 0;
        while (i < instr.length) {
            addedCodeLength += instr[i].getLength();
            ++i;
        }
        while (addedCodeLength % 4 > 0) {
            addedCode.append((Instruction)new NOP());
            ++addedCodeLength;
        }
        return addedCodeLength;
    }

    static void updateCopiedMethod(MethodGen methodOrig, InstructionList ilCopy, InstructionHandle[] ihsCopy, MethodGen methodCopy) {
        LocalVariableGen[] oldLocals = methodOrig.getLocalVariables();
        int argLen = methodOrig.getArgumentTypes().length;
        if (!methodOrig.isStatic()) {
            ++argLen;
        }
        if (oldLocals.length > argLen) {
            InstructionList oldIL = methodOrig.getInstructionList();
            int maxLocals = methodOrig.getMaxLocals();
            int i = argLen;
            while (i < oldLocals.length) {
                LocalVariableGen var = oldLocals[i];
                LocalVariableGen newVar = methodCopy.addLocalVariable(var.getName(), var.getType(), ObjectTeamsTransformation.mapIH(var.getStart(), oldIL, ihsCopy), ObjectTeamsTransformation.mapIH(var.getEnd(), oldIL, ihsCopy));
                newVar.setIndex(var.getIndex());
                methodCopy.setMaxLocals(maxLocals);
                ++i;
            }
        }
        BaseCallRedirection.copyExceptionHandlers(methodOrig, methodCopy, ilCopy);
        String[] stringArray = methodOrig.getExceptions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String excName = stringArray[n2];
            methodCopy.addException(excName);
            ++n2;
        }
    }

    static InstructionHandle mapIH(InstructionHandle alienIH, InstructionList oldIL, InstructionHandle[] newIHs) {
        int position = alienIH.getPosition();
        int[] newPositions = oldIL.getInstructionPositions();
        int i = 0;
        while (i < newPositions.length) {
            if (newPositions[i] == position) {
                return newIHs[i];
            }
            ++i;
        }
        return null;
    }

    static void copyAndAdjustLineNumbers(MethodGen src, MethodGen dest, int offset, InstructionHandle startOfAddedCode) {
        InstructionList il_dest = dest.getInstructionList();
        LineNumberGen[] src_lng = src.getLineNumbers();
        boolean addedCodeHasLineNumber = false;
        int i = 0;
        while (i < src_lng.length) {
            int position = src_lng[i].getInstruction().getPosition();
            if (position == startOfAddedCode.getPosition()) {
                dest.addLineNumber(startOfAddedCode, 65534);
                addedCodeHasLineNumber = true;
            } else {
                InstructionHandle ih;
                if (position >= startOfAddedCode.getPosition()) {
                    position += offset;
                }
                if ((ih = il_dest.findHandle(position)) == null) {
                    System.err.println("Handle not found!");
                } else {
                    dest.addLineNumber(ih, src_lng[i].getSourceLine());
                }
            }
            ++i;
        }
        if (!addedCodeHasLineNumber) {
            dest.addLineNumber(startOfAddedCode, 65534);
        }
    }

    public static boolean methodHasCallinFlags(Method m, ClassGen cg, int callin_flags) {
        boolean found = false;
        Attribute[] attributes = m.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            Unknown attr;
            Attribute actAttr = attributes[i];
            if (actAttr instanceof Unknown && (attr = (Unknown)actAttr).getName().equals("CallinFlags")) {
                if (callin_flags == 0) {
                    return true;
                }
                byte[] bytes = attr.getBytes();
                int flags = ObjectTeamsTransformation.combineTwoBytes(bytes, 0);
                if ((flags & callin_flags) != 0) {
                    if (logging) {
                        ObjectTeamsTransformation.printLogMessage("Found CallinFlag " + callin_flags + " for " + cg.getClassName() + "." + m.getName() + ".");
                    }
                    found = true;
                }
            }
            ++i;
        }
        return found;
    }

    protected static boolean classNeedsTeamExtensions(ClassGen cg) {
        return (cg.getAccessFlags() & 0x8000) != 0 && (cg.getAccessFlags() & 0x400) == 0 && !cg.getClassName().equals("org.objectteams.Team");
    }

    protected static String genImplementingRoleName(String roleName) {
        int lastDollar = roleName.lastIndexOf(36);
        StringBuilder sb = new StringBuilder(roleName);
        sb.insert(lastDollar + 1, "__OT__");
        return sb.toString();
    }

    public static String genRoleInterfaceName(String roleName) {
        int lastDollar = roleName.lastIndexOf(36);
        StringBuilder sb = new StringBuilder(roleName);
        sb.delete(lastDollar + 1, lastDollar + 1 + "__OT__".length());
        return sb.toString();
    }

    protected static boolean isReflectiveOTMethod(String methodName, String methodSignature) {
        return methodName.equals("hasRole") && methodSignature.equals("(Ljava/lang/Object;)Z") || methodName.equals("hasRole") && methodSignature.equals("(Ljava/lang/Object;Ljava/lang/Class;)Z") || methodName.equals("getRole") && methodSignature.equals("(Ljava/lang/Object;)Ljava/lang/Object;") || methodName.equals("getRole") && methodSignature.equals("(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;") || methodName.equals("getAllRoles") && methodSignature.equals("()[Ljava/lang/Object;") || methodName.equals("getAllRoles") && methodSignature.equals("(Ljava/lang/Class;)[Ljava/lang/Object;") || methodName.equals("unregisterRole") && methodSignature.equals("(Ljava/lang/Object;)V") || methodName.equals("unregisterRole") && methodSignature.equals("(Ljava/lang/Object;Ljava/lang/Class;)V");
    }

    public static String getOuterClassName(String className) {
        int dollarIndex = className.lastIndexOf(36);
        if (dollarIndex == -1) {
            return null;
        }
        String outerClassName = className.substring(0, dollarIndex);
        return outerClassName;
    }

    static boolean candidateForImplicitActivation(Method m, ClassGen cg, ConstantPoolGen cpg) {
        if (!IS_COMPILER_14X_PLUS) {
            implicitActivationMode = ImplicitActivationMode.ALWAYS;
        }
        switch (implicitActivationMode) {
            case NEVER: {
                return false;
            }
            case ANNOTATED: {
                if (AnnotationHelper.containsImplicitActivationAttribute(m.getAttributes(), cpg) || AnnotationHelper.containsImplicitActivationAttribute(cg.getAttributes(), cpg)) {
                    return ObjectTeamsTransformation.canImplicitlyActivate(m);
                }
                return false;
            }
            case ALWAYS: {
                Attribute[] attributes;
                if (!ObjectTeamsTransformation.canImplicitlyActivate(m)) {
                    return false;
                }
                Attribute[] attributeArray = attributes = m.getAttributes();
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    byte[] bytes;
                    int flags;
                    Unknown attr;
                    String attrName;
                    Attribute a = attributeArray[n2];
                    if (a instanceof Unknown && "RoleClassMethodModifiers".equals(attrName = (attr = (Unknown)a).getName()) && ((flags = ObjectTeamsTransformation.combineTwoBytes(bytes = attr.getBytes(), 0)) == 0 || flags == 4)) {
                        return false;
                    }
                    ++n2;
                }
                if (!m.isPublic()) {
                    return false;
                }
                String className = cg.getClassName();
                return !CallinBindingManager.isRole(className) || !cg.isProtected();
            }
        }
        return false;
    }

    private static boolean canImplicitlyActivate(Method m) {
        String methodName = m.getName();
        String methodSignature = m.getSignature();
        boolean isCandidate = !(m.isAbstract() || m.isStatic() || methodName.startsWith("_OT$") || methodName.equals("<init>") || methodName.equals("activate") && methodSignature.equals("()V") || methodName.equals("deactivate") && methodSignature.equals("()V") || ObjectTeamsTransformation.isReflectiveOTMethod(m.getName(), methodSignature));
        return isCandidate;
    }

    static int countOccurrences(String s, char c) {
        int count = 0;
        int idx = s.indexOf(c);
        while (idx != -1) {
            idx = s.indexOf(c, idx + 1);
            ++count;
        }
        return count;
    }

    Method genImplicitActivation(Method m, String className, ConstantPoolGen cpg, boolean activateOuter) {
        String targetName = className;
        int nestingDepth = 0;
        ObjectType outerClass = null;
        if (activateOuter) {
            outerClass = new ObjectType(ObjectTeamsTransformation.getOuterClassName(className));
            nestingDepth = ObjectTeamsTransformation.countOccurrences(className, '$') - 1;
            targetName = outerClass.getClassName();
        }
        MethodGen mg = ObjectTeamsTransformation.newMethodGen(m, className, cpg);
        InstructionList il = mg.getInstructionList();
        InstructionList prefix = new InstructionList();
        InstructionHandle try_start = il.getStart();
        prefix.append(InstructionFactory.createThis());
        if (activateOuter) {
            prefix.append((Instruction)this.factory.createGetField(className, "this$" + nestingDepth, (Type)outerClass));
        }
        prefix.append((Instruction)this.factory.createInvoke(targetName, "_OT$implicitlyActivate", (Type)Type.VOID, Type.NO_ARGS, (short)182));
        if (debugging) {
            mg.addLineNumber(prefix.getStart(), 65534);
        }
        il.insert(prefix);
        InstructionList postfix = new InstructionList();
        postfix.append(InstructionFactory.createThis());
        if (activateOuter) {
            postfix.append((Instruction)this.factory.createGetField(className, "this$" + nestingDepth, (Type)outerClass));
        }
        postfix.append((Instruction)this.factory.createInvoke(targetName, "_OT$implicitlyDeactivate", (Type)Type.VOID, Type.NO_ARGS, (short)182));
        ObjectTeamsTransformation.insertBeforeReturn(mg, il, postfix);
        ObjectType throwable = new ObjectType("java.lang.Throwable");
        LocalVariableGen exception = mg.addLocalVariable("_OT$thrown_exception", (Type)throwable, null, null);
        InstructionHandle try_end = il.getEnd();
        InstructionList postfix_ex = postfix.copy();
        if (debugging) {
            mg.addLineNumber(postfix_ex.getStart(), 65534);
        }
        postfix_ex.insert((Instruction)InstructionFactory.createStore((Type)throwable, (int)exception.getIndex()));
        postfix_ex.append((Instruction)InstructionFactory.createLoad((Type)throwable, (int)exception.getIndex()));
        postfix_ex.append((Instruction)new ATHROW());
        InstructionHandle deactivation_handler = il.append(il.getEnd(), postfix_ex);
        mg.addExceptionHandler(try_start, try_end, deactivation_handler, throwable);
        mg.setInstructionList(il);
        mg.setMaxLocals();
        mg.setMaxStack();
        if (!debugging) {
            return mg.getMethod();
        }
        Method newMethod = mg.getMethod();
        MethodGen newMethodGen = new MethodGen(newMethod, className, cpg);
        LineNumberGen[] lineNumbers = newMethodGen.getLineNumbers();
        newMethodGen.removeLineNumbers();
        Arrays.sort(lineNumbers, new Comparator<LineNumberGen>(){

            @Override
            public int compare(LineNumberGen ln1, LineNumberGen ln2) {
                int secondLineNumberPC;
                int firstLineNumberPC = ln1.getLineNumber().getStartPC();
                if (firstLineNumberPC < (secondLineNumberPC = ln2.getLineNumber().getStartPC())) {
                    return -1;
                }
                if (firstLineNumberPC > secondLineNumberPC) {
                    return 1;
                }
                return 0;
            }
        });
        int i = 0;
        while (i < lineNumbers.length) {
            newMethodGen.addLineNumber(lineNumbers[i].getInstruction(), lineNumbers[i].getSourceLine());
            ++i;
        }
        return newMethodGen.getMethod();
    }

    protected static int stackDiff(Instruction instr, ConstantPoolGen cpg) {
        return instr.produceStack(cpg) - instr.consumeStack(cpg);
    }

    protected InstructionList[] splitLoading(ConstantPoolGen cpg, InstructionList src, Type[] argumentTypes) {
        int len = argumentTypes.length;
        InstructionList[] res = new InstructionList[len];
        int idx = len - 1;
        while (idx >= 0) {
            Instruction load;
            res[idx] = new InstructionList();
            for (int expectedArgSize = argumentTypes[idx].getSize(); expectedArgSize > 0; expectedArgSize -= ObjectTeamsTransformation.stackDiff(load, cpg)) {
                InstructionHandle loadH = src.getEnd();
                load = loadH.getInstruction();
                try {
                    res[idx].insert(load);
                    src.delete(loadH);
                    continue;
                }
                catch (TargetLostException e) {
                    throw new OTREInternalError((Throwable)e);
                }
            }
            --idx;
        }
        return res;
    }

    protected InstructionList translateLoads(InstructionList[] splitLoad, Type[] enhancedRoleArgumentTypes, Type[] enhancedBaseArgumentTypes, int[] parameterPositions, String teamName, String enclosingRoleName, BaseMethodInfo baseMethod, int start, ConstantPoolGen cpg) {
        boolean isStatic = baseMethod.isStatic;
        boolean baseIsStaticRoleMethod = baseMethod.isStaticRoleMethod();
        boolean baseIsCallin = baseMethod.isCallin;
        int translationFlags = baseMethod.translationFlags;
        InstructionList il = new InstructionList();
        int nextUnusedArg = 0;
        int baseIdx = start;
        while (baseIdx < enhancedBaseArgumentTypes.length) {
            int roleSrcIdx;
            int baseSrcIdx = baseIdx - start;
            if (baseIsStaticRoleMethod) {
                baseSrcIdx -= 2;
            }
            if (baseIsCallin) {
                baseSrcIdx -= 6;
            }
            if (baseSrcIdx < 0) {
                roleSrcIdx = -1;
            } else {
                int numAvailableRoleArgs = enhancedRoleArgumentTypes.length - 6;
                if (!isStatic && IS_COMPILER_GREATER_123) {
                    --numAvailableRoleArgs;
                }
                roleSrcIdx = this.getMappedRolePosition(baseSrcIdx, parameterPositions, numAvailableRoleArgs);
            }
            Type baseArgumentType = enhancedBaseArgumentTypes[baseIdx];
            if (roleSrcIdx == -1) {
                this.retrieveFromUnusedArg(il, nextUnusedArg++, baseArgumentType, cpg);
            } else {
                int roleIdx = roleSrcIdx + 6;
                if (IS_COMPILER_GREATER_123 && !isStatic) {
                    ++roleIdx;
                }
                Type roleArgumentType = enhancedRoleArgumentTypes[roleIdx];
                il.append(splitLoad[roleSrcIdx]);
                if (!roleArgumentType.equals((Object)baseArgumentType)) {
                    this.convertParamToBase(il, teamName, enclosingRoleName, roleArgumentType, baseArgumentType, (translationFlags & 2 << baseSrcIdx) != 0);
                }
            }
            ++baseIdx;
        }
        if (il.isEmpty()) {
            il.append((Instruction)new NOP());
        }
        return il;
    }

    private int getMappedRolePosition(int baseSrcIdx, int[] parameterPositions, int numAvailableRoleArgs) {
        if (parameterPositions == null) {
            if (baseSrcIdx < numAvailableRoleArgs) {
                return baseSrcIdx;
            }
        } else {
            int i = 0;
            while (i < parameterPositions.length) {
                if (parameterPositions[i] == baseSrcIdx + 1) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void retrieveFromUnusedArg(InstructionList il, int unusedIdx, Type baseArgumentType, ConstantPoolGen cpg) {
        il.append((Instruction)InstructionFactory.createLoad((Type)objectArray, (int)6));
        il.append(this.createIntegerPush(cpg, unusedIdx));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)objectArray));
        if (baseArgumentType instanceof BasicType) {
            il.append(this.createUnboxing((BasicType)baseArgumentType));
        } else {
            il.append(this.factory.createCast((Type)object, baseArgumentType));
        }
    }

    private void convertParamToBase(InstructionList il, String teamName, String enclosingRoleName, Type roleArgumentType, Type baseArgumentType, boolean loweringFlag) {
        if (roleArgumentType instanceof ObjectType && baseArgumentType instanceof ObjectType) {
            if (loweringFlag) {
                this.lowerObject(il, teamName, roleArgumentType, baseArgumentType);
            } else {
                if (logging) {
                    ObjectTeamsTransformation.printLogMessage("Try to cast " + roleArgumentType + " to " + baseArgumentType);
                }
                il.append(this.factory.createCast(roleArgumentType, baseArgumentType));
            }
        } else if (roleArgumentType instanceof BasicType && baseArgumentType instanceof ObjectType) {
            il.append(this.createBoxing((BasicType)roleArgumentType));
        } else if (roleArgumentType instanceof ObjectType && baseArgumentType instanceof BasicType) {
            il.append(this.createUnboxing((BasicType)baseArgumentType));
        } else if (roleArgumentType instanceof ArrayType && baseArgumentType instanceof ArrayType) {
            this.lowerArray(il, teamName, enclosingRoleName, roleArgumentType, baseArgumentType);
        } else {
            throw new OTREInternalError("OTRE internal error:No way to make types conform\nrole type " + roleArgumentType + " -> " + baseArgumentType);
        }
    }

    private void lowerObject(InstructionList il, String teamName, Type roleArgumentType, Type baseArgumentType) {
        String roleIfcName = ((ObjectType)roleArgumentType).getClassName();
        String roleClassName = ObjectTeamsTransformation.genImplementingRoleName(roleIfcName);
        int dollarIdx = roleClassName.lastIndexOf(36);
        if (dollarIdx == -1) {
            throw new OTREInternalError("OTRE internal error:No way to make types conform\nrole type " + roleArgumentType + " -> " + baseArgumentType);
        }
        boolean isNested = dollarIdx != roleClassName.indexOf(36);
        String strengthenedRoleName = String.valueOf(teamName) + roleClassName.substring(dollarIdx);
        RoleBaseBinding rbb = CallinBindingManager.getRoleBaseBinding(strengthenedRoleName);
        if (rbb != null) {
            baseArgumentType = new ObjectType(rbb.getBaseClassName());
        }
        if (isNested) {
            short kind = roleIfcName.lastIndexOf(36) == roleIfcName.lastIndexOf("$__OT__") ? (short)182 : 185;
            il.append((Instruction)this.factory.createInvoke(roleIfcName, "_OT$getBase", baseArgumentType, new Type[0], kind));
        } else {
            il.append(this.factory.createCast(roleArgumentType, (Type)new ObjectType(strengthenedRoleName)));
            il.append((Instruction)this.factory.createGetField(strengthenedRoleName, "_OT$base", baseArgumentType));
        }
    }

    private void lowerArray(InstructionList il, String teamName, String enclosingRoleName, Type roleArgumentType, Type baseArgumentType) {
        ArrayType array = (ArrayType)roleArgumentType;
        String roleName = ((ObjectType)array.getElementType()).getClassName();
        int dollarIdx = roleName.lastIndexOf(36);
        String pureRoleName = roleName.substring(dollarIdx + 1);
        String transformMethodName = this.getArrayLoweringMethodName(pureRoleName, array.getDimensions());
        if (enclosingRoleName != null) {
            il.append(InstructionFactory.createThis());
            il.append((Instruction)this.factory.createGetField(enclosingRoleName, "this$0", (Type)new ObjectType(teamName)));
        } else {
            il.append(InstructionFactory.createThis());
        }
        il.append((Instruction)new SWAP());
        il.append((Instruction)this.factory.createInvoke(teamName, transformMethodName, baseArgumentType, new Type[]{roleArgumentType}, (short)182));
    }

    private String getArrayLoweringMethodName(String roleName, int dimensions) {
        return "_OT$transformArray" + roleName + "_OT$" + dimensions;
    }

    public List<String> getInnerClassNames(ClassGen cg, ConstantPoolGen cpg) {
        Attribute[] attributes = cg.getAttributes();
        LinkedList<String> innerClassNames = new LinkedList<String>();
        int i = 0;
        while (i < attributes.length) {
            Attribute actAttr = attributes[i];
            if (actAttr instanceof InnerClasses) {
                InnerClass[] inners = ((InnerClasses)actAttr).getInnerClasses();
                int j = 0;
                while (j < inners.length) {
                    int name_index = inners[j].getInnerNameIndex();
                    Constant name_c = cpg.getConstant(name_index);
                    String name = ((ConstantUtf8)name_c).getBytes();
                    innerClassNames.add(name);
                    ++j;
                }
            }
            ++i;
        }
        return innerClassNames;
    }

    protected Pair<Integer, InstructionHandle> addClassMonitorEnter(MethodGen mg, InstructionList il, String class_name, int major, ConstantPoolGen cpg) {
        return this.addClassMonitorEnter(mg, il, class_name, class_name, major, cpg);
    }

    protected Pair<Integer, InstructionHandle> addClassMonitorEnter(MethodGen mg, InstructionList il, String class_name_this, String class_name_target, int major, ConstantPoolGen cpg) {
        InstructionHandle ih = this.appendClassLiteral(il, class_name_this, class_name_target, major, cpg);
        il.append((Instruction)new DUP());
        LocalVariableGen lg2 = mg.addLocalVariable("monitor", (Type)Type.OBJECT, il.getStart(), null);
        int monitor = lg2.getIndex();
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)monitor));
        il.append((Instruction)new MONITORENTER());
        return new Pair<Integer, InstructionHandle>(monitor, ih);
    }

    protected InstructionHandle appendClassLiteral(InstructionList il, String class_name_this, String class_name_target, int major, ConstantPoolGen cpg) {
        if (major >= 49) {
            return il.append((Instruction)new LDC(cpg.addClass(new ObjectType(class_name_target))));
        }
        String receiverClass = class_name_this;
        String fieldName = class_name_this.equals(class_name_this) ? "_OT$self_class$" : "_OT$class_literal$" + class_name_target;
        InstructionHandle start = il.append((Instruction)this.factory.createFieldAccess(receiverClass, fieldName, (Type)classType, (short)178));
        il.append((Instruction)new DUP());
        BranchInstruction checkLoaded = InstructionFactory.createBranchInstruction((short)199, null);
        il.append(checkLoaded);
        il.append((Instruction)new POP());
        il.append((Instruction)new LDC(cpg.addString(class_name_target)));
        il.append((Instruction)this.factory.createInvoke("java.lang.Class", "forName", (Type)classType, new Type[]{new ObjectType("java.lang.String")}, (short)184));
        il.append((Instruction)new DUP());
        il.append((Instruction)this.factory.createFieldAccess(receiverClass, fieldName, (Type)classType, (short)179));
        checkLoaded.setTarget(il.append((Instruction)new NOP()));
        return start;
    }

    public static void insertBeforeReturn(MethodGen mg, InstructionList il, InstructionList insertion) {
        for (InstructionHandle ihAr : il) {
            if (!(ihAr.getInstruction() instanceof ReturnInstruction)) continue;
            InstructionList insertionCopy = insertion.copy();
            if (debugging) {
                mg.addLineNumber(insertionCopy.getStart(), 65534);
            }
            InstructionHandle inserted = il.insert(ihAr, insertionCopy);
            il.redirectBranches(ihAr, inserted);
        }
    }

    public static class BaseMethodInfo {
        private String baseClassName;
        private String baseMethodName;
        private String baseMethodSignature;
        boolean isCallin;
        private boolean isRoleMethod;
        boolean isStatic;
        private int[] parameterPositions;
        int translationFlags;

        BaseMethodInfo(String base_class_name, String base_method_name, String base_method_signature, boolean isCallin, boolean isRoleMethod, boolean isStatic, int[] parameter_positions, int translationFlags) {
            this.baseClassName = base_class_name;
            this.baseMethodName = base_method_name;
            this.baseMethodSignature = base_method_signature;
            this.isCallin = isCallin;
            this.isRoleMethod = isRoleMethod;
            this.isStatic = isStatic;
            this.parameterPositions = parameter_positions;
            this.translationFlags = translationFlags;
        }

        BaseMethodInfo(boolean isCallin, boolean isStatic, int translationFlags) {
            this.isCallin = isCallin;
            this.isStatic = isStatic;
            this.translationFlags = translationFlags;
        }

        public boolean isStaticRoleMethod() {
            return this.isRoleMethod && this.isStatic;
        }

        String getBaseClassName() {
            return this.baseClassName;
        }

        String getBaseMethodName() {
            return this.baseMethodName;
        }

        String getBaseMethodSignature() {
            return this.baseMethodSignature;
        }

        int[] getParameterPositions() {
            return this.parameterPositions;
        }
    }

    static enum ImplicitActivationMode {
        NEVER,
        ANNOTATED,
        ALWAYS;

    }

    class Pair<F, S> {
        F first;
        S second;

        Pair(F f, S s) {
            this.first = f;
            this.second = s;
        }
    }
}

