/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.ui.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.IBuildServerConfiguration;
import org.eclipse.mylyn.builds.core.spi.BuildServerConfiguration;
import org.eclipse.mylyn.builds.internal.core.BuildPlan;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshConfigurationOperation;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.repositories.core.RepositoryValidator;
import org.eclipse.mylyn.commons.repositories.ui.RepositoryLocationPart;
import org.eclipse.mylyn.commons.workbench.SubstringPatternFilter;
import org.eclipse.mylyn.internal.builds.ui.BuildServerValidator;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class BuildServerPart
extends RepositoryLocationPart {
    private final IBuildServer model;
    private CheckboxTreeViewer planViewer;
    private List<IBuildPlan> selectedPlans;

    public BuildServerPart(IBuildServer model) {
        super(model.getLocation());
        this.model = model;
        this.selectedPlans = Collections.emptyList();
        this.setNeedsProxy(true);
        this.setNeedsHttpAuth(true);
        this.setNeedsCertificateAuth(true);
    }

    protected void applyValidatorResult(RepositoryValidator validator) {
        IBuildServerConfiguration configuration;
        super.applyValidatorResult(validator);
        if (!validator.getResult().isOK()) {
            StatusHandler.log((IStatus)validator.getResult());
        }
        if ((configuration = ((Validator)validator).getConfiguration()) != null) {
            this.setInput(configuration, this.getSelectedPlans());
        }
    }

    protected void setInput(IBuildServerConfiguration configuration, Collection<IBuildPlan> selectedPlans) {
        Set<String> selectedIds = BuildsUiInternal.toSetOfIds(selectedPlans);
        for (IBuildPlan plan : configuration.getPlans()) {
            ((BuildPlan)plan).setSelected(selectedIds.contains(plan.getId()));
        }
        this.planViewer.setInput((Object)configuration);
        this.planViewer.expandAll();
    }

    public boolean canValidate() {
        return true;
    }

    private void createButtons(Composite section) {
        Button refreshButton = new Button(section, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)refreshButton);
        refreshButton.setText("&Refresh");
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuildServerPart.this.validate();
            }
        });
        Button selectAllButton = new Button(section, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)selectAllButton);
        selectAllButton.setText("&Select All");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = BuildServerPart.this.planViewer.getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getData() instanceof BuildPlan) {
                        ((BuildPlan)item.getData()).setSelected(true);
                    }
                    ++n2;
                }
                BuildServerPart.this.planViewer.refresh();
            }
        });
        Button deselectAllButton = new Button(section, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)deselectAllButton);
        deselectAllButton.setText("&Deselect All");
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = BuildServerPart.this.planViewer.getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getData() instanceof BuildPlan) {
                        ((BuildPlan)item.getData()).setSelected(false);
                    }
                    ++n2;
                }
                BuildServerPart.this.planViewer.refresh();
            }
        });
        Button dummyButton = new Button(section, 32);
        dummyButton.setVisible(false);
        dummyButton.setText("Save Password");
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        try {
            IBuildServerConfiguration configuration = this.getModel().getConfiguration();
            this.setInput(configuration, this.selectedPlans);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return control;
    }

    protected Control createAdditionalContents(final Composite parent) {
        final ExpandableComposite section = new ExpandableComposite(parent, 0, 114);
        section.clientVerticalSpacing = 0;
        section.setBackground(parent.getBackground());
        section.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (section.getLayoutData() instanceof GridData) {
                    ((GridData)section.getLayoutData()).grabExcessVerticalSpace = e.getState();
                }
                parent.layout(true);
            }
        });
        section.setText("Build Plans");
        Composite composite = new Composite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 5).applyTo(composite);
        CheckboxFilteredTree filteredTree = new CheckboxFilteredTree(composite, 67584, (PatternFilter)new SubstringPatternFilter());
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)filteredTree);
        this.planViewer = filteredTree.getCheckboxTreeViewer();
        this.planViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BuildPlan plan = (BuildPlan)event.getElement();
                plan.setSelected(event.getChecked());
            }
        });
        this.planViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((IBuildPlan)element).isSelected();
            }

            public boolean isGrayed(Object element) {
                for (IBuildPlan child : ((IBuildPlan)element).getChildren()) {
                    if (child.isSelected()) continue;
                    return true;
                }
                return false;
            }
        });
        this.planViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IBuildPlan)element).getName();
            }
        });
        this.planViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){
            private BuildServerConfiguration configuration;
            private final Object[] EMPTY_ARRAY = new Object[0];

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return this.EMPTY_ARRAY;
            }

            public Object[] getElements(Object inputElement) {
                return this.configuration.getPlans().toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.configuration = (BuildServerConfiguration)newInput;
            }
        });
        this.planViewer.setSorter(new ViewerSorter());
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).extendedMargins(0, 0, 0, 0).applyTo(buttonComposite);
        this.createButtons(buttonComposite);
        return section;
    }

    public final IBuildServer getModel() {
        return this.model;
    }

    public List<IBuildPlan> getSelectedPlans() {
        if (this.planViewer.getInput() instanceof BuildServerConfiguration) {
            BuildServerConfiguration configuration = (BuildServerConfiguration)this.planViewer.getInput();
            ArrayList<IBuildPlan> selectedPlans = new ArrayList<IBuildPlan>();
            for (IBuildPlan plan : configuration.getPlans()) {
                if (!plan.isSelected()) continue;
                selectedPlans.add(plan);
            }
            return selectedPlans;
        }
        return Collections.emptyList();
    }

    protected RepositoryValidator getValidator() {
        return new Validator(this.getModel());
    }

    public void initSelectedPlans(List<IBuildPlan> selectedPlans) {
        Assert.isNotNull(selectedPlans);
        this.selectedPlans = selectedPlans;
    }

    private class CheckboxFilteredTree
    extends FilteredTree {
        public CheckboxFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter, true);
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return new CheckboxTreeViewer(parent, style);
        }

        public CheckboxTreeViewer getCheckboxTreeViewer() {
            return this.getViewer();
        }

        public CheckboxTreeViewer getViewer() {
            return (CheckboxTreeViewer)super.getViewer();
        }
    }

    private class Validator
    extends BuildServerValidator {
        private IBuildServerConfiguration configuration;

        public Validator(IBuildServer server) {
            super(server);
        }

        public IBuildServerConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public IStatus run(IProgressMonitor monitor) {
            IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)monitor, (String)"Validating repository", (int)3);
            progress.addFlag(IOperationMonitor.OperationFlag.BACKGROUND);
            try {
                IBuildServer server = this.getServer();
                IStatus result = ((BuildServer)server).validate(progress.newChild(1));
                if (result.isOK()) {
                    RefreshConfigurationOperation op = new RefreshConfigurationOperation(Collections.singletonList(server));
                    op.doRefresh((BuildServer)server, progress.newChild(2));
                    result = op.getStatus();
                    this.configuration = server.getConfiguration();
                }
                return result;
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Server validation failed: {0}", (Object)e.getMessage()), (Throwable)e);
            }
        }
    }
}

