/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.util.IProgressListener;

public final class XClassHistogramRecord
extends ClassHistogramRecord {
    private static final long serialVersionUID = 1L;
    private ClassImpl classInstance;

    public XClassHistogramRecord(ClassImpl classInstance) throws SnapshotException {
        super(classInstance.getName(), classInstance.getObjectId(), (long)classInstance.getNumberOfObjects(), classInstance.getTotalSize(), classInstance.getRetainedHeapSizeOfObjects(false, false, null));
        this.classInstance = classInstance;
    }

    public int getClassId() {
        return this.classInstance.getObjectId();
    }

    public int[] getObjectIds() {
        try {
            return this.classInstance.source.getIndexManager().c2objects().getObjectsOf(this.classInstance.getCacheEntry());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long calculateRetainedSize(ISnapshot snapshot, boolean calculateIfNotAvailable, boolean approximation, IProgressListener listener) throws SnapshotException {
        if (this.retainedHeapSize > 0L || !calculateIfNotAvailable) {
            return this.retainedHeapSize;
        }
        if (this.retainedHeapSize < 0L && approximation) {
            return this.retainedHeapSize;
        }
        this.retainedHeapSize = this.classInstance.getRetainedHeapSizeOfObjects(calculateIfNotAvailable, approximation, listener);
        return this.retainedHeapSize;
    }
}

