/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerCopyTo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyToContainerCommandHandler
extends AbstractHandler {
    private static final String ERROR_COPYING_TO_CONTAINER_NO_CONNECTION = "command.copytocontainer.failure.no_connection";
    private static final String MISSING_CONNECTION = "missing_connection";
    private static final String ERROR_COPYING_TO_CONTAINER = "command.copytocontainer.error.msg";
    private static final String COPY_TO_CONTAINER_JOB_TASK = "command.copytocontainer.job.task";
    private static final String COPY_TO_CONTAINER_JOB_TITLE = "command.copytocontainer.job.title";
    private static final String COPY_TO_CONTAINER_JOB_SUBTASK = "command.copytocontainer.job.subtask";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (selectedContainers.size() != 1) {
            return null;
        }
        IDockerContainer container = selectedContainers.get(0);
        if (connection == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getString(MISSING_CONNECTION), (String)CommandMessages.getString(ERROR_COPYING_TO_CONTAINER_NO_CONNECTION));
        } else {
            ContainerCopyTo wizard = new ContainerCopyTo(connection, container);
            boolean copyToContainer = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (copyToContainer) {
                this.performCopyToContainer(connection, container, wizard.getTarget(), wizard.getSources());
            }
        }
        return null;
    }

    private void performCopyToContainer(final IDockerConnection connection, final IDockerContainer container, final String target, final List<Object> files) {
        Job copyToContainerJob = new Job(CommandMessages.getFormattedString(COPY_TO_CONTAINER_JOB_TITLE, container.name())){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static /* synthetic */ void lambda$0(Object object, IDockerContainer iDockerContainer, IOException iOException) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getFormattedString(CopyToContainerCommandHandler.ERROR_COPYING_TO_CONTAINER, object.toString(), iDockerContainer.name()), (String)iOException.getMessage());
            }

            private static /* synthetic */ void lambda$1(String string, IDockerContainer iDockerContainer, Exception exception) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getFormattedString(CopyToContainerCommandHandler.ERROR_COPYING_TO_CONTAINER, string, iDockerContainer.name()), (String)(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()));
            }
        };
        copyToContainerJob.schedule();
    }

    private void deleteTmpDir(Path tmpPath) {
        File tmpDir = tmpPath.toFile();
        File[] fileArray = tmpDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        tmpDir.delete();
    }

    static /* synthetic */ void access$0(CopyToContainerCommandHandler copyToContainerCommandHandler, Path path) {
        copyToContainerCommandHandler.deleteTmpDir(path);
    }
}

