/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.model;

import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ProcessesFactory;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.model.SelectNameWizardPage;
import org.eclipse.ui.IWorkbench;

public class CreateProcessWizard
extends Wizard {
    protected SelectNameWizardPage initialPage;
    protected Package defaultPackage = null;

    public CreateProcessWizard() {
        this.setWindowTitle(PluginProperties.wizards_ProcessWizard_title);
    }

    public CreateProcessWizard(Package defaultPackage) {
        this();
        this.defaultPackage = defaultPackage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialPage = new SelectNameWizardPage(org.eclipse.jwt.meta.PluginProperties.model_Activity_type, this.defaultPackage, workbench);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.initialPage);
        this.initialPage.setDescription(PluginProperties.wizards_Page_name_package);
    }

    public boolean performFinish() {
        String name = this.initialPage.getName();
        Package selectedPackage = this.initialPage.getPackage();
        String icon = this.initialPage.getIconPath();
        ProcessesFactory factory = ProcessesFactory.eINSTANCE;
        Activity activity = factory.createActivity();
        activity.setName(name);
        activity.setPackage(selectedPackage);
        activity.setIcon(icon);
        CommandParameter childDescriptor = new CommandParameter(null, (Object)CorePackage.Literals.PACKAGE__ELEMENTS, (Object)activity);
        Command cmd = CreateChildCommand.create((EditingDomain)this.getEditingDomain(), (Object)selectedPackage, (Object)childDescriptor, Collections.singleton(selectedPackage));
        this.getEditingDomain().getCommandStack().execute(cmd);
        GeneralHelper.getActiveInstance().openActivityInNewPage(activity);
        return true;
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }
}

