/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.providers;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.meta.Plugin;
import org.eclipse.jwt.meta.providers.interfaces.ICommandProvider;
import org.eclipse.jwt.meta.providers.interfaces.IImageProvider;
import org.eclipse.jwt.meta.providers.interfaces.IModelProvider;
import org.eclipse.jwt.meta.providers.interfaces.IVisibilityProvider;
import org.eclipse.jwt.meta.providers.standard.DefaultCommandProvider;
import org.eclipse.jwt.meta.providers.standard.DefaultImageProvider;
import org.eclipse.jwt.meta.providers.standard.DefaultModelProvider;
import org.eclipse.jwt.meta.providers.standard.DefaultVisibilityProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ResourceProviderRegistry {
    private static ResourceProviderRegistry myinstance;
    private HashMap<IEditorPart, IImageProvider> imageProviders = new HashMap();
    private HashMap<IEditorPart, IVisibilityProvider> visibilityProviders = new HashMap();
    private HashMap<IEditorPart, ICommandProvider> commandProviders = new HashMap();
    private HashMap<IEditorPart, IModelProvider> modelProviders = new HashMap();
    private IVisibilityProvider defaultVisibilityProvider;
    private IImageProvider defaultImageProvider = new DefaultImageProvider();
    private ICommandProvider defaultCommandProvider;
    private IModelProvider defaultModelProvider;
    private IEditorPart initializingEditor;

    public static ResourceProviderRegistry getInstance() {
        if (myinstance == null) {
            myinstance = new ResourceProviderRegistry();
        }
        return myinstance;
    }

    public ResourceProviderRegistry() {
        this.defaultVisibilityProvider = new DefaultVisibilityProvider();
        this.defaultCommandProvider = new DefaultCommandProvider();
        this.defaultModelProvider = new DefaultModelProvider();
    }

    public void setInitializingEditor(IEditorPart initializingEditor) {
        this.initializingEditor = initializingEditor;
    }

    public void registerImageProvider(IEditorPart editorpart, IImageProvider imageProvider) {
        this.imageProviders.put(editorpart, imageProvider);
    }

    public void registerVisibilityProvider(IEditorPart editorpart, IVisibilityProvider visibilityProvider) {
        this.visibilityProviders.put(editorpart, visibilityProvider);
    }

    public void registerCommandProvider(IEditorPart editorpart, ICommandProvider commandProvider) {
        this.commandProviders.put(editorpart, commandProvider);
    }

    public void registerModelProvider(IEditorPart editorpart, IModelProvider modelProvider) {
        this.modelProviders.put(editorpart, modelProvider);
    }

    public void deregisterImageProvider(IEditorPart editorpart) {
        if (this.imageProviders != null) {
            this.imageProviders.remove(editorpart);
        }
    }

    public void deregisterVisibilityProvider(IEditorPart editorpart) {
        if (this.visibilityProviders != null) {
            this.visibilityProviders.remove(editorpart);
        }
    }

    public void deregisterCommandProvider(IEditorPart editorpart) {
        if (this.commandProviders != null) {
            this.commandProviders.remove(editorpart);
        }
    }

    public void deregisterModelProvider(IEditorPart editorpart) {
        if (this.modelProviders != null) {
            this.modelProviders.remove(editorpart);
        }
    }

    public IEditorPart getActiveEditor() {
        if (this.initializingEditor != null) {
            return this.initializingEditor;
        }
        IWorkbenchWindow workbenchwindow = Plugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchwindow == null) {
            return null;
        }
        IWorkbenchPage activepage = workbenchwindow.getActivePage();
        if (activepage == null) {
            return null;
        }
        return activepage.getActiveEditor();
    }

    public boolean displayObject(Object object) {
        IVisibilityProvider vp = this.visibilityProviders.get(this.getActiveEditor()) != null ? this.visibilityProviders.get(this.getActiveEditor()) : this.defaultVisibilityProvider;
        return vp.displayObject(object);
    }

    public ImageDescriptor createImageDescriptor(Object object) {
        IImageProvider ip = this.imageProviders.get(this.getActiveEditor()) != null ? this.imageProviders.get(this.getActiveEditor()) : this.defaultImageProvider;
        return ip.createImageDescriptor(object);
    }

    public Command createProviderCommand(String commandType, EditingDomain domain, Object owner, EStructuralFeature feature, Object data) {
        ICommandProvider cp = this.commandProviders.get(this.getActiveEditor()) != null ? this.commandProviders.get(this.getActiveEditor()) : this.defaultCommandProvider;
        return cp.createProviderCommand(commandType, domain, owner, feature, data);
    }

    public Command createCommand(AdapterFactoryEditingDomain domain, Class commandClass, CommandParameter commandParameter) {
        ICommandProvider cp = this.commandProviders.get(this.getActiveEditor()) != null ? this.commandProviders.get(this.getActiveEditor()) : this.defaultCommandProvider;
        return cp.createCommand(domain, commandClass, commandParameter);
    }

    public Collection getModelChildren(Object object, Collection standardChildren) {
        IModelProvider mp = this.modelProviders.get(this.getActiveEditor()) != null ? this.modelProviders.get(this.getActiveEditor()) : this.defaultModelProvider;
        return mp.getModelChildren(object, standardChildren);
    }
}

