/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.Writer;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.RevWalkTextBuiltin;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;

@Command(usage="usage_RevList")
class RevList
extends RevWalkTextBuiltin {
    RevList() {
    }

    @Override
    protected void show(RevCommit c) throws Exception {
        if (c.has(RevFlag.UNINTERESTING)) {
            this.outw.print('-');
        }
        c.getId().copyTo(this.outbuffer, (Writer)this.outw);
        if (this.parents) {
            for (int i = 0; i < c.getParentCount(); ++i) {
                this.outw.print(' ');
                c.getParent(i).getId().copyTo(this.outbuffer, (Writer)this.outw);
            }
        }
        this.outw.println();
    }

    @Override
    protected void show(ObjectWalk ow, RevObject obj) throws Exception {
        if (obj.has(RevFlag.UNINTERESTING)) {
            this.outw.print('-');
        }
        obj.getId().copyTo(this.outbuffer, (Writer)this.outw);
        String path = ow.getPathString();
        if (path != null) {
            this.outw.print(' ');
            this.outw.print((Object)path);
        } else if (obj instanceof RevTree) {
            this.outw.print(' ');
        }
        this.outw.println();
    }
}

