/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.impl;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IConfigurationElement;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.epp.internal.logging.aeri.ide.IIdePackage;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;

import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IServerConnection;
import org.eclipse.epp.logging.aeri.core.IUserSettings;

import org.eclipse.epp.logging.aeri.core.impl.LinkableImpl;

import org.eclipse.swt.graphics.Image;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Server Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getReporterId <em>Reporter Id</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getReporterName <em>Reporter Name</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getReporterEmail <em>Reporter Email</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#isAnonymizeMessages <em>Anonymize Messages</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#isAnonymizeStackTraces <em>Anonymize Stack Traces</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#isDisableAutomaticWiringAnalysis <em>Disable Automatic Wiring Analysis</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getContributor <em>Contributor</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getClazz <em>Clazz</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getIcon16 <em>Icon16</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getIcon32 <em>Icon32</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getConnection <em>Connection</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#isConfigured <em>Configured</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#isEnabled <em>Enabled</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl#getConfigurationElement <em>Configuration Element</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ServerDescriptorImpl extends LinkableImpl implements IServerDescriptor {
	/**
	 * The default value of the '{@link #getReporterId() <em>Reporter Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterId()
	 * @generated
	 * @ordered
	 */
	protected static final String REPORTER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getReporterId() <em>Reporter Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterId()
	 * @generated
	 * @ordered
	 */
	protected String reporterId = REPORTER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getReporterName() <em>Reporter Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterName()
	 * @generated
	 * @ordered
	 */
	protected static final String REPORTER_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getReporterName() <em>Reporter Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterName()
	 * @generated
	 * @ordered
	 */
	protected String reporterName = REPORTER_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getReporterEmail() <em>Reporter Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterEmail()
	 * @generated
	 * @ordered
	 */
	protected static final String REPORTER_EMAIL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getReporterEmail() <em>Reporter Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterEmail()
	 * @generated
	 * @ordered
	 */
	protected String reporterEmail = REPORTER_EMAIL_EDEFAULT;

	/**
	 * The default value of the '{@link #isAnonymizeMessages() <em>Anonymize Messages</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeMessages()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ANONYMIZE_MESSAGES_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAnonymizeMessages() <em>Anonymize Messages</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeMessages()
	 * @generated
	 * @ordered
	 */
	protected boolean anonymizeMessages = ANONYMIZE_MESSAGES_EDEFAULT;

	/**
	 * The default value of the '{@link #isAnonymizeStackTraces() <em>Anonymize Stack Traces</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeStackTraces()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ANONYMIZE_STACK_TRACES_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isAnonymizeStackTraces() <em>Anonymize Stack Traces</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeStackTraces()
	 * @generated
	 * @ordered
	 */
	protected boolean anonymizeStackTraces = ANONYMIZE_STACK_TRACES_EDEFAULT;

	/**
	 * The default value of the '{@link #isDisableAutomaticWiringAnalysis() <em>Disable Automatic Wiring Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisableAutomaticWiringAnalysis()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDisableAutomaticWiringAnalysis() <em>Disable Automatic Wiring Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisableAutomaticWiringAnalysis()
	 * @generated
	 * @ordered
	 */
	protected boolean disableAutomaticWiringAnalysis = DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getContributor() <em>Contributor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContributor()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTRIBUTOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContributor() <em>Contributor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContributor()
	 * @generated
	 * @ordered
	 */
	protected String contributor = CONTRIBUTOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getClazz() <em>Clazz</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClazz()
	 * @generated
	 * @ordered
	 */
	protected static final String CLAZZ_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getClazz() <em>Clazz</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClazz()
	 * @generated
	 * @ordered
	 */
	protected String clazz = CLAZZ_EDEFAULT;

	/**
	 * The default value of the '{@link #getIcon16() <em>Icon16</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon16()
	 * @generated
	 * @ordered
	 */
	protected static final String ICON16_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIcon16() <em>Icon16</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon16()
	 * @generated
	 * @ordered
	 */
	protected String icon16 = ICON16_EDEFAULT;

	/**
	 * The default value of the '{@link #getIcon32() <em>Icon32</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon32()
	 * @generated
	 * @ordered
	 */
	protected static final String ICON32_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIcon32() <em>Icon32</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIcon32()
	 * @generated
	 * @ordered
	 */
	protected String icon32 = ICON32_EDEFAULT;

	/**
	 * The default value of the '{@link #getConnection() <em>Connection</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConnection()
	 * @generated
	 * @ordered
	 */
	protected static final IServerConnection CONNECTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getConnection() <em>Connection</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConnection()
	 * @generated
	 * @ordered
	 */
	protected IServerConnection connection = CONNECTION_EDEFAULT;

	/**
	 * The default value of the '{@link #isConfigured() <em>Configured</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isConfigured()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CONFIGURED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isConfigured() <em>Configured</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isConfigured()
	 * @generated
	 * @ordered
	 */
	protected boolean configured = CONFIGURED_EDEFAULT;

	/**
	 * The default value of the '{@link #isEnabled() <em>Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnabled()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLED_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isEnabled() <em>Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnabled()
	 * @generated
	 * @ordered
	 */
	protected boolean enabled = ENABLED_EDEFAULT;

	/**
	 * The default value of the '{@link #getConfigurationElement() <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigurationElement()
	 * @generated
	 * @ordered
	 */
	protected static final IConfigurationElement CONFIGURATION_ELEMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getConfigurationElement() <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigurationElement()
	 * @generated
	 * @ordered
	 */
	protected IConfigurationElement configurationElement = CONFIGURATION_ELEMENT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServerDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IIdePackage.Literals.SERVER_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getReporterId() {
		return reporterId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReporterId(String newReporterId) {
		String oldReporterId = reporterId;
		reporterId = newReporterId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__REPORTER_ID, oldReporterId, reporterId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getReporterName() {
		return reporterName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReporterName(String newReporterName) {
		String oldReporterName = reporterName;
		reporterName = newReporterName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__REPORTER_NAME, oldReporterName, reporterName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getReporterEmail() {
		return reporterEmail;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReporterEmail(String newReporterEmail) {
		String oldReporterEmail = reporterEmail;
		reporterEmail = newReporterEmail;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__REPORTER_EMAIL, oldReporterEmail, reporterEmail));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAnonymizeMessages() {
		return anonymizeMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnonymizeMessages(boolean newAnonymizeMessages) {
		boolean oldAnonymizeMessages = anonymizeMessages;
		anonymizeMessages = newAnonymizeMessages;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES, oldAnonymizeMessages, anonymizeMessages));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAnonymizeStackTraces() {
		return anonymizeStackTraces;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnonymizeStackTraces(boolean newAnonymizeStackTraces) {
		boolean oldAnonymizeStackTraces = anonymizeStackTraces;
		anonymizeStackTraces = newAnonymizeStackTraces;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES, oldAnonymizeStackTraces, anonymizeStackTraces));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDisableAutomaticWiringAnalysis() {
		return disableAutomaticWiringAnalysis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisableAutomaticWiringAnalysis(boolean newDisableAutomaticWiringAnalysis) {
		boolean oldDisableAutomaticWiringAnalysis = disableAutomaticWiringAnalysis;
		disableAutomaticWiringAnalysis = newDisableAutomaticWiringAnalysis;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS, oldDisableAutomaticWiringAnalysis, disableAutomaticWiringAnalysis));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContributor() {
		return contributor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContributor(String newContributor) {
		String oldContributor = contributor;
		contributor = newContributor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__CONTRIBUTOR, oldContributor, contributor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getClazz() {
		return clazz;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClazz(String newClazz) {
		String oldClazz = clazz;
		clazz = newClazz;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__CLAZZ, oldClazz, clazz));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIcon16() {
		return icon16;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIcon16(String newIcon16) {
		String oldIcon16 = icon16;
		icon16 = newIcon16;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__ICON16, oldIcon16, icon16));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIcon32() {
		return icon32;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIcon32(String newIcon32) {
		String oldIcon32 = icon32;
		icon32 = newIcon32;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__ICON32, oldIcon32, icon32));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IServerConnection getConnection() {
		return connection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConnection(IServerConnection newConnection) {
		IServerConnection oldConnection = connection;
		connection = newConnection;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__CONNECTION, oldConnection, connection));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isConfigured() {
		return configured;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfigured(boolean newConfigured) {
		boolean oldConfigured = configured;
		configured = newConfigured;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__CONFIGURED, oldConfigured, configured));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEnabled() {
		return enabled;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnabled(boolean newEnabled) {
		boolean oldEnabled = enabled;
		enabled = newEnabled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__ENABLED, oldEnabled, enabled));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IConfigurationElement getConfigurationElement() {
		return configurationElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
		IConfigurationElement oldConfigurationElement = configurationElement;
		configurationElement = newConfigurationElement;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IIdePackage.SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT, oldConfigurationElement, configurationElement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Image getImage16() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Image getImage32() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isActive() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_ID:
				return getReporterId();
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_NAME:
				return getReporterName();
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_EMAIL:
				return getReporterEmail();
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES:
				return isAnonymizeMessages();
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES:
				return isAnonymizeStackTraces();
			case IIdePackage.SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				return isDisableAutomaticWiringAnalysis();
			case IIdePackage.SERVER_DESCRIPTOR__ID:
				return getId();
			case IIdePackage.SERVER_DESCRIPTOR__NAME:
				return getName();
			case IIdePackage.SERVER_DESCRIPTOR__DESCRIPTION:
				return getDescription();
			case IIdePackage.SERVER_DESCRIPTOR__CONTRIBUTOR:
				return getContributor();
			case IIdePackage.SERVER_DESCRIPTOR__CLAZZ:
				return getClazz();
			case IIdePackage.SERVER_DESCRIPTOR__ICON16:
				return getIcon16();
			case IIdePackage.SERVER_DESCRIPTOR__ICON32:
				return getIcon32();
			case IIdePackage.SERVER_DESCRIPTOR__CONNECTION:
				return getConnection();
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURED:
				return isConfigured();
			case IIdePackage.SERVER_DESCRIPTOR__ENABLED:
				return isEnabled();
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT:
				return getConfigurationElement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_ID:
				setReporterId((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_NAME:
				setReporterName((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_EMAIL:
				setReporterEmail((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES:
				setAnonymizeMessages((Boolean)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES:
				setAnonymizeStackTraces((Boolean)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				setDisableAutomaticWiringAnalysis((Boolean)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ID:
				setId((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__NAME:
				setName((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONTRIBUTOR:
				setContributor((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CLAZZ:
				setClazz((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ICON16:
				setIcon16((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ICON32:
				setIcon32((String)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONNECTION:
				setConnection((IServerConnection)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURED:
				setConfigured((Boolean)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ENABLED:
				setEnabled((Boolean)newValue);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT:
				setConfigurationElement((IConfigurationElement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_ID:
				setReporterId(REPORTER_ID_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_NAME:
				setReporterName(REPORTER_NAME_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_EMAIL:
				setReporterEmail(REPORTER_EMAIL_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES:
				setAnonymizeMessages(ANONYMIZE_MESSAGES_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES:
				setAnonymizeStackTraces(ANONYMIZE_STACK_TRACES_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				setDisableAutomaticWiringAnalysis(DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ID:
				setId(ID_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__NAME:
				setName(NAME_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONTRIBUTOR:
				setContributor(CONTRIBUTOR_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CLAZZ:
				setClazz(CLAZZ_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ICON16:
				setIcon16(ICON16_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ICON32:
				setIcon32(ICON32_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONNECTION:
				setConnection(CONNECTION_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURED:
				setConfigured(CONFIGURED_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__ENABLED:
				setEnabled(ENABLED_EDEFAULT);
				return;
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT:
				setConfigurationElement(CONFIGURATION_ELEMENT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_ID:
				return REPORTER_ID_EDEFAULT == null ? reporterId != null : !REPORTER_ID_EDEFAULT.equals(reporterId);
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_NAME:
				return REPORTER_NAME_EDEFAULT == null ? reporterName != null : !REPORTER_NAME_EDEFAULT.equals(reporterName);
			case IIdePackage.SERVER_DESCRIPTOR__REPORTER_EMAIL:
				return REPORTER_EMAIL_EDEFAULT == null ? reporterEmail != null : !REPORTER_EMAIL_EDEFAULT.equals(reporterEmail);
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES:
				return anonymizeMessages != ANONYMIZE_MESSAGES_EDEFAULT;
			case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES:
				return anonymizeStackTraces != ANONYMIZE_STACK_TRACES_EDEFAULT;
			case IIdePackage.SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				return disableAutomaticWiringAnalysis != DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT;
			case IIdePackage.SERVER_DESCRIPTOR__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case IIdePackage.SERVER_DESCRIPTOR__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case IIdePackage.SERVER_DESCRIPTOR__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case IIdePackage.SERVER_DESCRIPTOR__CONTRIBUTOR:
				return CONTRIBUTOR_EDEFAULT == null ? contributor != null : !CONTRIBUTOR_EDEFAULT.equals(contributor);
			case IIdePackage.SERVER_DESCRIPTOR__CLAZZ:
				return CLAZZ_EDEFAULT == null ? clazz != null : !CLAZZ_EDEFAULT.equals(clazz);
			case IIdePackage.SERVER_DESCRIPTOR__ICON16:
				return ICON16_EDEFAULT == null ? icon16 != null : !ICON16_EDEFAULT.equals(icon16);
			case IIdePackage.SERVER_DESCRIPTOR__ICON32:
				return ICON32_EDEFAULT == null ? icon32 != null : !ICON32_EDEFAULT.equals(icon32);
			case IIdePackage.SERVER_DESCRIPTOR__CONNECTION:
				return CONNECTION_EDEFAULT == null ? connection != null : !CONNECTION_EDEFAULT.equals(connection);
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURED:
				return configured != CONFIGURED_EDEFAULT;
			case IIdePackage.SERVER_DESCRIPTOR__ENABLED:
				return enabled != ENABLED_EDEFAULT;
			case IIdePackage.SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT:
				return CONFIGURATION_ELEMENT_EDEFAULT == null ? configurationElement != null : !CONFIGURATION_ELEMENT_EDEFAULT.equals(configurationElement);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == IUserSettings.class) {
			switch (derivedFeatureID) {
				case IIdePackage.SERVER_DESCRIPTOR__REPORTER_ID: return IModelPackage.USER_SETTINGS__REPORTER_ID;
				case IIdePackage.SERVER_DESCRIPTOR__REPORTER_NAME: return IModelPackage.USER_SETTINGS__REPORTER_NAME;
				case IIdePackage.SERVER_DESCRIPTOR__REPORTER_EMAIL: return IModelPackage.USER_SETTINGS__REPORTER_EMAIL;
				case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES: return IModelPackage.USER_SETTINGS__ANONYMIZE_MESSAGES;
				case IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES: return IModelPackage.USER_SETTINGS__ANONYMIZE_STACK_TRACES;
				case IIdePackage.SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS: return IModelPackage.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == IUserSettings.class) {
			switch (baseFeatureID) {
				case IModelPackage.USER_SETTINGS__REPORTER_ID: return IIdePackage.SERVER_DESCRIPTOR__REPORTER_ID;
				case IModelPackage.USER_SETTINGS__REPORTER_NAME: return IIdePackage.SERVER_DESCRIPTOR__REPORTER_NAME;
				case IModelPackage.USER_SETTINGS__REPORTER_EMAIL: return IIdePackage.SERVER_DESCRIPTOR__REPORTER_EMAIL;
				case IModelPackage.USER_SETTINGS__ANONYMIZE_MESSAGES: return IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES;
				case IModelPackage.USER_SETTINGS__ANONYMIZE_STACK_TRACES: return IIdePackage.SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES;
				case IModelPackage.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS: return IIdePackage.SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case IIdePackage.SERVER_DESCRIPTOR___GET_IMAGE16:
				return getImage16();
			case IIdePackage.SERVER_DESCRIPTOR___GET_IMAGE32:
				return getImage32();
			case IIdePackage.SERVER_DESCRIPTOR___IS_ACTIVE:
				return isActive();
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (reporterId: ");
		result.append(reporterId);
		result.append(", reporterName: ");
		result.append(reporterName);
		result.append(", reporterEmail: ");
		result.append(reporterEmail);
		result.append(", anonymizeMessages: ");
		result.append(anonymizeMessages);
		result.append(", anonymizeStackTraces: ");
		result.append(anonymizeStackTraces);
		result.append(", disableAutomaticWiringAnalysis: ");
		result.append(disableAutomaticWiringAnalysis);
		result.append(", id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(", description: ");
		result.append(description);
		result.append(", contributor: ");
		result.append(contributor);
		result.append(", clazz: ");
		result.append(clazz);
		result.append(", icon16: ");
		result.append(icon16);
		result.append(", icon32: ");
		result.append(icon32);
		result.append(", connection: ");
		result.append(connection);
		result.append(", configured: ");
		result.append(configured);
		result.append(", enabled: ");
		result.append(enabled);
		result.append(", configurationElement: ");
		result.append(configurationElement);
		result.append(')');
		return result.toString();
	}

} //ServerDescriptorImpl
