/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.Statuses;

public class RecentlySeenFilter
implements Predicate<IStatus> {
    private Cache<String, String> cache;

    public RecentlySeenFilter() {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(1L, TimeUnit.HOURS).initialCapacity(30).maximumSize(500L).build();
    }

    @VisibleForTesting
    public RecentlySeenFilter(long timoutInMillis) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(timoutInMillis, TimeUnit.MILLISECONDS).initialCapacity(30).maximumSize(500L).build();
    }

    public boolean apply(IStatus input) {
        if (SystemControl.isDebug()) {
            return true;
        }
        String fp = Statuses.newThrowableFingerprint(input.getException(), false, false);
        String val = (String)this.cache.getIfPresent((Object)fp);
        if (val == null) {
            this.cache.put((Object)fp, (Object)"");
        }
        return val == null;
    }
}

