/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.emf.facet.efacet.ui.internal.utils.ImageProvider;
import org.eclipse.emf.facet.efacet.ui.internal.widget.ETypedElementSelectionControlContentProvider;
import org.eclipse.emf.facet.efacet.ui.internal.widget.IETypedElementTabSelectionWidgetInternal;
import org.eclipse.emf.facet.util.core.internal.exported.IFilter;
import org.eclipse.emf.facet.util.emf.ui.internal.exported.IEmfLabelProviderFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETypedElementSelectionControl
implements IETypedElementTabSelectionWidgetInternal {
    public static final String TAB_ID = "flat.view.id";
    public static final String TITLE = Messages.ETypedElementSelectionControl_FlatView;
    private static final IStatus OK_STATUS = new Status(0, "org.eclipse.emf.facet.efacet.ui", "");
    private FilteredTree filteredTree;
    protected Collection<? extends ETypedElement> available;
    private final int selectionMaxSize;
    private final boolean allowEmpty;
    private Button rbNoSelection;
    private Button rbSelection;
    private IStatus validationStatus;
    private final IBaseLabelProvider labelProvider;
    private final Composite cParent;
    private final Collection<? extends EObject> knownEPackage;

    public ETypedElementSelectionControl(Composite parentComposite, int selectionMaxSize, boolean allowEmpty, Collection<? extends EObject> knownEPackage) {
        this.cParent = parentComposite;
        this.knownEPackage = knownEPackage;
        this.selectionMaxSize = selectionMaxSize;
        this.allowEmpty = allowEmpty;
        this.labelProvider = IEmfLabelProviderFactory.DEFAULT.createLabelProvider();
    }

    @Override
    public void createContents() {
        Composite composite = new Composite(this.cParent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.allowEmpty) {
            this.rbNoSelection = new Button(composite, 16);
            this.rbNoSelection.setText(Messages.ETypedElementSelectionDialog_radioButtonNoSelection);
            this.rbNoSelection.setSelection(true);
            this.rbNoSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    boolean selected = ETypedElementSelectionControl.this.getRadioButtonNoSelection().getSelection();
                    ETypedElementSelectionControl.this.setETypedElementSelectionEnabled(!selected);
                    if (selected) {
                        ETypedElementSelectionControl.this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
                    }
                }
            });
            this.rbSelection = new Button(composite, 16);
            if (this.selectionMaxSize > 1) {
                this.rbSelection.setText(Messages.ETypedElementSelectionDialog_radioButtonMultiSelection);
            } else {
                this.rbSelection.setText(Messages.ETypedElementSelectionDialog_radioButtonSingleSelection);
            }
            this.rbSelection.setSelection(false);
            this.rbSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    boolean selected = ETypedElementSelectionControl.this.getRadioButtonSelection().getSelection();
                    ETypedElementSelectionControl.this.setETypedElementSelectionEnabled(selected);
                    if (!selected) {
                        ETypedElementSelectionControl.this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
                    }
                }
            });
        }
        this.createFilteredTree(composite);
        this.filteredTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ETypedElementSelectionControl.this.updateValidationStatus();
            }
        });
        if (this.allowEmpty) {
            this.setETypedElementSelectionEnabled(false);
        }
        this.updateValidationStatus();
    }

    @Override
    public void addOpenListener(final IOpenListener openListener) {
        this.filteredTree.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (!ETypedElementSelectionControl.this.isErrorStatus()) {
                    openListener.open(event);
                }
            }
        });
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.filteredTree.getViewer().addSelectionChangedListener(listener);
    }

    private void createFilteredTree(Composite parentComposite) {
        this.filteredTree = new FilteredTree(parentComposite, ETypedElementSelectionControl.selectionStyle(this.selectionMaxSize) | 0x100 | 0x200 | 0x800, ETypedElementSelectionControl.createPatternFilter(), true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.filteredTree.getViewer());
        this.filteredTree.getViewer().setContentProvider(this.createContentProvider());
        this.filteredTree.getViewer().setLabelProvider(this.labelProvider);
        this.filteredTree.getViewer().setFilters(new ViewerFilter[]{this.filteredTree.getPatternFilter()});
        this.filteredTree.getViewer().setComparator(new ViewerComparator());
    }

    protected void updateValidationStatus() {
        if (this.filteredTree == null) {
            return;
        }
        Status errorElements = new Status(4, "org.eclipse.emf.facet.efacet.ui", Messages.ETypedElementSelectionControl_invalidSelectionETypedElementsOnly);
        new Status(4, "org.eclipse.emf.facet.efacet.ui", Messages.ETypedElementSelectionControl_invalidSelection);
        IStructuredSelection selection = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
        IStatus newStatus = OK_STATUS;
        if (!this.allowEmpty && selection.isEmpty()) {
            newStatus = new Status(4, "org.eclipse.emf.facet.efacet.ui", NLS.bind((String)Messages.ETypedElementSelectionControl_invalidSelectionAtLeastOneElement, (Object)this.selectionMaxSize));
        } else if (selection.size() > this.selectionMaxSize) {
            newStatus = new Status(4, "org.eclipse.emf.facet.efacet.ui", NLS.bind((String)Messages.ETypedElementSelectionControl_invalidSelectionAtMostXElements, (Object)this.selectionMaxSize));
        } else {
            for (Object selectedElement : selection) {
                if (selectedElement instanceof ETypedElement) continue;
                newStatus = errorElements;
                break;
            }
        }
        this.setValidationStatus(newStatus);
    }

    protected void setValidationStatus(IStatus status) {
        this.validationStatus = status;
    }

    @Override
    public IStatus getValidationStatus() {
        return this.validationStatus;
    }

    public boolean isErrorStatus() {
        return this.validationStatus == null || this.validationStatus.getSeverity() >= 4;
    }

    @Override
    public void setAvailableETypedElements(Collection<? extends ETypedElement> newAvailable) {
        this.available = newAvailable;
        HashSet<EObject> containers = new HashSet<EObject>();
        for (ETypedElement eTypedElement : newAvailable) {
            EObject container = ETypedElementSelectionControl.getTopmostContainer((EObject)eTypedElement);
            if (container == null || !this.containsETypedElement(container)) continue;
            containers.add(container);
        }
        for (EObject eObject : this.knownEPackage) {
            if (!this.containsETypedElement(eObject)) continue;
            containers.add(eObject);
        }
        this.setInput(containers);
    }

    protected static EObject getTopmostContainer(EObject eObject) {
        EObject container;
        EObject result = container = eObject.eContainer();
        while (container != null) {
            result = container;
            container = container.eContainer();
        }
        return result;
    }

    @Override
    public List<ETypedElement> getSelectedETypedElements() {
        ArrayList<ETypedElement> currentlySelected = new ArrayList<ETypedElement>();
        if (this.filteredTree.isDisposed()) {
            throw new IllegalStateException("Cannot get the selection since the viewer is disposed.");
        }
        IStructuredSelection selection = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
        for (Object element : selection) {
            if (!(element instanceof ETypedElement)) continue;
            ETypedElement eTypedElement = (ETypedElement)element;
            currentlySelected.add(eTypedElement);
        }
        return currentlySelected;
    }

    @Override
    public void setSelectedETypedElements(Collection<? extends ETypedElement> newSelection) {
        if (newSelection == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<? extends ETypedElement> filteredSelection = new ArrayList<ETypedElement>();
        filteredSelection.addAll(newSelection);
        filteredSelection.retainAll(this.available);
        this.setSelection((IStructuredSelection)new StructuredSelection(filteredSelection));
    }

    @Override
    public void setSelection(IStructuredSelection selection) {
        this.setETypedElementSelectionEnabled(!selection.isEmpty());
        this.filteredTree.getViewer().setSelection((ISelection)selection);
        this.updateValidationStatus();
    }

    protected void setETypedElementSelectionEnabled(boolean enabled) {
        this.getRadioButtonNoSelection().setSelection(!enabled);
        this.getRadioButtonSelection().setSelection(enabled);
        this.filteredTree.getViewer().getTree().setEnabled(enabled);
        this.filteredTree.getFilterControl().setEnabled(enabled);
    }

    public void setInput(Collection<? extends EObject> containers) {
        this.filteredTree.getViewer().setInput(containers);
    }

    public Collection<? extends EObject> getInput() {
        return (Collection)this.filteredTree.getViewer().getInput();
    }

    protected IContentProvider createContentProvider() {
        return new ETypedElementSelectionControlContentProvider(new IFilter<EObject>(){

            public boolean filter(EObject eObject) {
                return ETypedElementSelectionControl.this.filterChild(eObject);
            }
        });
    }

    protected boolean filterChild(EObject eObject) {
        boolean selected = this.containsETypedElement(eObject) ? true : (eObject instanceof ETypedElement ? this.isAvailable(eObject) : false);
        return selected;
    }

    protected boolean isAvailable(EObject eObject) {
        return this.available.contains(eObject);
    }

    protected boolean containsETypedElement(EObject eObject) {
        boolean result = false;
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EObject element = (EObject)eAllContents.next();
            if (element instanceof ETypedElement) {
                ETypedElement typedElement = (ETypedElement)element;
                if (!this.isAvailable((EObject)typedElement)) continue;
                result = true;
                break;
            }
            result = this.containsETypedElement(element);
            if (result) break;
        }
        return result;
    }

    private static int selectionStyle(int selectionMaxSize) {
        int selectionStyle = selectionMaxSize > 1 ? 2 : 4;
        return selectionStyle;
    }

    private static PatternFilter createPatternFilter() {
        return new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
                if (labelText == null) {
                    return false;
                }
                return this.wordMatches(labelText) || this.parentMatches(viewer, element);
            }

            private boolean parentMatches(Viewer viewer, Object element) {
                ITreeContentProvider contentProvider = (ITreeContentProvider)((StructuredViewer)viewer).getContentProvider();
                Object parent = contentProvider.getParent(element);
                if (parent == null) {
                    return false;
                }
                return this.isLeafMatch(viewer, parent);
            }
        };
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.filteredTree.getViewer().getSelection();
    }

    protected Button getRadioButtonNoSelection() {
        return this.rbNoSelection;
    }

    protected Button getRadioButtonSelection() {
        return this.rbSelection;
    }

    @Override
    public FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    @Override
    public boolean isDisposed() {
        return this.filteredTree.isDisposed();
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTipText() {
        return this.getTitle();
    }

    @Override
    public Image getImage() {
        return ImageProvider.getInstance().getFlatViewIcon();
    }

    @Override
    public String getTabId() {
        return TAB_ID;
    }

    public Collection<? extends EObject> getKnownEPackage() {
        return this.knownEPackage;
    }
}

