/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.core.op.FetchOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;

public abstract class GitFlowOperation
implements IEGitOperation {
    public static final String SEP = "/";
    protected GitFlowRepository repository;
    protected MergeResult mergeResult;

    public GitFlowOperation(GitFlowRepository repository) {
        this.repository = repository;
    }

    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule((Repository)this.repository.getRepository());
    }

    protected CreateLocalBranchOperation createBranchFromHead(String branchName, RevCommit sourceCommit) {
        return new CreateLocalBranchOperation(this.repository.getRepository(), branchName, sourceCommit);
    }

    protected void start(IProgressMonitor monitor, String branchName, RevCommit sourceCommit) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        CreateLocalBranchOperation branchOperation = this.createBranchFromHead(branchName, sourceCommit);
        branchOperation.execute((IProgressMonitor)progress.newChild(1));
        BranchOperation checkoutOperation = new BranchOperation(this.repository.getRepository(), branchName);
        checkoutOperation.execute((IProgressMonitor)progress.newChild(1));
    }

    protected void finish(IProgressMonitor monitor, String branchName, boolean squash, boolean keepBranch, boolean fastForwardSingleCommit) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            this.mergeResult = this.mergeTo((IProgressMonitor)progress.newChild(1), branchName, this.repository.getConfig().getDevelop(), squash, fastForwardSingleCommit);
            if (!this.mergeResult.getMergeStatus().isSuccessful()) {
                return;
            }
            Ref branch = this.repository.findBranch(branchName);
            if (branch == null) {
                throw new IllegalStateException(String.format(CoreText.GitFlowOperation_branchMissing, branchName));
            }
            boolean forceDelete = squash;
            if (!keepBranch) {
                new DeleteBranchOperation(this.repository.getRepository(), branch, forceDelete).execute((IProgressMonitor)progress.newChild(1));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void finish(IProgressMonitor monitor, String branchName) throws CoreException {
        this.finish(monitor, branchName, false, false, false);
    }

    @NonNull
    protected MergeResult mergeTo(IProgressMonitor monitor, String branchName, String targetBranchName, boolean squash, boolean fastForwardSingleCommit) throws CoreException {
        try {
            if (!this.repository.hasBranch(targetBranchName)) {
                throw new RuntimeException(String.format(CoreText.GitFlowOperation_branchNotFound, targetBranchName));
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            boolean dontCloseProjects = false;
            BranchOperation branchOperation = new BranchOperation(this.repository.getRepository(), targetBranchName, dontCloseProjects);
            branchOperation.execute((IProgressMonitor)progress.newChild(1));
            CheckoutResult.Status status = branchOperation.getResult().getStatus();
            if (!CheckoutResult.Status.OK.equals((Object)status)) {
                throw new CoreException(Activator.error(String.format(CoreText.GitFlowOperation_unableToCheckout, branchName, status.toString())));
            }
            MergeOperation mergeOperation = new MergeOperation(this.repository.getRepository(), branchName);
            mergeOperation.setSquash(squash);
            if (squash) {
                mergeOperation.setCommit(true);
            }
            if (!(squash || fastForwardSingleCommit && !this.hasMultipleCommits(branchName))) {
                mergeOperation.setFastForwardMode(MergeCommand.FastForwardMode.NO_FF);
            }
            mergeOperation.execute((IProgressMonitor)progress.newChild(1));
            MergeResult result = mergeOperation.getResult();
            if (result == null) {
                throw new CoreException(Activator.error(String.format(CoreText.GitFlowOperation_unableToMerge, branchName, targetBranchName)));
            }
            return result;
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasMultipleCommits(String branchName) throws IOException {
        return this.getAheadOfDevelopCount(branchName) > 1;
    }

    private int getAheadOfDevelopCount(String branchName) throws IOException {
        String parentBranch = this.repository.getConfig().getDevelop();
        Ref develop = this.repository.findBranch(parentBranch);
        Ref branch = this.repository.findBranch(branchName);
        RevWalk walk = new RevWalk(this.repository.getRepository());
        RevCommit branchCommit = walk.parseCommit((AnyObjectId)branch.getObjectId());
        RevCommit developCommit = walk.parseCommit((AnyObjectId)develop.getObjectId());
        RevCommit mergeBase = this.findCommonBase(walk, branchCommit, developCommit);
        walk.reset();
        walk.setRevFilter(RevFilter.ALL);
        int aheadCount = RevWalkUtils.count((RevWalk)walk, (RevCommit)branchCommit, (RevCommit)mergeBase);
        return aheadCount;
    }

    private RevCommit findCommonBase(RevWalk walk, RevCommit branchCommit, RevCommit developCommit) throws IOException {
        walk.setRevFilter(RevFilter.MERGE_BASE);
        walk.markStart(branchCommit);
        walk.markStart(developCommit);
        return walk.next();
    }

    protected MergeResult mergeTo(IProgressMonitor monitor, String branchName, String targetBranchName) throws CoreException {
        return this.mergeTo(monitor, branchName, targetBranchName, false, false);
    }

    protected FetchResult fetch(IProgressMonitor monitor, int timeout) throws URISyntaxException, InvocationTargetException {
        RemoteConfig config = this.repository.getConfig().getDefaultRemoteConfig();
        FetchOperation fetchOperation = new FetchOperation(this.repository.getRepository(), config, timeout, false);
        fetchOperation.run(monitor);
        return fetchOperation.getOperationResult();
    }

    @Deprecated
    protected FetchResult fetch(IProgressMonitor monitor) throws URISyntaxException, InvocationTargetException {
        return this.fetch(monitor, 0);
    }

    public MergeResult getMergeResult() {
        return this.mergeResult;
    }
}

