/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.EMFDocumentResourceMediator;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class TreeViewerEx
extends TreeViewer {
    private ArrayList<String> elementsIds;
    private ArrayList<String> selectedIds;

    public TreeViewerEx(Composite parent, int style, EMFDocumentResourceMediator emfDocumentProvider, final IModelResource modelProvider) {
        super(parent, style);
        emfDocumentProvider.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                try {
                    E4XMIResource xmiResource = (E4XMIResource)((EObject)modelProvider.getRoot().get(0)).eResource();
                    ArrayList<EObject> newElements = new ArrayList<EObject>();
                    ObservableListTreeContentProvider provider = (ObservableListTreeContentProvider)TreeViewerEx.this.getContentProvider();
                    Object[] children = new Object[]{modelProvider.getRoot().get(0)};
                    for (String id : TreeViewerEx.this.elementsIds) {
                        EObject eObject = xmiResource.getEObject(id);
                        if (eObject == null) continue;
                        newElements.add(eObject);
                        TreeViewerEx.getFirstMatchingItem(eObject, provider, children);
                    }
                    ArrayList<EObject> newSelected = new ArrayList<EObject>();
                    for (String id : TreeViewerEx.this.selectedIds) {
                        EObject eObject = xmiResource.getEObject(id);
                        if (eObject == null) continue;
                        newSelected.add(eObject);
                        TreeViewerEx.getFirstMatchingItem(eObject, provider, children);
                    }
                    TreeViewerEx.this.setExpandedElements(newElements.toArray(new Object[0]));
                    TreeViewerEx.this.setSelection((ISelection)new StructuredSelection(newSelected));
                    this.reloadIds(modelProvider);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
                this.reloadIds(modelProvider);
            }

            private void reloadIds(IModelResource modelProvider2) {
                try {
                    Object[] elements = TreeViewerEx.this.getExpandedElements();
                    List selected = ((IStructuredSelection)TreeViewerEx.this.getSelection()).toList();
                    E4XMIResource xmiResource = (E4XMIResource)((EObject)modelProvider2.getRoot().get(0)).eResource();
                    TreeViewerEx.this.elementsIds = new ArrayList();
                    TreeViewerEx.this.selectedIds = new ArrayList();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof EObject) {
                            TreeViewerEx.this.elementsIds.add(xmiResource.getID((EObject)obj));
                        }
                        ++n2;
                    }
                    for (Object obj : selected) {
                        if (!(obj instanceof EObject)) continue;
                        TreeViewerEx.this.selectedIds.add(xmiResource.getID((EObject)obj));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Object getFirstMatchingItem(EObject target, ObservableListTreeContentProvider provider, Object[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i] == target) {
                return items[i];
            }
            Object found = TreeViewerEx.getFirstMatchingItem(target, provider, provider.getChildren(items[i]));
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }
}

