/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugTarget;
import org.eclipse.datatools.sqltools.debugger.model.SPStackFrame;
import org.eclipse.datatools.sqltools.debugger.model.SPThread;
import org.eclipse.datatools.sqltools.routineeditor.util.RoutineEditorConstants;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;

public class SPDebugModelUtil {
    public static String getModelIdentifier() {
        return String.valueOf(DebuggerCorePlugin.PLUGIN_ID) + ".debugModelPresentation";
    }

    public static SPLineBreakpoint createLineBreakpoint(ProcIdentifier procid, int lineNumber, boolean register) throws CoreException {
        SPLineBreakpoint bp = new SPLineBreakpoint(procid, lineNumber, true);
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)bp);
        }
        return bp;
    }

    public static SPLineBreakpoint findLineBreakpoint(ProcIdentifier procid, int lineNumber) {
        String modelId = SPDebugModelUtil.getModelIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            SPLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof SPLineBreakpoint && (marker = (breakpoint = (SPLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists()) {
                try {
                    ProcIdentifier pi = breakpoint.getProcIdentifier();
                    if (procid.equals(pi) && breakpoint.getLineNumber() == lineNumber) {
                        return breakpoint;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    public static List findAllLineBreakpoint(ProcIdentifier procid, int lineNumber) {
        ArrayList<SPLineBreakpoint> ret = new ArrayList<SPLineBreakpoint>();
        String modelId = SPDebugModelUtil.getModelIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            SPLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof SPLineBreakpoint && (marker = (breakpoint = (SPLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists()) {
                try {
                    ProcIdentifier pi = breakpoint.getProcIdentifier();
                    if (procid.equals(pi) && breakpoint.getLineNumber() == lineNumber) {
                        ret.add(breakpoint);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return ret;
    }

    public static boolean isSPBreakpointMarker(IMarker marker, ProcIdentifier proc) {
        try {
            String type = marker.getType();
            if (SPLineBreakpoint.MARKER_TYPE.equals(type)) {
                String str = marker.getAttribute(RoutineEditorConstants.ATTR_PROCIDENTIFIER, "");
                try {
                    ProcIdentifier id = ProcIdentifierImpl.decode((String)str);
                    return proc.equals(id);
                }
                catch (ParseException ex) {
                    DebuggerCorePlugin.getDefault().log(ex);
                    return false;
                }
            }
            return false;
        }
        catch (CoreException ex) {
            DebuggerCorePlugin.getDefault().log(ex);
            return false;
        }
    }

    public static boolean isSPBreakpointMarkerDelta(IMarkerDelta markerDelta, ProcIdentifier identifier) {
        String type = markerDelta.getType();
        if (SPLineBreakpoint.MARKER_TYPE.equals(type)) {
            String str = markerDelta.getAttribute(RoutineEditorConstants.ATTR_PROCIDENTIFIER, "");
            try {
                ProcIdentifier id = ProcIdentifierImpl.decode((String)str);
                return identifier.equals(id);
            }
            catch (ParseException ex) {
                DebuggerCorePlugin.getDefault().log(ex);
                return false;
            }
        }
        return false;
    }

    public static boolean supportCondition(SPLineBreakpoint bp) throws CoreException {
        DatabaseDefinition dbDef = ProfileUtil.getDatabaseDefinition((String)bp.getProcIdentifier().getDatabaseIdentifier().getProfileName());
        if (dbDef != null) {
            return dbDef.getDebuggerDefinition() != null && dbDef.getDebuggerDefinition().isConditionSupported();
        }
        return false;
    }

    public static List findAllSPLineBreakpointForSP(ProcIdentifier procid) {
        ArrayList<SPLineBreakpoint> ret = new ArrayList<SPLineBreakpoint>();
        String modelId = SPDebugModelUtil.getModelIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof SPLineBreakpoint) {
                SPLineBreakpoint breakpoint = (SPLineBreakpoint)breakpoints[i];
                try {
                    ProcIdentifier pi = breakpoint.getProcIdentifier();
                    if (procid.equals(pi)) {
                        ret.add(breakpoint);
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return ret;
    }

    public static void removeAllBreakpointForSP(ProcIdentifier procid) {
        List list = SPDebugModelUtil.findAllSPLineBreakpointForSP(procid);
        int i = 0;
        int size = list.size();
        while (i < size) {
            IBreakpoint bp = (IBreakpoint)list.get(i);
            try {
                bp.delete();
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public static void changeAllBreakpointForSP(ProcIdentifier procid, ProcIdentifier newprocid) {
        DebugPlugin.getDefault().getBreakpointManager();
        List list = SPDebugModelUtil.findAllSPLineBreakpointForSP(procid);
        int i = 0;
        int size = list.size();
        while (i < size) {
            SPLineBreakpoint bp = (SPLineBreakpoint)list.get(i);
            try {
                bp.setProcId(newprocid.encode());
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProcInDebugging(ProcIdentifier procid) {
        if (procid == null) {
            return false;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        IDebugTarget[] targets = manager.getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            SPThread thread;
            if (targets[i] instanceof SPDebugTarget && (thread = ((SPDebugTarget)targets[i]).getSPThread()) != null) {
                try {
                    IStackFrame[] frames = thread.getStackFrames();
                    int j = 0;
                    while (j < frames.length) {
                        ProcIdentifier debugProc;
                        if (frames[j] instanceof SPStackFrame && procid.equalsByServer((Object)(debugProc = ((SPStackFrame)frames[j]).getProcIdentifier()))) {
                            return true;
                        }
                        ++j;
                    }
                }
                catch (DebugException debugException) {}
            }
            ++i;
        }
        return false;
    }

    public static String[] hasProcInDebugging(String connectionProfileName) {
        if (connectionProfileName == null || connectionProfileName.trim().length() < 1) {
            return null;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        IDebugTarget[] targets = manager.getDebugTargets();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < targets.length) {
            SPThread thread;
            if (targets[i] instanceof SPDebugTarget && (thread = ((SPDebugTarget)targets[i]).getSPThread()) != null) {
                try {
                    IStackFrame[] frames = thread.getStackFrames();
                    int j = 0;
                    while (j < frames.length) {
                        ProcIdentifier debugProc;
                        if (frames[j] instanceof SPStackFrame && connectionProfileName.equals((debugProc = ((SPStackFrame)frames[j]).getProcIdentifier()).getDatabaseIdentifier().getProfileName())) {
                            names.add(debugProc.getProcName());
                        }
                        ++j;
                    }
                }
                catch (DebugException debugException) {}
            }
            ++i;
        }
        if (names.size() > 0) {
            return names.toArray(new String[names.size()]);
        }
        return null;
    }

    public static void changeProfileName(String oldName, String newName) {
        if (oldName == null || newName == null || oldName.equals(newName)) {
            return;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        IDebugTarget[] targets = manager.getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            SPThread thread;
            if (targets[i] instanceof SPDebugTarget && (thread = ((SPDebugTarget)targets[i]).getSPThread()) != null) {
                try {
                    IStackFrame[] frames = thread.getStackFrames();
                    int j = 0;
                    while (j < frames.length) {
                        ProcIdentifier debugProc;
                        DatabaseIdentifier databaseIdentifier;
                        if (frames[j] instanceof SPStackFrame && oldName.equals((databaseIdentifier = (debugProc = ((SPStackFrame)frames[j]).getProcIdentifier()).getDatabaseIdentifier()).getProfileName())) {
                            databaseIdentifier.setProfileName(newName);
                        }
                        ++j;
                    }
                }
                catch (DebugException debugException) {}
            }
            ++i;
        }
    }
}

