/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.model.impl;

import java.util.Collection;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.BufferPoolType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPool;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPoolSizeException;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabasePartition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionGroup;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PageSizeType;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLObjectImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class LUWBufferPoolImpl
extends SQLObjectImpl
implements LUWBufferPool {
    protected static final BufferPoolType CREATE_TYPE_EDEFAULT = BufferPoolType.IMMEDIATE_LITERAL;
    protected BufferPoolType createType = CREATE_TYPE_EDEFAULT;
    protected static final int SIZE_EDEFAULT = 0;
    protected int size = 0;
    protected static final PageSizeType PAGE_SIZE_EDEFAULT = PageSizeType.FOUR_K_LITERAL;
    protected PageSizeType pageSize = PAGE_SIZE_EDEFAULT;
    protected static final int BLOCK_SIZE_EDEFAULT = 32;
    protected int blockSize = 32;
    protected static final int NUM_BLOCK_PAGES_EDEFAULT = 0;
    protected int numBlockPages = 0;
    protected static final boolean EXTENDED_STORAGE_EDEFAULT = false;
    protected boolean extendedStorage = false;
    protected static final boolean AUTOMATIC_EDEFAULT = true;
    protected boolean automatic = true;
    protected EList tableSpaces;
    protected EList partitions;
    protected EList partitionGroup;
    protected LUWDatabase database;
    protected EList sizeException;

    protected LUWBufferPoolImpl() {
    }

    protected EClass eStaticClass() {
        return LUWPackage.Literals.LUW_BUFFER_POOL;
    }

    @Override
    public BufferPoolType getCreateType() {
        return this.createType;
    }

    @Override
    public void setCreateType(BufferPoolType newCreateType) {
        BufferPoolType oldCreateType = this.createType;
        BufferPoolType bufferPoolType = this.createType = newCreateType == null ? CREATE_TYPE_EDEFAULT : newCreateType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldCreateType, (Object)this.createType));
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int newSize) {
        int oldSize = this.size;
        this.size = newSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldSize, this.size));
        }
    }

    @Override
    public PageSizeType getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(PageSizeType newPageSize) {
        PageSizeType oldPageSize = this.pageSize;
        PageSizeType pageSizeType = this.pageSize = newPageSize == null ? PAGE_SIZE_EDEFAULT : newPageSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldPageSize, (Object)this.pageSize));
        }
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void setBlockSize(int newBlockSize) {
        int oldBlockSize = this.blockSize;
        this.blockSize = newBlockSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldBlockSize, this.blockSize));
        }
    }

    @Override
    public int getNumBlockPages() {
        return this.numBlockPages;
    }

    @Override
    public void setNumBlockPages(int newNumBlockPages) {
        int oldNumBlockPages = this.numBlockPages;
        this.numBlockPages = newNumBlockPages;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldNumBlockPages, this.numBlockPages));
        }
    }

    @Override
    public boolean isExtendedStorage() {
        return this.extendedStorage;
    }

    @Override
    public void setExtendedStorage(boolean newExtendedStorage) {
        boolean oldExtendedStorage = this.extendedStorage;
        this.extendedStorage = newExtendedStorage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldExtendedStorage, this.extendedStorage));
        }
    }

    @Override
    public boolean isAutomatic() {
        return this.automatic;
    }

    @Override
    public void setAutomatic(boolean newAutomatic) {
        boolean oldAutomatic = this.automatic;
        this.automatic = newAutomatic;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldAutomatic, this.automatic));
        }
    }

    @Override
    public EList getTableSpaces() {
        if (this.tableSpaces == null) {
            this.tableSpaces = new EObjectWithInverseResolvingEList(LUWTableSpace.class, (InternalEObject)this, 15, 41);
        }
        return this.tableSpaces;
    }

    @Override
    public EList getPartitions() {
        if (this.partitions == null) {
            this.partitions = new EObjectWithInverseResolvingEList(LUWDatabasePartition.class, (InternalEObject)this, 16, 14);
        }
        return this.partitions;
    }

    @Override
    public EList getPartitionGroup() {
        if (this.partitionGroup == null) {
            this.partitionGroup = new EObjectWithInverseResolvingEList.ManyInverse(LUWPartitionGroup.class, (InternalEObject)this, 17, 11);
        }
        return this.partitionGroup;
    }

    @Override
    public LUWDatabase getDatabase() {
        if (this.database != null && this.database.eIsProxy()) {
            InternalEObject oldDatabase = (InternalEObject)this.database;
            this.database = (LUWDatabase)this.eResolveProxy(oldDatabase);
            if (this.database != oldDatabase && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 18, (Object)oldDatabase, (Object)this.database));
            }
        }
        return this.database;
    }

    public LUWDatabase basicGetDatabase() {
        return this.database;
    }

    public NotificationChain basicSetDatabase(LUWDatabase newDatabase, NotificationChain msgs) {
        LUWDatabase oldDatabase = this.database;
        this.database = newDatabase;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldDatabase, (Object)newDatabase);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setDatabase(LUWDatabase newDatabase) {
        if (newDatabase != this.database) {
            NotificationChain msgs = null;
            if (this.database != null) {
                msgs = ((InternalEObject)this.database).eInverseRemove((InternalEObject)this, 23, LUWDatabase.class, msgs);
            }
            if (newDatabase != null) {
                msgs = ((InternalEObject)newDatabase).eInverseAdd((InternalEObject)this, 23, LUWDatabase.class, msgs);
            }
            if ((msgs = this.basicSetDatabase(newDatabase, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)newDatabase, (Object)newDatabase));
        }
    }

    @Override
    public EList getSizeException() {
        if (this.sizeException == null) {
            this.sizeException = new EObjectContainmentWithInverseEList(LUWBufferPoolSizeException.class, (InternalEObject)this, 19, 9);
        }
        return this.sizeException;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 15: {
                return ((InternalEList)this.getTableSpaces()).basicAdd((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getPartitions()).basicAdd((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getPartitionGroup()).basicAdd((Object)otherEnd, msgs);
            }
            case 18: {
                if (this.database != null) {
                    msgs = ((InternalEObject)this.database).eInverseRemove((InternalEObject)this, 23, LUWDatabase.class, msgs);
                }
                return this.basicSetDatabase((LUWDatabase)otherEnd, msgs);
            }
            case 19: {
                return ((InternalEList)this.getSizeException()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 15: {
                return ((InternalEList)this.getTableSpaces()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getPartitions()).basicRemove((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getPartitionGroup()).basicRemove((Object)otherEnd, msgs);
            }
            case 18: {
                return this.basicSetDatabase(null, msgs);
            }
            case 19: {
                return ((InternalEList)this.getSizeException()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getCreateType();
            }
            case 9: {
                return new Integer(this.getSize());
            }
            case 10: {
                return this.getPageSize();
            }
            case 11: {
                return new Integer(this.getBlockSize());
            }
            case 12: {
                return new Integer(this.getNumBlockPages());
            }
            case 13: {
                return this.isExtendedStorage() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.isAutomatic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 15: {
                return this.getTableSpaces();
            }
            case 16: {
                return this.getPartitions();
            }
            case 17: {
                return this.getPartitionGroup();
            }
            case 18: {
                if (resolve) {
                    return this.getDatabase();
                }
                return this.basicGetDatabase();
            }
            case 19: {
                return this.getSizeException();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setCreateType((BufferPoolType)((Object)newValue));
                return;
            }
            case 9: {
                this.setSize((Integer)newValue);
                return;
            }
            case 10: {
                this.setPageSize((PageSizeType)((Object)newValue));
                return;
            }
            case 11: {
                this.setBlockSize((Integer)newValue);
                return;
            }
            case 12: {
                this.setNumBlockPages((Integer)newValue);
                return;
            }
            case 13: {
                this.setExtendedStorage((Boolean)newValue);
                return;
            }
            case 14: {
                this.setAutomatic((Boolean)newValue);
                return;
            }
            case 15: {
                this.getTableSpaces().clear();
                this.getTableSpaces().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getPartitions().clear();
                this.getPartitions().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getPartitionGroup().clear();
                this.getPartitionGroup().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setDatabase((LUWDatabase)newValue);
                return;
            }
            case 19: {
                this.getSizeException().clear();
                this.getSizeException().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setCreateType(CREATE_TYPE_EDEFAULT);
                return;
            }
            case 9: {
                this.setSize(0);
                return;
            }
            case 10: {
                this.setPageSize(PAGE_SIZE_EDEFAULT);
                return;
            }
            case 11: {
                this.setBlockSize(32);
                return;
            }
            case 12: {
                this.setNumBlockPages(0);
                return;
            }
            case 13: {
                this.setExtendedStorage(false);
                return;
            }
            case 14: {
                this.setAutomatic(true);
                return;
            }
            case 15: {
                this.getTableSpaces().clear();
                return;
            }
            case 16: {
                this.getPartitions().clear();
                return;
            }
            case 17: {
                this.getPartitionGroup().clear();
                return;
            }
            case 18: {
                this.setDatabase(null);
                return;
            }
            case 19: {
                this.getSizeException().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.createType != CREATE_TYPE_EDEFAULT;
            }
            case 9: {
                return this.size != 0;
            }
            case 10: {
                return this.pageSize != PAGE_SIZE_EDEFAULT;
            }
            case 11: {
                return this.blockSize != 32;
            }
            case 12: {
                return this.numBlockPages != 0;
            }
            case 13: {
                return this.extendedStorage;
            }
            case 14: {
                return !this.automatic;
            }
            case 15: {
                return this.tableSpaces != null && !this.tableSpaces.isEmpty();
            }
            case 16: {
                return this.partitions != null && !this.partitions.isEmpty();
            }
            case 17: {
                return this.partitionGroup != null && !this.partitionGroup.isEmpty();
            }
            case 18: {
                return this.database != null;
            }
            case 19: {
                return this.sizeException != null && !this.sizeException.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (createType: ");
        result.append((Object)this.createType);
        result.append(", size: ");
        result.append(this.size);
        result.append(", pageSize: ");
        result.append((Object)this.pageSize);
        result.append(", blockSize: ");
        result.append(this.blockSize);
        result.append(", numBlockPages: ");
        result.append(this.numBlockPages);
        result.append(", extendedStorage: ");
        result.append(this.extendedStorage);
        result.append(", automatic: ");
        result.append(this.automatic);
        result.append(')');
        return result.toString();
    }
}

