/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.services.IPeService;

public class GraphicsUtil {
    static final IGaService gaService = Graphiti.getGaService();
    static final IPeService peService = Graphiti.getPeService();
    public static boolean debug = false;

    public static void setLocationRelativeToDiagram(PictogramElement pe, int x, int y) {
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        EObject o = pe.eContainer();
        if (o instanceof ContainerShape && !(o instanceof Diagram)) {
            ILocation containerLoc = peService.getLocationRelativeToDiagram((Shape)o);
            x -= containerLoc.getX();
            y -= containerLoc.getY();
        }
        gaService.setLocation(ga, x, y);
    }

    public static boolean contains(Shape parent, Shape child) {
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)child);
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(child);
        return GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX(), loc.getY())) && GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX() + size.getWidth(), loc.getY())) && GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX() + size.getWidth(), loc.getY() + size.getHeight())) && GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX(), loc.getY() + size.getHeight()));
    }

    public static boolean contains(Shape shape, Point point) {
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)shape);
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(shape);
        int x = point.getX();
        int y = point.getY();
        return x > loc.getX() && x < loc.getX() + size.getWidth() && y > loc.getY() && y < loc.getY() + size.getHeight();
    }

    public static boolean intersects(Shape shape1, Shape shape2) {
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation loc2 = layoutService.getLocationRelativeToDiagram(shape2);
        int x2 = loc2.getX();
        int y2 = loc2.getY();
        int w2 = ShapeDecoratorUtil.getShapeWidth(shape2);
        int h2 = ShapeDecoratorUtil.getShapeHeight(shape2);
        return GraphicsUtil.intersects(shape1, x2, y2, w2, h2);
    }

    public static boolean intersects(Shape shape1, Shape shape2, int space) {
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation loc2 = layoutService.getLocationRelativeToDiagram(shape2);
        int x2 = loc2.getX() - space;
        int y2 = loc2.getY() - space;
        int w2 = ShapeDecoratorUtil.getShapeWidth(shape2) + 2 * space;
        int h2 = ShapeDecoratorUtil.getShapeHeight(shape2) + 2 * space;
        return GraphicsUtil.intersects(shape1, x2, y2, w2, h2);
    }

    public static boolean intersects(Shape shape1, int x2, int y2, int w2, int h2) {
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation loc1 = layoutService.getLocationRelativeToDiagram(shape1);
        int x1 = loc1.getX();
        int y1 = loc1.getY();
        int w1 = ShapeDecoratorUtil.getShapeWidth(shape1);
        int h1 = ShapeDecoratorUtil.getShapeHeight(shape1);
        return GraphicsUtil.intersects(x1, y1, w1, h1, x2, y2, w2, h2);
    }

    public static boolean intersects(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        if (x2 <= x1 || y1 <= y2) {
            int t1 = x1;
            x1 = x2;
            x2 = t1;
            int t2 = y1;
            y1 = y2;
            y2 = t2;
            int t3 = w1;
            w1 = w2;
            w2 = t3;
            int t4 = h1;
            h1 = h2;
            h2 = t4;
        }
        return y2 + h2 >= y1 && y1 + h1 >= y2 && x2 + w2 >= x1 && x1 + w1 >= x2;
    }

    public static boolean intersects(Shape shape, Connection connection) {
        Point p1 = GraphicsUtil.createPoint(connection.getStart());
        Point p3 = GraphicsUtil.createPoint(connection.getEnd());
        if (connection instanceof FreeFormConnection) {
            FreeFormConnection ffc = (FreeFormConnection)connection;
            Point p2 = p1;
            for (Point p : ffc.getBendpoints()) {
                if (GraphicsUtil.intersectsLine(shape, p1, p)) {
                    return true;
                }
                p2 = p1 = p;
            }
            if (GraphicsUtil.intersectsLine(shape, p2, p3)) {
                return true;
            }
        } else if (GraphicsUtil.intersectsLine(shape, p1, p3)) {
            return true;
        }
        return false;
    }

    public static boolean intersectsLine(Shape shape, Point p1, Point p2) {
        ILocation loc = peService.getLocationRelativeToDiagram(shape);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)shape);
        if (size.getWidth() > 2) {
            loc.setX(loc.getX() + 1);
            size.setWidth(size.getWidth() - 2);
        }
        if (size.getHeight() > 2) {
            loc.setY(loc.getY() + 1);
            size.setHeight(size.getHeight() - 2);
        }
        return RectangleIntersectsLine.intersectsLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
    }

    public static boolean intersects(Point p1Start, Point p1End, Point p2Start, Point p2End) {
        return GraphicsUtil.isLineIntersectingLine(p1Start.getX(), p1Start.getY(), p1End.getX(), p1End.getY(), p2Start.getX(), p2Start.getY(), p2End.getX(), p2End.getY());
    }

    public static boolean isLineIntersectingLine(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3) {
        int s1 = GraphicsUtil.sameSide(x0, y0, x1, y1, x2, y2, x3, y3);
        int s2 = GraphicsUtil.sameSide(x2, y2, x3, y3, x0, y0, x1, y1);
        return s1 <= 0 && s2 <= 0;
    }

    static int sameSide(int x0, int y0, int x1, int y1, int px0, int py0, int px1, int py1) {
        int sameSide = 0;
        int dx = x1 - x0;
        int dy = y1 - y0;
        int dx1 = px0 - x0;
        int dy1 = py0 - y0;
        int dx2 = px1 - x1;
        int dy2 = py1 - y1;
        int c1 = dx * dy1 - dy * dx1;
        int c2 = dx * dy2 - dy * dx2;
        if (c1 != 0 && c2 != 0) {
            sameSide = c1 < 0 != c2 < 0 ? -1 : 1;
        } else if (dx == 0 && dx1 == 0 && dx2 == 0) {
            sameSide = !GraphicsUtil.isBetween(y0, y1, py0) && !GraphicsUtil.isBetween(y0, y1, py1) ? 1 : 0;
        } else if (dy == 0 && dy1 == 0 && dy2 == 0) {
            sameSide = !GraphicsUtil.isBetween(x0, x1, px0) && !GraphicsUtil.isBetween(x0, x1, px1) ? 1 : 0;
        }
        return sameSide;
    }

    static boolean isBetween(int a, int b, int c) {
        return b > a ? c >= a && c <= b : c >= b && c <= a;
    }

    public static Color clone(Color c) {
        return c;
    }

    public static boolean pointsEqual(Point p1, Point p2) {
        return p1.getX() == p2.getX() && p1.getY() == p2.getY();
    }

    public static Point createPoint(Point p) {
        return gaService.createPoint(p.getX(), p.getY());
    }

    public static Point createPoint(int x, int y) {
        return gaService.createPoint(x, y);
    }

    public static Point createPoint(Anchor a) {
        return GraphicsUtil.createPoint(peService.getLocationRelativeToDiagram(a));
    }

    public static Point createPoint(AnchorContainer ac) {
        if (ac instanceof Shape) {
            return GraphicsUtil.createPoint(peService.getLocationRelativeToDiagram((Shape)ac));
        }
        if (ac instanceof Connection) {
            return GraphicsUtil.createPoint(Graphiti.getPeService().getConnectionMidpoint((Connection)ac, 0.5));
        }
        return null;
    }

    public static Point getShapeCenter(AnchorContainer shape) {
        Point p = GraphicsUtil.createPoint(shape);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)shape);
        p.setX(p.getX() + size.getWidth() / 2);
        p.setY(p.getY() + size.getHeight() / 2);
        return p;
    }

    public static Point createPoint(ILocation loc) {
        return GraphicsUtil.createPoint(loc.getX(), loc.getY());
    }

    public static Point getMidpoint(Point p1, Point p2) {
        int dx = p2.getX() - p1.getX();
        int dy = p2.getY() - p1.getY();
        int x = p1.getX() + dx / 2;
        int y = p1.getY() + dy / 2;
        return GraphicsUtil.createPoint(x, y);
    }

    public static double getLength(ILocation start, ILocation end) {
        double a = start.getX() - end.getX();
        double b = start.getY() - end.getY();
        return Math.sqrt(a * a + b * b);
    }

    public static double getLength(List<Point> points) {
        double length = 0.0;
        int size = points.size();
        if (size >= 2) {
            Point p1 = points.get(0);
            int i = 1;
            while (i < size - 1) {
                Point p2 = points.get(i);
                length += GraphicsUtil.getLength(p1, p2);
                p1 = p2;
                ++i;
            }
        }
        return length;
    }

    public static double getLength(Point p1, Point p2) {
        double a = p1.getX() - p2.getX();
        double b = p1.getY() - p2.getY();
        return Math.sqrt(a * a + b * b);
    }

    public static final boolean isVertical(Point p1, Point p2) {
        return Math.abs(p1.getX() - p2.getX()) == 0;
    }

    public static final boolean isHorizontal(Point p1, Point p2) {
        return Math.abs(p1.getY() - p2.getY()) == 0;
    }

    public static final boolean isSlanted(Point p1, Point p2) {
        return !GraphicsUtil.isHorizontal(p1, p2) && !GraphicsUtil.isVertical(p1, p2);
    }

    public static Point getVertMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getY() - start.getY()));
        m.setY(start.getY() + d);
        return m;
    }

    public static Point getHorzMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getX() - start.getX()));
        m.setX(start.getX() + d);
        return m;
    }

    public static IDimension calculateSize(PictogramElement shape) {
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        if (ga != null) {
            return gaService.calculateSize(ga);
        }
        IDimension dim = null;
        if (shape instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)shape;
            for (Shape s : cs.getChildren()) {
                ga = s.getGraphicsAlgorithm();
                if (ga == null) continue;
                IDimension d = gaService.calculateSize(ga);
                if (dim == null) {
                    dim = d;
                    continue;
                }
                if (d.getWidth() > dim.getWidth()) {
                    dim.setWidth(d.getWidth());
                }
                if (d.getHeight() <= dim.getHeight()) continue;
                dim.setHeight(d.getHeight());
            }
        }
        return dim;
    }

    public static void dump(String label, List<? extends Shape> shapes) {
        if (shapes != null && debug) {
            System.out.println(label);
            for (Shape shape : shapes) {
                GraphicsUtil.dump(1, "", shape, 0, 0);
            }
            System.out.println("");
        }
    }

    public static void dump(String label, Anchor anchor) {
        if (debug) {
            System.out.print(String.valueOf(label) + " ");
            ILocation loc = peService.getLocationRelativeToDiagram(anchor);
            System.out.print(" at " + loc.getX() + ", " + loc.getY());
            GraphicsUtil.dump(" parent=", (ContainerShape)anchor.getParent());
        }
    }

    public static void dump(String label, ContainerShape shape) {
        ILocation loc = peService.getLocationRelativeToDiagram((Shape)shape);
        GraphicsUtil.dump(0, label, (Shape)shape, loc.getX(), loc.getY());
    }

    public static void dump(String label, Connection c) {
        if (debug) {
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c);
            if (be == null) {
                System.out.print(String.valueOf(label) + " connection=");
            } else {
                System.out.print(String.valueOf(label) + be.eClass().getName() + "=");
            }
            AnchorContainer source = c.getStart().getParent();
            AnchorContainer target = c.getEnd().getParent();
            String sourceName = GraphicsUtil.getDebugText((PictogramElement)source);
            String targetName = GraphicsUtil.getDebugText((PictogramElement)target);
            System.out.println(String.valueOf(sourceName) + " -> " + targetName);
        }
    }

    public static void dump(int level, String label, ContainerShape shape) {
        ILocation loc = peService.getLocationRelativeToDiagram((Shape)shape);
        GraphicsUtil.dump(level, label, (Shape)shape, loc.getX(), loc.getY());
    }

    public static void dump(Shape shape) {
        ILocation loc = peService.getLocationRelativeToDiagram(shape);
        String label = "";
        if (FeatureSupport.isLabelShape((PictogramElement)shape) && shape.getGraphicsAlgorithm() instanceof AbstractText) {
            AbstractText text = (AbstractText)shape.getGraphicsAlgorithm();
            label = "Label: " + text.getValue();
        }
        GraphicsUtil.dump(0, label, shape, loc.getX(), loc.getY());
    }

    public static void dump(int level, String label, Shape shape, int x, int y) {
        if (debug) {
            String text = GraphicsUtil.getDebugText((PictogramElement)shape);
            int i = 0;
            while (i < level) {
                System.out.print("    ");
                ++i;
            }
            System.out.print(String.valueOf(label) + " " + text);
            if (x > 0 || y > 0) {
                System.out.println(" at " + x + ", " + y);
            } else {
                System.out.println("");
            }
        }
    }

    public static String getDebugText(PictogramElement pe) {
        EObject be = BusinessObjectUtil.getBusinessObjectForPictogramElement(pe);
        String id = "";
        String text = "";
        if (be instanceof BaseElement) {
            id = " " + ((BaseElement)be).getId();
        }
        text = be != null ? String.valueOf(be.eClass().getName()) + id + ": " + ExtendedPropertiesProvider.getTextValue(be) : String.valueOf(id) + pe.toString();
        return text;
    }

    public static void dump(String label) {
        if (debug) {
            System.out.println(label);
        }
    }

    public static LineSegment[] getEdges(Shape shape) {
        ILocation loc = peService.getLocationRelativeToDiagram(shape);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)shape);
        LineSegment top = new LineSegment(loc.getX(), loc.getY(), loc.getX() + size.getWidth(), loc.getY());
        LineSegment left = new LineSegment(loc.getX(), loc.getY(), loc.getX(), loc.getY() + size.getHeight());
        LineSegment bottom = new LineSegment(loc.getX(), loc.getY() + size.getHeight(), loc.getX() + size.getWidth(), loc.getY() + size.getHeight());
        LineSegment right = new LineSegment(loc.getX() + size.getWidth(), loc.getY(), loc.getX() + size.getWidth(), loc.getY() + size.getHeight());
        return new LineSegment[]{top, bottom, left, right};
    }

    public static LineSegment findNearestEdge(Shape shape, Point p) {
        LineSegment[] edges = GraphicsUtil.getEdges(shape);
        LineSegment top = edges[0];
        LineSegment bottom = edges[1];
        LineSegment left = edges[2];
        LineSegment right = edges[3];
        double minDist = GraphicsUtil.getLength(p, top.getMiddle());
        LineSegment result = top;
        double dist = GraphicsUtil.getLength(p, bottom.getMiddle());
        if (dist < minDist) {
            minDist = dist;
            result = bottom;
        }
        if ((dist = GraphicsUtil.getLength(p, left.getMiddle())) < minDist) {
            minDist = dist;
            result = left;
        }
        if ((dist = GraphicsUtil.getLength(p, right.getMiddle())) < minDist) {
            minDist = dist;
            result = right;
        }
        return result;
    }

    public static LineSegment findNearestOrthogonalEdge(Shape shape, Point p) {
        LineSegment[] edges = GraphicsUtil.getEdges(shape);
        LineSegment top = edges[0];
        LineSegment bottom = edges[1];
        LineSegment left = edges[2];
        LineSegment right = edges[3];
        double minDist = top.getDistance(p);
        LineSegment result = top;
        double dist = bottom.getDistance(p);
        if (dist < minDist) {
            minDist = dist;
            result = bottom;
        }
        if ((dist = left.getDistance(p)) < minDist) {
            minDist = dist;
            result = left;
        }
        if ((dist = right.getDistance(p)) < minDist) {
            minDist = dist;
            result = right;
        }
        return result;
    }

    public static LineSegment findNearestEdge(Shape shape, Point p1, Point p2) {
        LineSegment[] edges = GraphicsUtil.getEdges(shape);
        LineSegment top = edges[0];
        LineSegment bottom = edges[1];
        LineSegment left = edges[2];
        LineSegment right = edges[3];
        double minDist = top.getDistance(p1) + top.getDistance(p2);
        LineSegment result = top;
        double dist = bottom.getDistance(p1) + bottom.getDistance(p2);
        if (dist < minDist) {
            minDist = dist;
            result = bottom;
        }
        if ((dist = left.getDistance(p1) + left.getDistance(p2)) < minDist) {
            minDist = dist;
            result = left;
        }
        if ((dist = right.getDistance(p1) + right.getDistance(p2)) < minDist) {
            minDist = dist;
            result = right;
        }
        return result;
    }

    public static void sendToFront(Shape shape) {
        peService.sendToFront(shape);
        BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BPMNShape.class);
        if (bpmnShape != null) {
            BPMNPlane plane = (BPMNPlane)bpmnShape.eContainer();
            plane.getPlaneElement().remove(bpmnShape);
            plane.getPlaneElement().add(bpmnShape);
        }
    }

    public static void sendToBack(Shape shape) {
        peService.sendToBack(shape);
        BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BPMNShape.class);
        if (bpmnShape != null) {
            BPMNPlane plane = (BPMNPlane)bpmnShape.eContainer();
            plane.getPlaneElement().remove(bpmnShape);
            plane.getPlaneElement().add(0, bpmnShape);
        }
    }

    public static Shape findShapeAt(ContainerShape containerShape, Point p, IShapeFilter filter) {
        for (Shape c : containerShape.getChildren()) {
            Shape cc;
            if (!c.isActive()) continue;
            if (c instanceof ContainerShape && (cc = GraphicsUtil.findShapeAt((ContainerShape)c, p, filter)) != null) {
                return cc;
            }
            if (!GraphicsUtil.contains(c, p) || !filter.matches(c)) continue;
            return c;
        }
        return null;
    }

    public static boolean isPointNear(Point p, ILocation loc, int dist) {
        int x = p.getX();
        int y = p.getY();
        int lx = loc.getX();
        int ly = loc.getY();
        return lx - dist <= x && x <= lx + dist && ly - dist <= y && y <= ly + dist;
    }

    public static boolean isPointNear(Point p1, Point p2, int dist) {
        int x = p1.getX();
        int y = p1.getY();
        int lx = p2.getX();
        int ly = p2.getY();
        return lx - dist <= x && x <= lx + dist && ly - dist <= y && y <= ly + dist;
    }

    public static Rectangle getBoundingRectangle(List<? extends PictogramElement> pes) {
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (PictogramElement pictogramElement : pes) {
            if (!(pictogramElement instanceof Shape)) continue;
            ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)pictogramElement);
            IDimension size = GraphicsUtil.calculateSize(pictogramElement);
            if (loc.getX() < xMin) {
                xMin = loc.getX();
            }
            if (loc.getY() < yMin) {
                yMin = loc.getY();
            }
            if (loc.getX() + size.getWidth() > xMax) {
                xMax = loc.getX() + size.getWidth();
            }
            if (loc.getY() + size.getHeight() <= yMax) continue;
            yMax = loc.getY() + size.getHeight();
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public class ContainerShapeFilter
    implements IShapeFilter {
        @Override
        public boolean matches(Shape shape) {
            return shape instanceof ContainerShape && !FeatureSupport.isLabelShape((PictogramElement)shape);
        }
    }

    public static interface IShapeFilter {
        public boolean matches(Shape var1);
    }

    public static class LineSegment {
        private Point start;
        private Point end;

        public LineSegment() {
            this(0, 0, 0, 0);
        }

        public LineSegment(Point start, Point end) {
            this(start.getX(), start.getY(), end.getX(), end.getY());
        }

        public LineSegment(int x1, int y1, int x2, int y2) {
            this.start = Graphiti.getCreateService().createPoint(x1, y1);
            this.end = Graphiti.getCreateService().createPoint(x2, y2);
        }

        public void setStart(Point p) {
            this.setStart(p.getX(), p.getY());
        }

        public void setStart(int x, int y) {
            this.start.setX(x);
            this.start.setY(y);
        }

        public void setEnd(Point p) {
            this.setEnd(p.getX(), p.getY());
        }

        public void setEnd(int x, int y) {
            this.end.setX(x);
            this.end.setY(y);
        }

        public Point getStart() {
            return this.start;
        }

        public Point getEnd() {
            return this.end;
        }

        public Point getMiddle() {
            int x = this.start.getX() + Math.abs(this.start.getX() - this.end.getX()) / 2;
            int y = this.start.getY() + Math.abs(this.start.getY() - this.end.getY()) / 2;
            return Graphiti.getCreateService().createPoint(x, y);
        }

        public double getDistance(Point p) {
            if (this.isHorizontal() && p.getX() >= this.start.getX() && p.getX() <= this.end.getX()) {
                return Math.abs(this.start.getY() - p.getY());
            }
            if (this.isVertical() && p.getY() >= this.start.getY() && p.getY() <= this.end.getY()) {
                return Math.abs(this.start.getX() - p.getX());
            }
            double d1 = this.getDistanceToStart(p);
            double d2 = this.getDistanceToEnd(p);
            return Math.min(d1, d2);
        }

        public boolean isHorizontal() {
            return Math.abs(this.start.getY() - this.end.getY()) <= 1;
        }

        public boolean isVertical() {
            return Math.abs(this.start.getX() - this.end.getX()) <= 1;
        }

        public boolean isSlanted() {
            return !this.isHorizontal() && !this.isVertical();
        }

        public double getDistanceToStart(Point p) {
            return Math.hypot(this.start.getX() - p.getX(), this.start.getY() - p.getY());
        }

        public double getDistanceToEnd(Point p) {
            return Math.hypot(this.end.getX() - p.getX(), this.end.getY() - p.getY());
        }

        public String toString() {
            return "[" + this.start.getX() + "," + this.start.getY() + "]" + " [" + this.end.getX() + "," + this.end.getY() + "]";
        }
    }

    public static final class RectangleIntersectsLine {
        private static final int OUT_LEFT = 1;
        private static final int OUT_TOP = 2;
        private static final int OUT_RIGHT = 4;
        private static final int OUT_BOTTOM = 8;

        private static int outcode(double pX, double pY, double rectX, double rectY, double rectWidth, double rectHeight) {
            int out = 0;
            if (rectWidth <= 0.0) {
                out |= 5;
            } else if (pX < rectX) {
                out |= 1;
            } else if (pX > rectX + rectWidth) {
                out |= 4;
            }
            if (rectHeight <= 0.0) {
                out |= 0xA;
            } else if (pY < rectY) {
                out |= 2;
            } else if (pY > rectY + rectHeight) {
                out |= 8;
            }
            return out;
        }

        /*
         * Unable to fully structure code
         */
        public static boolean intersectsLine(double lineX1, double lineY1, double lineX2, double lineY2, double rectX, double rectY, double rectWidth, double rectHeight) {
            out2 = RectangleIntersectsLine.outcode(lineX2, lineY2, rectX, rectY, rectWidth, rectHeight);
            if (out2 != 0) ** GOTO lbl18
            return true;
lbl-1000:
            // 1 sources

            {
                if ((out1 & out2) != 0) {
                    return false;
                }
                if ((out1 & 5) != 0) {
                    x = rectX;
                    if ((out1 & 4) != 0) {
                        x += rectWidth;
                    }
                    lineY1 += (x - lineX1) * (lineY2 - lineY1) / (lineX2 - lineX1);
                    lineX1 = x;
                    continue;
                }
                y = rectY;
                if ((out1 & 8) != 0) {
                    y += rectHeight;
                }
                lineX1 += (y - lineY1) * (lineX2 - lineX1) / (lineY2 - lineY1);
                lineY1 = y;
lbl18:
                // 3 sources

                ** while ((out1 = RectangleIntersectsLine.outcode((double)lineX1, (double)lineY1, (double)rectX, (double)rectY, (double)rectWidth, (double)rectHeight)) != 0)
            }
lbl19:
            // 1 sources

            return true;
        }
    }
}

