/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.DatetimeAxisLabelTextProvider;
import org.eclipse.birt.chart.computation.withaxes.LinearAxisLabelTextProvider;
import org.eclipse.birt.chart.computation.withaxes.LogAxisLabelTextProvider;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.TextAxisLabelTextProvider;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.component.Axis;

public abstract class AxisLabelTextProvider {
    protected OneAxis oax;
    protected Axis axModel;
    protected AxisTickCoordinates da;
    protected AutoScale sc;

    protected AxisLabelTextProvider(OneAxis oax) {
        this.oax = oax;
        this.axModel = oax.getModelAxis();
        this.da = oax.getScale().getTickCordinates();
        this.sc = oax.getScale();
        this.init();
    }

    public static AxisLabelTextProvider create(OneAxis oax) {
        AutoScale sc = oax.getScale();
        if ((sc.getType() & 0x10) == 16 || sc.isCategoryScale()) {
            return new TextAxisLabelTextProvider(oax);
        }
        if ((sc.getType() & 2) == 2) {
            return new LinearAxisLabelTextProvider(oax);
        }
        if ((sc.getType() & 4) == 4) {
            return new LogAxisLabelTextProvider(oax);
        }
        if ((sc.getType() & 8) == 8) {
            return new DatetimeAxisLabelTextProvider(oax);
        }
        return null;
    }

    protected abstract void init();

    public abstract String getLabelText(int var1) throws ChartException;
}

