/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.eval;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.eval.EvaluationResultImpl;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationResultBlind
extends EvaluationResultImpl {
    private int count = 0;
    private PageEvaluation pageEvaluation = null;

    public void addProblemItems(Collection<IProblemItem> collection) {
        this.stripProblem(collection);
        super.addProblemItems(collection);
    }

    public void setProblemList(List<IProblemItem> list) {
        this.count = 0;
        this.stripProblem(list);
        super.setProblemList(list);
    }

    private void stripProblem(Collection<IProblemItem> collection) {
        GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
        Iterator<IProblemItem> iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                IProblemItem iProblemItem = iterator.next();
                if (guidelineHolder.isMatchedCheckItem(iProblemItem.getEvaluationItem())) {
                    iProblemItem.setSerialNumber(this.count);
                    if (iProblemItem.isCanHighlight() && iProblemItem.getTargetNode() != null && HtmlTagUtil.hasAncestor((Node)iProblemItem.getTargetNode(), (String)"script")) {
                        iProblemItem.setCanHighlight(false);
                    }
                    ++this.count;
                    continue;
                }
                iterator.remove();
            }
            catch (Exception exception) {
                iterator.remove();
            }
        }
    }

    public PageEvaluation getPageEvaluation() {
        return this.pageEvaluation;
    }

    public void setPageEvaluation(PageEvaluation pageEvaluation) {
        this.pageEvaluation = pageEvaluation;
    }
}

