/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.notifications;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.ui.notification.NotificationDialogUtil;
import org.eclipse.acceleo.common.ui.notification.NotificationType;
import org.eclipse.acceleo.common.ui.notification.NotificationUtils;
import org.eclipse.acceleo.engine.event.AbstractAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.notifications.AcceleoLogListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AcceleoGenerationListener
extends AbstractAcceleoTextGenerationListener {
    private ArrayList<String> filesGenerated = new ArrayList();
    private long start;

    public void generationStart(Monitor monitor, File targetFolder) {
        AcceleoLogListener.resetCounters();
        this.start = System.currentTimeMillis();
    }

    public void generationCompleted() {
        super.generationCompleted();
        if (this.filesGenerated.size() > 0 && AcceleoPreferences.areNotificationsEnabled() && !AcceleoPreferences.areNotificationsForcedDisabled() && AcceleoPreferences.areSuccessNotificationsEnabled()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Double finalTime = Double.valueOf(System.currentTimeMillis() - AcceleoGenerationListener.this.start) / 1000.0;
                    int errors = AcceleoLogListener.getErrors();
                    int warnings = AcceleoLogListener.getWarnings();
                    int infos = AcceleoLogListener.getInfos();
                    if (errors == 0 && warnings == 0 && infos == 0) {
                        NotificationDialogUtil.notify((String)AcceleoUIMessages.getString("AcceleoNotifications.FilesGeneratedTitle"), (String)AcceleoUIMessages.getString("AcceleoNotifications.FilesGeneratedMessage", AcceleoGenerationListener.this.filesGenerated.size(), finalTime), (NotificationType)NotificationType.SUCCESS);
                    } else {
                        NotificationDialogUtil.notify((String)AcceleoUIMessages.getString("AcceleoNotifications.FilesGeneratedTitle"), (String)AcceleoUIMessages.getString("AcceleoNotifications.FilesGeneratedMessageWithErrors", AcceleoGenerationListener.this.filesGenerated.size(), finalTime, errors, warnings, infos), (NotificationType)NotificationType.SUCCESS, (SelectionListener)new AcceleoHyperLinkListener(), (IEclipsePreferences)NotificationUtils.getDefaultPreferences());
                    }
                }
            });
        }
        this.filesGenerated.clear();
        AcceleoLogListener.resetCounters();
    }

    public boolean listensToGenerationEnd() {
        return true;
    }

    public void fileGenerated(AcceleoTextGenerationEvent event) {
        super.fileGenerated(event);
        File file = new File(event.getText());
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
        if (iFile != null && AcceleoGenerationListener.shouldNotify(iFile)) {
            String text = event.getText();
            this.filesGenerated.add(new Path(text).lastSegment());
        }
    }

    private static boolean shouldNotify(IFile iFile) {
        boolean result = true;
        try {
            if (iFile.getProject().isAccessible() && iFile.getProject().hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                result = false;
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
        return result;
    }

    public class AcceleoHyperLinkListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            this.openErrorLogView(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.openErrorLogView(e);
        }

        private void openErrorLogView(SelectionEvent e) {
            if ("Error Log".equals(e.text)) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
                }
                catch (PartInitException e1) {
                    AcceleoUIActivator.log((Exception)((Object)e1), true);
                }
            }
        }
    }
}

