/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.viewport.command;

import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.selection.command.SelectColumnCommand;
import net.sourceforge.nattable.viewport.ViewportLayer;
import net.sourceforge.nattable.viewport.command.ViewportSelectColumnCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewportSelectColumnCommandHandler
extends AbstractLayerCommandHandler<ViewportSelectColumnCommand> {
    private final ViewportLayer viewportLayer;

    public ViewportSelectColumnCommandHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<ViewportSelectColumnCommand> getCommandClass() {
        return ViewportSelectColumnCommand.class;
    }

    @Override
    protected boolean doCommand(ViewportSelectColumnCommand command) {
        IUniqueIndexLayer scrollableLayer = this.viewportLayer.getScrollableLayer();
        int scrollableColumnPosition = this.viewportLayer.localToUnderlyingColumnPosition(command.getColumnPosition());
        int scrollableRowPosition = this.viewportLayer.getOriginRowPosition();
        scrollableLayer.doCommand(new SelectColumnCommand(scrollableLayer, scrollableColumnPosition, scrollableRowPosition, command.isWithShiftMask(), command.isWithControlMask()));
        return true;
    }
}

