/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.ui.util;

import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CellEdgeDetectUtil {
    public static int getColumnPositionToResize(ILayer layer, Point clickPoint) {
        int columnPosition = layer.getColumnPositionByX(clickPoint.x);
        if (columnPosition >= 0) {
            switch (CellEdgeDetectUtil.getHorizontalCellEdge(layer, clickPoint, 4)) {
                case LEFT: {
                    if (columnPosition == 1) break;
                    return columnPosition - 1;
                }
                case RIGHT: {
                    return columnPosition;
                }
            }
        }
        return -1;
    }

    public static int getRowPositionToResize(ILayer layer, Point clickPt) {
        int rowPosition = layer.getRowPositionByY(clickPt.y);
        if (rowPosition >= 0) {
            switch (CellEdgeDetectUtil.getVerticalCellEdge(layer, clickPt, 4)) {
                case TOP: {
                    if (rowPosition == 1) break;
                    return rowPosition - 1;
                }
                case BOTTOM: {
                    return rowPosition;
                }
            }
        }
        return -1;
    }

    public static CellEdgeEnum getHorizontalCellEdge(Rectangle cellBounds, Point clickPt) {
        return CellEdgeDetectUtil.getHorizontalCellEdge(cellBounds, clickPt, -1);
    }

    public static CellEdgeEnum getHorizontalCellEdge(ILayer layer, Point clickPt) {
        return CellEdgeDetectUtil.getHorizontalCellEdge(layer, clickPt, -1);
    }

    public static CellEdgeEnum getHorizontalCellEdge(ILayer layer, Point clickPt, int handleWidth) {
        LayerCell cell = layer.getCellByPosition(layer.getColumnPositionByX(clickPt.x), layer.getRowPositionByY(clickPt.y));
        if (cell != null) {
            return CellEdgeDetectUtil.getHorizontalCellEdge(cell.getBounds(), clickPt, handleWidth);
        }
        return CellEdgeEnum.NONE;
    }

    public static CellEdgeEnum getHorizontalCellEdge(Rectangle cellBounds, Point clickPt, int distanceFromEdge) {
        if (distanceFromEdge < 0) {
            distanceFromEdge = cellBounds.width / 2;
        }
        Rectangle left = new Rectangle(cellBounds.x, cellBounds.y, distanceFromEdge, cellBounds.height);
        Rectangle right = new Rectangle(cellBounds.x + cellBounds.width - distanceFromEdge, cellBounds.y, distanceFromEdge, cellBounds.height);
        if (left.contains(clickPt)) {
            return CellEdgeEnum.LEFT;
        }
        if (right.contains(clickPt)) {
            return CellEdgeEnum.RIGHT;
        }
        return CellEdgeEnum.NONE;
    }

    public static CellEdgeEnum getVerticalCellEdge(ILayer layer, Point clickPt, int handleHeight) {
        LayerCell cell = layer.getCellByPosition(layer.getColumnPositionByX(clickPt.x), layer.getRowPositionByY(clickPt.y));
        return CellEdgeDetectUtil.getVerticalCellEdge(cell.getBounds(), clickPt, handleHeight);
    }

    private static CellEdgeEnum getVerticalCellEdge(Rectangle cellBounds, Point clickPt, int distanceFromEdge) {
        if (distanceFromEdge < 0) {
            distanceFromEdge = cellBounds.height / 2;
        }
        Rectangle top = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, distanceFromEdge);
        Rectangle bottom = new Rectangle(cellBounds.x, cellBounds.y + cellBounds.height - distanceFromEdge, cellBounds.width, distanceFromEdge);
        if (top.contains(clickPt)) {
            return CellEdgeEnum.TOP;
        }
        if (bottom.contains(clickPt)) {
            return CellEdgeEnum.BOTTOM;
        }
        return CellEdgeEnum.NONE;
    }
}

