/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.copy.command;

import java.util.Set;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.copy.serializing.CopyDataToClipboardSerializer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyDataCommandHandler
extends AbstractLayerCommandHandler<CopyDataToClipboardCommand> {
    private final SelectionLayer selectionLayer;
    private final ILayer columnHeaderLayer;
    private final ILayer rowHeaderLayer;

    public CopyDataCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null, null);
    }

    public CopyDataCommandHandler(SelectionLayer selectionLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer) {
        this.selectionLayer = selectionLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.rowHeaderLayer = rowHeaderLayer;
    }

    @Override
    public boolean doCommand(CopyDataToClipboardCommand command) {
        CopyDataToClipboardSerializer serializer = new CopyDataToClipboardSerializer(this.assembleCopiedDataStructure(), command);
        serializer.serialize();
        return true;
    }

    @Override
    public Class<CopyDataToClipboardCommand> getCommandClass() {
        return CopyDataToClipboardCommand.class;
    }

    protected LayerCell[][] assembleCopiedDataStructure() {
        Set<Range> selectedRows = this.selectionLayer.getSelectedRows();
        int rowOffset = this.columnHeaderLayer != null ? this.columnHeaderLayer.getRowCount() : 0;
        LayerCell[][] copiedCells = new LayerCell[this.selectionLayer.getSelectedRowCount() + rowOffset][1];
        if (this.columnHeaderLayer != null) {
            copiedCells[0] = this.assembleColumnHeaders(this.selectionLayer.getSelectedColumns());
        }
        for (Range range : selectedRows) {
            int rowPosition = range.start;
            while (rowPosition < range.end) {
                copiedCells[rowPosition - range.start + rowOffset] = this.assembleBody(rowPosition);
                ++rowPosition;
            }
        }
        return copiedCells;
    }

    protected LayerCell[] assembleColumnHeaders(int ... selectedColumnPositions) {
        int columnOffset = this.rowHeaderLayer.getColumnCount();
        LayerCell[] cells = new LayerCell[selectedColumnPositions.length + columnOffset];
        int columnPosition = 0;
        while (columnPosition < selectedColumnPositions.length) {
            cells[columnPosition + columnOffset] = this.columnHeaderLayer.getCellByPosition(selectedColumnPositions[columnPosition], 0);
            ++columnPosition;
        }
        return cells;
    }

    protected LayerCell[] assembleBody(int currentRowPosition) {
        int[] selectedColumns = this.selectionLayer.getSelectedColumns();
        int columnOffset = this.rowHeaderLayer != null ? this.rowHeaderLayer.getColumnCount() : 0;
        LayerCell[] bodyCells = new LayerCell[selectedColumns.length + columnOffset];
        if (this.rowHeaderLayer != null) {
            bodyCells[0] = this.rowHeaderLayer.getCellByPosition(0, currentRowPosition);
        }
        int columnPosition = 0;
        while (columnPosition < selectedColumns.length) {
            int selectedColumnPosition = selectedColumns[columnPosition];
            if (this.selectionLayer.isCellPositionSelected(selectedColumnPosition, currentRowPosition)) {
                bodyCells[columnPosition + columnOffset] = this.selectionLayer.getCellByPosition(selectedColumnPosition, currentRowPosition);
            }
            ++columnPosition;
        }
        return bodyCells;
    }
}

