/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.scatter;

import java.text.Format;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreScatterDataProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.scatter.SegmentStoreScatterGraphTooltipProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;

public abstract class AbstractSegmentStoreScatterGraphViewer
extends TmfCommonXLineChartViewer {
    private static final Format FORMAT = new SubSecondTimeWithUnitFormat();

    public AbstractSegmentStoreScatterGraphViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title, xLabel, yLabel);
        this.setTooltipProvider((TmfBaseProvider)new SegmentStoreScatterGraphTooltipProvider((ITmfChartTimeProvider)this));
        this.getSwtChart().getLegend().setVisible(false);
        this.getSwtChart().getAxisSet().getYAxis(0).getTick().setFormat(FORMAT);
    }

    @Deprecated
    public void updateModel(@Nullable ISegmentStore<ISegment> dataInput) {
        TmfTimeRange currentRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
        long currentStart = currentRange.getStartTime().toNanos();
        long currentEnd = currentRange.getEndTime().toNanos();
        if (dataInput == null && !AbstractSegmentStoreScatterGraphViewer.getDisplay().isDisposed()) {
            Display.getDefault().syncExec(() -> this.clearContent());
        }
        this.setWindowRange(currentStart, currentEnd);
        this.updateContent();
    }

    protected void initializeDataSource() {
        ISegmentStoreProvider segmentStoreProvider;
        ITmfTrace trace = this.getTrace();
        if (trace != null && (segmentStoreProvider = this.getSegmentStoreProvider(trace)) != null) {
            this.setDataProvider((ITmfXYDataProvider)SegmentStoreScatterDataProvider.create((ITmfTrace)trace, (ISegmentStoreProvider)segmentStoreProvider));
        }
    }

    @Deprecated
    public void setData(@Nullable ISegmentStoreProvider provider) {
        if (provider == null) {
            this.updateModel(null);
            return;
        }
        ISegmentStore segStore = provider.getSegmentStore();
        if (segStore != null) {
            this.updateModel((ISegmentStore<ISegment>)segStore);
            return;
        }
        this.updateModel(null);
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).schedule();
        }
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        if (this.getTrace() != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
        }
    }

    @TmfSignalHandler
    public void traceOpened(@Nullable TmfTraceOpenedSignal signal) {
        super.traceOpened(signal);
        if (this.getTrace() != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
        }
    }

    public String getSeriesType(String seriesName) {
        return "scatter";
    }

    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        if (signal != null && TmfTraceManager.getInstance().getActiveTrace() == null) {
            this.clearContent();
        }
        this.refresh();
    }
}

