/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.dynamic.DynamicPropertiesManager;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.internal.weaving.RelationshipInfo;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class DynamicEntityImpl
implements DynamicEntity,
PersistenceEntity,
ChangeTracker,
FetchGroupTracker,
PersistenceWeavedRest {
    protected Map<String, PropertyWrapper> propertiesMap = new HashMap<String, PropertyWrapper>();
    private Object primaryKey;
    protected CacheKey cacheKey;
    private PropertyChangeListener changeListener = null;
    private FetchGroup fetchGroup;
    private boolean refreshFetchGroup = false;
    private Session session;

    public abstract DynamicPropertiesManager fetchPropertiesManager();

    public DynamicEntityImpl() {
        this.postConstruct();
    }

    public Map<String, PropertyWrapper> getPropertiesMap() {
        return this.propertiesMap;
    }

    protected void postConstruct() {
        DynamicPropertiesManager dpm = this.fetchPropertiesManager();
        dpm.postConstruct(this);
    }

    public DynamicTypeImpl getType() throws DynamicException {
        DynamicType type = this.fetchPropertiesManager().getType();
        if (type == null) {
            throw DynamicException.entityHasNullType(this);
        }
        return (DynamicTypeImpl)type;
    }

    @Override
    public <T> T get(String propertyName) throws DynamicException {
        DynamicPropertiesManager dpm = this.fetchPropertiesManager();
        if (dpm.contains(propertyName)) {
            Object value;
            String errorMsg;
            if (this._persistence_getFetchGroup() != null && (errorMsg = this._persistence_getFetchGroup().onUnfetchedAttribute(this, propertyName)) != null) {
                throw DynamicException.invalidPropertyName(dpm.getType(), propertyName);
            }
            PropertyWrapper wrapper = this.propertiesMap.get(propertyName);
            if (wrapper == null) {
                wrapper = new PropertyWrapper();
                this.propertiesMap.put(propertyName, wrapper);
            }
            if ((value = wrapper.getValue()) instanceof ValueHolderInterface) {
                value = ((ValueHolderInterface)value).getValue();
            } else if (value instanceof IndirectContainer) {
                value = ((IndirectContainer)value).getValueHolder().getValue();
            }
            try {
                return (T)value;
            }
            catch (ClassCastException cce) {
                ClassDescriptor descriptor = this.getType().getDescriptor();
                DatabaseMapping dm = null;
                dm = descriptor != null ? descriptor.getMappingForAttributeName(propertyName) : new UnknownMapping(propertyName);
                throw DynamicException.invalidGetPropertyType(dm, cce);
            }
        }
        throw DynamicException.invalidPropertyName(dpm.getType(), propertyName);
    }

    @Override
    public boolean isSet(String propertyName) throws DynamicException {
        if (this.fetchPropertiesManager().contains(propertyName)) {
            if (this._persistence_getFetchGroup() != null && !this._persistence_getFetchGroup().containsAttributeInternal(propertyName)) {
                return false;
            }
            PropertyWrapper wrapper = this.propertiesMap.get(propertyName);
            if (wrapper == null) {
                wrapper = new PropertyWrapper();
                this.propertiesMap.put(propertyName, wrapper);
            }
            return wrapper.isSet();
        }
        throw DynamicException.invalidPropertyName(this.fetchPropertiesManager().getType(), propertyName);
    }

    @Override
    public DynamicEntity set(String propertyName, Object value) throws DynamicException {
        return this.set(propertyName, value, true);
    }

    public DynamicEntity set(String propertyName, Object value, boolean firePropertyChange) throws DynamicException {
        String errorMsg;
        DynamicPropertiesManager dpm = this.fetchPropertiesManager();
        dpm.checkSet(propertyName, value);
        if (this._persistence_getFetchGroup() != null && (errorMsg = this._persistence_getFetchGroup().onUnfetchedAttributeForSet(this, propertyName)) != null) {
            throw DynamicException.invalidPropertyName(dpm.getType(), propertyName);
        }
        PropertyWrapper wrapper = this.propertiesMap.get(propertyName);
        if (wrapper == null) {
            wrapper = new PropertyWrapper();
            this.propertiesMap.put(propertyName, wrapper);
        }
        Object oldValue = null;
        Object wrapperValue = wrapper.getValue();
        if (wrapperValue instanceof ValueHolderInterface) {
            ValueHolderInterface vh = (ValueHolderInterface)wrapperValue;
            if (vh.isInstantiated()) {
                oldValue = vh.getValue();
            }
            vh.setValue(value);
            wrapper.isSet(true);
        } else {
            oldValue = wrapperValue;
            wrapper.setValue(value);
            wrapper.isSet(true);
        }
        if (this.changeListener != null && firePropertyChange) {
            this.changeListener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, value));
        }
        return this;
    }

    @Override
    public Object _persistence_getId() {
        return this.primaryKey;
    }

    @Override
    public void _persistence_setId(Object pk) {
        this.primaryKey = pk;
    }

    @Override
    public CacheKey _persistence_getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public FetchGroup _persistence_getFetchGroup() {
        return this.fetchGroup;
    }

    @Override
    public void _persistence_setFetchGroup(FetchGroup group) {
        this.fetchGroup = group;
    }

    @Override
    public void _persistence_setShouldRefreshFetchGroup(boolean shouldRefreshFetchGroup) {
        this.refreshFetchGroup = shouldRefreshFetchGroup;
    }

    @Override
    public boolean _persistence_shouldRefreshFetchGroup() {
        return this.refreshFetchGroup;
    }

    @Override
    public boolean _persistence_isAttributeFetched(String attribute) {
        return this.fetchGroup == null || this.fetchGroup.containsAttributeInternal(attribute);
    }

    @Override
    public void _persistence_resetFetchGroup() {
    }

    @Override
    public List<RelationshipInfo> _persistence_getRelationships() {
        ArrayList<RelationshipInfo> relationships = (ArrayList<RelationshipInfo>)this.get("_persistence_relationshipInfo");
        if (relationships == null) {
            relationships = new ArrayList<RelationshipInfo>();
            this._persistence_setRelationships(relationships);
        }
        return relationships;
    }

    @Override
    public void _persistence_setRelationships(List<RelationshipInfo> relationships) {
        this.set("_persistence_relationshipInfo", relationships, false);
    }

    @Override
    public Link _persistence_getHref() {
        return (Link)this.get("_persistence_href");
    }

    @Override
    public void _persistence_setHref(Link href) {
        this.set("_persistence_href", href, false);
    }

    @Override
    public Session _persistence_getSession() {
        return this.session;
    }

    @Override
    public void _persistence_setSession(Session session) {
        this.session = session;
    }

    @Override
    public ItemLinks _persistence_getLinks() {
        return (ItemLinks)this.get("_persistence_links");
    }

    @Override
    public void _persistence_setLinks(ItemLinks links) {
        this.set("_persistence_links", links, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append('{');
        sb.append(Helper.getShortClassName(this.getClass()));
        if (this.primaryKey != null) {
            sb.append(' ');
            sb.append(this.primaryKey);
        }
        sb.append('}');
        return sb.toString();
    }

    public static final class PropertyWrapper {
        private Object value = null;
        private boolean isSet = false;

        public PropertyWrapper() {
        }

        public PropertyWrapper(Object value) {
            this.setValue(value);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isSet() {
            return this.isSet;
        }

        public void isSet(boolean isSet) {
            this.isSet = isSet;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isSet) {
                sb.append("[T]");
            } else if (this.value == null) {
                sb.append("[F]");
            } else {
                sb.append("[d]");
            }
            if (this.value == null) {
                sb.append("<null>");
            } else {
                sb.append(this.value.toString());
            }
            return sb.toString();
        }
    }

    static final class UnknownMapping
    extends DatabaseMapping {
        public UnknownMapping(String propertyName) {
            this.setAttributeName(propertyName);
        }

        @Override
        public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        }

        @Override
        public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        }

        @Override
        public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        }

        @Override
        public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        }

        @Override
        public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        }

        @Override
        public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
            return null;
        }

        @Override
        public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
            return false;
        }

        @Override
        public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        }

        @Override
        public void iterate(DescriptorIterator iterator) {
        }

        @Override
        public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        }

        @Override
        public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        }
    }
}

