/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.sort;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.NullComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.SortLabelProviderFullCellContextElementWrapper;

public class PapyrusNatColumnTableFormat<R>
implements AdvancedTableFormat<R> {
    private static final int SORT_LABEL_PROVIDER_CACHE_SIZE = 2;
    private int cacheIndex = 0;
    private List<SortLabelProviderFullCellContextElementWrapper> sortLabelProviderCache = null;
    private IColumnAccessor<R> columnAccessor;
    private ILayer columnHeaderDataLayer;
    private INattableModelManager manager;

    public PapyrusNatColumnTableFormat(IColumnAccessor<R> columnAccessor, INattableModelManager manager, ILayer columnHeaderDataLayer) {
        this.manager = manager;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.columnAccessor = columnAccessor;
    }

    private void initCache() {
        this.sortLabelProviderCache = new ArrayList<SortLabelProviderFullCellContextElementWrapper>();
        int i = 0;
        while (i < 2) {
            SortLabelProviderFullCellContextElementWrapper w = new SortLabelProviderFullCellContextElementWrapper();
            w.setConfigLabels(new LabelStack(new String[]{"BODY"}));
            w.setConfigRegistry(this.getConfigRegistry());
            this.sortLabelProviderCache.add(w);
            ++i;
        }
    }

    public void setColumnHeaderDataLayer(ILayer layer) {
        this.columnHeaderDataLayer = layer;
    }

    private IConfigRegistry getConfigRegistry() {
        NatTable natTable = (NatTable)this.manager.getAdapter(NatTable.class);
        return natTable.getConfigRegistry();
    }

    public Class<?> getColumnClass(int col) {
        throw new UnsupportedOperationException();
    }

    public Comparator<?> getColumnComparator(int col) {
        if (this.columnHeaderDataLayer == null) {
            return null;
        }
        ILayerCell cell = null;
        Object comparator = null;
        cell = this.columnHeaderDataLayer.getCellByPosition(col, 0);
        comparator = cell == null ? new NullComparator() : (Comparator)this.getConfigRegistry().getConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        return comparator instanceof NullComparator ? null : comparator;
    }

    public String getColumnName(int col) {
        throw new UnsupportedOperationException();
    }

    public int getColumnCount() {
        return this.columnAccessor.getColumnCount();
    }

    public Object getColumnValue(R rowObj, int col) {
        if (this.sortLabelProviderCache == null) {
            this.initCache();
        }
        SortLabelProviderFullCellContextElementWrapper w = this.sortLabelProviderCache.get(this.cacheIndex);
        if (AxisUtils.getRepresentedElement(rowObj) instanceof TreeFillingConfiguration) {
            w.setDataValue(null);
        } else {
            w.setDataValue(this.columnAccessor.getDataValue(rowObj, col));
        }
        w.setRowObject(rowObj);
        w.setColumnObject(this.manager.getColumnElement(col));
        w.setColumnIndex(col);
        ++this.cacheIndex;
        if (this.cacheIndex == 2) {
            this.cacheIndex = 0;
        }
        return w;
    }
}

