/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CompositeContainerImageDescriptor
extends CompositeImageDescriptor {
    private final ImageData base;
    private ImageData overlay;
    protected Point size;

    public CompositeContainerImageDescriptor(ImageDescriptor icon, ImageDescriptor overlay, boolean wide) {
        this.base = this.getImageData(icon);
        if (overlay != null) {
            this.overlay = this.getImageData(overlay);
        }
        int width = 16;
        if (wide) {
            width += 6;
        }
        this.size = new Point(width, this.base.height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base, 0, 0);
        if (this.overlay != null) {
            this.drawImage(this.overlay, this.base.width + 2, 0);
        }
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        return data;
    }

    protected Point getSize() {
        return new Point(this.size.x, this.size.y);
    }
}

