/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.refined.RefinedStructuredResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefinedTable
extends RefinedStructuredResult
implements IResultTable {
    protected List<?> rows;

    RefinedTable() {
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            this.reread();
        }
        return this.rows.size();
    }

    public List<?> getRows() {
        if (this.rows == null) {
            this.reread();
        }
        return this.rows;
    }

    @Override
    public Object getRow(int rowId) {
        if (this.rows == null) {
            this.reread();
        }
        return this.rows.get(rowId);
    }

    public synchronized void refresh() {
        this.rows = null;
    }

    private void reread() {
        try {
            this.rows = this.refine(this.asList());
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    private List<?> asList() {
        IResultTable table = (IResultTable)this.subject;
        int rowCount = table.getRowCount();
        ArrayList<Object> l = new ArrayList<Object>(rowCount);
        int ii = 0;
        while (ii < rowCount) {
            l.add(table.getRow(ii));
            ++ii;
        }
        return l;
    }

    @Override
    public void filterChanged(Filter filter) {
        this.rows = null;
    }
}

