/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="references_statistics")
public class ReferenceQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    static final String DEFAULT_REFERENT = "referent";
    @Argument(isMandatory=false)
    public String referent_attribute = "referent";
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("java\\.lang\\.ref\\..*Reference");
    private static final Pattern QUEUE_PATTERN = Pattern.compile("java\\.lang\\.ref\\..*ReferenceQueue.*");

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.ReferenceQuery_Msg_ComputingReferentSet);
        ArrayInt instanceSet = new ArrayInt();
        SetInt referentSet = new SetInt();
        for (int[] objs : this.objects) {
            instanceSet.addAll(objs);
            int ii = 0;
            while (ii < objs.length) {
                IInstance obj;
                ObjectReference ref;
                IObject o = this.snapshot.getObject(objs[ii]);
                if (o instanceof IInstance && (ref = ReferenceQuery.getReferent(obj = (IInstance)o, this.referent_attribute)) != null) {
                    referentSet.add(ref.getObjectId());
                }
                ++ii;
            }
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        return ReferenceQuery.execute(instanceSet, referentSet, this.snapshot, Messages.ReferenceQuery_HistogramOfReferentObjects, Messages.ReferenceQuery_OnlyRetainedByReferents, Messages.ReferenceQuery_StronglyRetainedByReferences, this.referent_attribute, listener);
    }

    public static IResult execute(String className, ISnapshot snapshot, String labelHistogramReferenced, String labelHistogramRetained, String labelHistogramStronglyRetainedReferents, IProgressListener listener) throws SnapshotException {
        listener.subTask(Messages.ReferenceQuery_Msg_ComputingReferentSet);
        ArrayInt instanceSet = new ArrayInt();
        SetInt referentSet = new SetInt();
        Collection<IClass> classes = snapshot.getClassesByName(Pattern.compile(className), true);
        if (classes == null) {
            throw new SnapshotException(MessageUtil.format((String)Messages.ReferenceQuery_ErrorMsg_NoMatchingClassesFound, (Object[])new Object[]{className}));
        }
        for (IClass clazz : classes) {
            int[] objs = clazz.getObjectIds();
            instanceSet.addAll(objs);
            int ii = 0;
            while (ii < objs.length) {
                IInstance obj = (IInstance)snapshot.getObject(objs[ii]);
                ObjectReference ref = ReferenceQuery.getReferent(obj);
                if (ref != null) {
                    referentSet.add(ref.getObjectId());
                }
                ++ii;
            }
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        return ReferenceQuery.execute(instanceSet, referentSet, snapshot, labelHistogramReferenced, labelHistogramRetained, labelHistogramStronglyRetainedReferents, DEFAULT_REFERENT, listener);
    }

    public static CompositeResult execute(ArrayInt instanceSet, SetInt referentSet, ISnapshot snapshot, String labelHistogramReferenced, String labelHistogramRetained, String labelHistogramStronglyRetainedReferents, IProgressListener listener) throws SnapshotException {
        return ReferenceQuery.execute(instanceSet, referentSet, snapshot, labelHistogramReferenced, labelHistogramRetained, labelHistogramStronglyRetainedReferents, DEFAULT_REFERENT, listener);
    }

    public static CompositeResult execute(ArrayInt instanceSet, SetInt referentSet, ISnapshot snapshot, String labelHistogramReferenced, String labelHistogramRetained, String labelHistogramStronglyRetainedReferents, String referentField, IProgressListener listener) throws SnapshotException {
        CompositeResult result = new CompositeResult(new IResult[0]);
        Histogram histogram = snapshot.getHistogram(referentSet.toArray(), listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(labelHistogramReferenced);
        result.addResult(labelHistogramReferenced, (IResult)histogram);
        listener.subTask(Messages.ReferenceQuery_Msg_ComputingRetainedSet);
        int[] retainedSet = snapshot.getRetainedSet(instanceSet.toArray(), new String[]{referentField}, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram = snapshot.getHistogram(retainedSet, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(labelHistogramRetained);
        result.addResult(labelHistogramRetained, (IResult)histogram);
        listener.subTask(Messages.ReferenceQuery_Msg_ComputingStronglyRetainedSet);
        int[] allRetainedSet = snapshot.getRetainedSet(instanceSet.toArray(), listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Arrays.sort(allRetainedSet);
        int[] newWeakRetained = new int[retainedSet.length];
        System.arraycopy(retainedSet, 0, newWeakRetained, 0, retainedSet.length);
        Arrays.sort(newWeakRetained);
        int[] r = new int[allRetainedSet.length - newWeakRetained.length];
        int t2 = -1;
        int s = 0;
        int d = 0;
        int w = 0;
        while (s < allRetainedSet.length) {
            int t1 = allRetainedSet[s];
            while (w < newWeakRetained.length && t2 < t1) {
                t2 = newWeakRetained[w++];
            }
            if (t1 != t2) {
                r[d++] = t1;
            }
            ++s;
        }
        int[] referents = referentSet.toArray();
        Arrays.sort(referents);
        t2 = -1;
        d = 0;
        int s2 = 0;
        int w2 = 0;
        while (s2 < referents.length) {
            int t1 = referents[s2];
            while (w2 < r.length && t2 < t1) {
                t2 = r[w2++];
            }
            if (t1 == t2) {
                referents[d++] = t1;
            }
            ++s2;
        }
        int[] leakingReferents = new int[d];
        System.arraycopy(referents, 0, leakingReferents, 0, d);
        histogram = snapshot.getHistogram(leakingReferents, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(labelHistogramStronglyRetainedReferents);
        result.addResult(labelHistogramStronglyRetainedReferents, (IResult)histogram);
        return result;
    }

    public static ObjectReference getReferent(IInstance instance) throws SnapshotException {
        return ReferenceQuery.getReferent(instance, DEFAULT_REFERENT);
    }

    static ObjectReference getReferent(IInstance instance, String referentName) throws SnapshotException {
        Field field = instance.getField(referentName);
        if (field != null) {
            return (ObjectReference)field.getValue();
        }
        if (REFERENCE_PATTERN.matcher(instance.getClazz().getName()).matches() || "java.lang.ref.Finalizer".equals(instance.getClazz().getName())) {
            int[] outbounds;
            ISnapshot snapshot = instance.getSnapshot();
            int[] nArray = outbounds = snapshot.getOutboundReferentIds(instance.getObjectId());
            int n = outbounds.length;
            int n2 = 0;
            while (n2 < n) {
                int outboundId = nArray[n2];
                IClass outboundType = snapshot.getClassOf(outboundId);
                if (instance.getClazz().getObjectId() != outboundId && !ReferenceQuery.isReferenceType(outboundType) && !ReferenceQuery.isReferenceQueueType(outboundType)) {
                    long address = snapshot.mapIdToAddress(outboundId);
                    return new ObjectReference(snapshot, address);
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    private static boolean isReferenceType(IClass clazz) throws SnapshotException {
        return REFERENCE_PATTERN.matcher(clazz.getName()).matches() || "java.lang.ref.Finalizer".equals(clazz.getName()) || clazz.doesExtend("java.lang.ref.Reference");
    }

    private static boolean isReferenceQueueType(IClass clazz) throws SnapshotException {
        return QUEUE_PATTERN.matcher(clazz.getName()).matches() || clazz.doesExtend("java.lang.ref.ReferenceQueue");
    }
}

