/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.core.internal.dependency;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyUtil {
    public static Object[] getDependencies(BundleDescription bundleDescription) {
        if (bundleDescription == null) {
            return new BundleDescription[0];
        }
        List<Object> c = DependencyUtil.getDescription(bundleDescription.getRequiredBundles());
        c.addAll(DependencyUtil.getExportedDescription(bundleDescription, bundleDescription.getResolvedImports()));
        if (bundleDescription.getHost() != null) {
            c.add(bundleDescription.getHost().getSupplier());
        }
        return c.toArray(new Object[c.size()]);
    }

    public static List<Object> getDescription(BundleSpecification[] specifications) {
        ArrayList<Object> descriptionList = new ArrayList<Object>();
        int i = 0;
        while (i < specifications.length) {
            BundleSpecification specification = specifications[i];
            if (specification.getSupplier() == null) {
                descriptionList.add(specification);
            } else {
                descriptionList.add(specification.getSupplier());
            }
            ++i;
        }
        return descriptionList;
    }

    private static Set<BundleDescription> getExportedDescription(BundleDescription element, ExportPackageDescription[] exportedPackages) {
        HashSet<BundleDescription> descriptionList = new HashSet<BundleDescription>();
        int i = 0;
        while (i < exportedPackages.length) {
            ExportPackageDescription exportedPackage = exportedPackages[i];
            if (!element.getLocation().equals(exportedPackage.getExporter().getLocation())) {
                descriptionList.add(exportedPackage.getExporter());
            }
            ++i;
        }
        return descriptionList;
    }
}

