/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.managed.recentfiles;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.actions.internal.WEAbstractMenuManager;
import org.eclipse.jwt.we.editors.actions.managed.recentfiles.RecentFileAction;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.osgi.framework.Bundle;

public class RecentFilesListManager
extends WEAbstractMenuManager {
    private static Logger logger = Logger.getLogger(RecentFilesListManager.class);
    private static final String PREFERENCE_PREFIX = "recentfile";
    private static final int NUMBER_OF_FILES = 10;
    private static final String CONFIG_FILENAME = "recentfiles.dat";
    private List<RecentFileAction> fileactionlist = new ArrayList<RecentFileAction>(10);
    private static RecentFilesListManager myinstance;

    private RecentFilesListManager() {
        this.load();
    }

    public static String getName(int id) {
        return PREFERENCE_PREFIX + id;
    }

    public static RecentFilesListManager getInstance() {
        if (myinstance == null) {
            myinstance = new RecentFilesListManager();
        }
        return myinstance;
    }

    public void fillMenuInitial() {
        try {
            this.menu.removeAll();
            if (this.fileactionlist.size() <= 0) {
                this.addToMenuAndRegister((IAction)new RecentFileAction("", ""));
                return;
            }
            int i = this.fileactionlist.size() - 1;
            while (i >= 0) {
                this.addToMenuAndRegister((IAction)this.fileactionlist.get(i));
                --i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setNewFile(String file) {
        try {
            int i = 0;
            while (i < this.fileactionlist.size()) {
                if (this.fileactionlist.get(i).getFilename().equals(RecentFileAction.makeFilename(file))) {
                    return;
                }
                ++i;
            }
            String id = "";
            if (this.fileactionlist.size() >= 10) {
                RecentFileAction rfa = this.fileactionlist.get(0);
                this.fileactionlist.remove(rfa);
            }
            id = PREFERENCE_PREFIX + this.fileactionlist.size();
            this.fileactionlist.add(new RecentFileAction(file, id));
            this.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void save() {
        try {
            File configfile = RecentFilesListManager.getFileHandle(CONFIG_FILENAME);
            if (configfile == null) {
                return;
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(configfile));
            oos.writeObject(this.fileactionlist);
            oos.flush();
            oos.close();
        }
        catch (Exception ex) {
            logger.info(ex.toString());
        }
    }

    private void load() {
        try {
            File configfile = RecentFilesListManager.getFileHandle(CONFIG_FILENAME);
            if (configfile == null || !configfile.exists()) {
                return;
            }
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(configfile));
            this.fileactionlist = (List)ois.readObject();
            ois.close();
            int i = 0;
            while (i < this.fileactionlist.size()) {
                RecentFileAction rfa = this.fileactionlist.get(i);
                this.fileactionlist.get(i).setText(rfa.getFilename());
                this.fileactionlist.get(i).setId(RecentFilesListManager.getName(i));
                ++i;
            }
            ArrayList<RecentFileAction> newlist = new ArrayList<RecentFileAction>();
            for (RecentFileAction rfa : this.fileactionlist) {
                newlist.add(rfa);
            }
            this.fileactionlist = newlist;
            this.save();
        }
        catch (Exception ex) {
            logger.info(ex.toString());
        }
    }

    public static File getFileHandle(String filetohandle) {
        try {
            Plugin defaultplugin = Plugin.getDefault();
            File viewdir = null;
            URL viewsfullpath = null;
            if (defaultplugin != null) {
                File testfile;
                Bundle bundle = defaultplugin.getBundle();
                URL viewspath = bundle.getEntry("");
                if (viewspath != null) {
                    viewsfullpath = FileLocator.resolve((URL)viewspath);
                }
                viewdir = (testfile = new File(viewsfullpath.getPath())) == null || testfile.isFile() || testfile.getAbsolutePath().endsWith("!") ? null : new File(String.valueOf(viewsfullpath.getPath()) + "/" + filetohandle);
            }
            if (viewdir == null) {
                File currentpathfile = new File(".");
                String currentpath = currentpathfile.getAbsolutePath();
                currentpath = currentpath.substring(0, currentpath.length() - 2);
                viewdir = new File(String.valueOf(currentpath) + "\\" + filetohandle);
            }
            return viewdir;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setActionBarConfigurer(IActionBarConfigurer acbar) {
        super.setActionBarConfigurer(acbar);
    }

    public void setMenu(IMenuManager menu) {
        super.setMenu(menu);
    }

    public void setWindowHandle(IWorkbenchWindow window) {
        super.setWindowHandle(window);
    }
}

