/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.internal.init;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jwt.transformations.api.AbstractTransformation;
import org.eclipse.jwt.transformations.api.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationRegistry {
    private static TransformationRegistry instance = null;
    private Set<Transformation> transformations = new HashSet<Transformation>();

    public static void createInstance() throws CoreException, IOException {
        if (instance == null) {
            instance = new TransformationRegistry();
        }
    }

    public static TransformationRegistry getInstance() {
        return instance;
    }

    private TransformationRegistry() throws CoreException, IOException {
        IConfigurationElement[] transformationElements;
        IConfigurationElement[] iConfigurationElementArray = transformationElements = AbstractTransformation.getExtensionPoint().getConfigurationElements();
        int n = transformationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Transformation created = AbstractTransformation.createTransformation(element);
            this.transformations.add(created);
            ++n2;
        }
    }

    public Collection<Transformation> getTransformations() {
        return Collections.unmodifiableSet(this.transformations);
    }

    public Collection<Transformation> getTransformationsByType(Transformation.Type requiredType) {
        ArrayList<Transformation> filteredTransformations = new ArrayList<Transformation>();
        for (Transformation transformation : this.transformations) {
            if (!transformation.getType().equals((Object)requiredType)) continue;
            filteredTransformations.add(transformation);
        }
        return filteredTransformations;
    }
}

