/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.gui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.Severity;
import org.eclipse.jubula.client.teststyle.problems.ProblemCont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeststyleProblemAdder
extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        this.clearNodeFromTeststyleProblem(node);
        for (BaseCheck chk : ProblemCont.instance.getChecksFor(node)) {
            int severity = this.getIntForSeverity(chk.getSeverity());
            String message = chk.getDescription();
            if (severity <= 1) continue;
            node.addProblem(ProblemFactory.createProblem((IStatus)new Status(severity, "org.eclipse.jubula.client.teststyle", message)));
        }
        if (node instanceof IExecTestCasePO) {
            IExecTestCasePO execTestCase = (IExecTestCasePO)node;
            this.handleExecTestCase(execTestCase);
        }
        return true;
    }

    private void clearNodeFromTeststyleProblem(INodePO node) {
        HashSet copy = new HashSet(node.getProblems());
        for (IProblem problem : copy) {
            if (!problem.getStatus().getPlugin().equals("org.eclipse.jubula.client.teststyle")) continue;
            node.removeProblem(problem);
        }
    }

    private void handleExecTestCase(IExecTestCasePO execTestCase) {
        ISpecTestCasePO specTestCase = execTestCase.getSpecTestCase();
        int worstSeverity = this.getWorstSeverity(ProblemCont.instance.getChecksFor(specTestCase));
        Status status = null;
        switch (worstSeverity) {
            case 4: {
                status = new Status(4, "org.eclipse.jubula.client.teststyle", Messages.TooltipErrorInChildren);
                break;
            }
            case 2: {
                status = new Status(2, "org.eclipse.jubula.client.teststyle", Messages.TooltipErrorInChildren);
                break;
            }
        }
        if (status != null) {
            IProblem problem = ProblemFactory.createProblem(status);
            execTestCase.addProblem(problem);
        }
    }

    private int getWorstSeverity(Set<BaseCheck> checks) {
        int status = -1;
        for (BaseCheck chk : checks) {
            int chkStatus = this.getIntForSeverity(chk.getSeverity());
            if (chkStatus <= status) continue;
            status = chkStatus;
        }
        return status;
    }

    private int getIntForSeverity(Severity severity) {
        switch (severity) {
            case INFO: {
                return 1;
            }
            case WARNING: {
                return 2;
            }
            case ERROR: {
                return 4;
            }
        }
        return -1;
    }
}

