/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

public class TestCaseParamBP
extends AbstractParamInterfaceBP<ISpecTestCasePO> {
    @Override
    protected void updateParam(GuiParamValueConverter conv, IParamNameMapper mapper, int row) {
        ISpecTestCasePO parent;
        this.checkRemoveExternalDataFile(conv.getCurrentNode());
        if (conv.getCurrentNode() instanceof IExecTestCasePO) {
            IExecTestCasePO exTc = (IExecTestCasePO)conv.getCurrentNode();
            exTc.resolveTDReference();
        }
        if ((parent = NodePM.getSpecTestCaseParent((INodePO)((Object)conv.getCurrentNode()))) instanceof ISpecTestCasePO) {
            ISpecTestCasePO parentSpecTc = parent;
            for (String refName : conv.getParametersToAdd(parentSpecTc)) {
                this.addParameter(refName, conv.getDesc().getType(), parentSpecTc, mapper);
            }
        }
        this.writeTestDataEntry(conv, row);
    }

    public static Set<Param> getValuesForParameter(IParamNodePO node, String paramGUID) {
        HashSet<Param> result = new HashSet<Param>();
        if (paramGUID != null) {
            TestCaseParamBP.getValuesForParameterImp(node, paramGUID, true, result);
        }
        return result;
    }

    private static void getValuesForParameterImp(IParamNodePO node, String paramGUID, boolean isFirstCall, Set<Param> result) {
        block9: {
            block10: {
                block8: {
                    if (!(node instanceof ISpecTestCasePO)) break block8;
                    Iterator<INodePO> it = node.getNodeListIterator();
                    while (it.hasNext()) {
                        INodePO next = it.next();
                        if (!(next instanceof IParamNodePO)) continue;
                        IParamNodePO n = (IParamNodePO)next;
                        TestCaseParamBP.getValuesForParameterImp(n, paramGUID, false, result);
                    }
                    break block9;
                }
                if (!(node instanceof IExecTestCasePO)) break block10;
                IExecTestCasePO execTC = (IExecTestCasePO)node;
                if (execTC.getSpecTestCase() == null) break block9;
                if (isFirstCall) {
                    TestCaseParamBP.getValuesForParameterImp(execTC.getSpecTestCase(), paramGUID, false, result);
                } else {
                    Set<String> subst = TestCaseParamBP.findSubstitutes(execTC, paramGUID);
                    for (String p : subst) {
                        TestCaseParamBP.getValuesForParameterImp(execTC.getSpecTestCase(), p, false, result);
                    }
                }
                break block9;
            }
            if (node instanceof ICapPO) {
                ICapPO cap = (ICapPO)node;
                CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
                for (IParamDescriptionPO pd : cap.getParameterList()) {
                    try {
                        String pID = cap.getDataManager().getCell(0, pd);
                        if (pID == null || !pID.endsWith(paramGUID)) continue;
                        Component c = compSystem.findComponent(cap.getComponentType());
                        Action a = c.findAction(cap.getActionName());
                        result.add(a.findParam(pd.getUniqueId()));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
            }
        }
    }

    private static Set<String> findSubstitutes(IExecTestCasePO node, String paramGUID) {
        HashSet<String> result = new HashSet<String>();
        for (IParamDescriptionPO paramDesc : node.getParameterList()) {
            int rowNum = 0;
            while (rowNum < node.getDataManager().getDataSetCount()) {
                try {
                    String value = node.getDataManager().getCell(rowNum, paramDesc);
                    if (value != null && value.endsWith(paramGUID)) {
                        result.add(paramDesc.getUniqueId());
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                ++rowNum;
            }
        }
        return result;
    }

    public void addParameter(String refName, String type, ISpecTestCasePO node, IParamNameMapper mapper) {
        node.addParameter(type, refName, mapper);
    }

    @Override
    public void removeParameter(IParamDescriptionPO desc, ISpecTestCasePO specTc) {
        specTc.removeParameter(desc.getUniqueId());
        this.removeReferences(desc, specTc.getAllNodeIter());
    }

    private void removeReferences(IParamDescriptionPO desc, Iterator<? extends INodePO> childrenIt) {
        while (childrenIt.hasNext()) {
            INodePO node = childrenIt.next();
            if (!(node instanceof IParamNodePO)) continue;
            IParamNodePO child = (IParamNodePO)node;
            ITDManager mgr = child.getDataManager();
            Iterator<TDCell> refIt = child.getParamReferencesIterator();
            while (refIt.hasNext()) {
                boolean isModified;
                TDCell cell = refIt.next();
                String guid = mgr.getUniqueIds().get(cell.getCol());
                IParamDescriptionPO childDesc = child.getParameterForUniqueId(guid);
                ModelParamValueConverter conv = new ModelParamValueConverter(cell.getTestData(), child, childDesc);
                if (!conv.containsReferences() || !(isModified = conv.removeReference(desc.getUniqueId()))) continue;
                cell.setTestData(conv.getModelString());
            }
        }
    }

    @Override
    public void changeUsageParameter(ISpecTestCasePO specTc, IParamDescriptionPO desc, String newGuid, ParamNameBPDecorator mapper) {
        this.changeUsageReferences(specTc.getAllNodeIter(), desc, newGuid, mapper);
    }

    private void changeUsageReferences(Iterator childrenIt, IParamDescriptionPO desc, String newGuid, ParamNameBPDecorator mapper) {
        while (childrenIt.hasNext()) {
            IParamNodePO child = (IParamNodePO)childrenIt.next();
            ITDManager mgr = child.getDataManager();
            Iterator<TDCell> refIt = child.getParamReferencesIterator();
            while (refIt.hasNext()) {
                TDCell cell = refIt.next();
                String guid = mgr.getUniqueIds().get(cell.getCol());
                IParamDescriptionPO childDesc = child.getParameterForUniqueId(guid);
                String testData = cell.getTestData();
                ModelParamValueConverter conv = new ModelParamValueConverter(testData, child, childDesc);
                if (!conv.containsReferences()) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(desc.getUniqueId(), newGuid);
                if (!conv.replaceUuidsInReferences(map)) continue;
                cell.setTestData(conv.getModelString());
            }
        }
    }

    public static final List<IExecTestCasePO> getExecTcWithUnusedTestData(INodePO nodePO) {
        LinkedList<IExecTestCasePO> unusedTDExecList = new LinkedList<IExecTestCasePO>();
        Iterator<INodePO> nodeIt = nodePO.getNodeListIterator();
        while (nodeIt.hasNext()) {
            IExecTestCasePO execTc;
            INodePO childNode = nodeIt.next();
            if (!(childNode instanceof IExecTestCasePO) || (execTc = (IExecTestCasePO)childNode).getDataManager() == null || !execTc.checkHasUnusedTestData()) continue;
            unusedTDExecList.add(execTc);
        }
        return unusedTDExecList;
    }

    private boolean checkRemoveExternalDataFile(IParameterInterfacePO paramnode) {
        if (paramnode.getParameterList().isEmpty()) {
            paramnode.setDataFile(null);
            return true;
        }
        return false;
    }

    public static final void setInterfaceLocked(ISpecTestCasePO specTC, boolean locked) {
        specTC.setInterfaceLocked(locked);
    }

    public static final boolean isReferenceValueAllowed(IParameterInterfacePO paramNode) {
        ISpecTestCasePO parentNode;
        if (paramNode instanceof ISpecTestCasePO) {
            return false;
        }
        if ((paramNode instanceof IExecTestCasePO || paramNode instanceof ICapPO) && (parentNode = NodePM.getSpecTestCaseParent((INodePO)((Object)paramNode))) instanceof ISpecTestCasePO) {
            return parentNode.isInterfaceLocked() == false;
        }
        return true;
    }
}

