/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;

public class ToggleCanonicalModeCommand
extends Command {
    private boolean _enable;
    private Collection _semanticHosts = new ArrayList();
    private AbstractEMFOperation op = null;
    private TransactionalEditingDomain domain;

    public ToggleCanonicalModeCommand(Collection editParts, boolean enable) {
        super(DiagramUIMessages.ToggleCanonicalModeCommand_Label);
        Object[] editparts = new Object[editParts.size()];
        editParts.toArray(editparts);
        int i = 0;
        while (i < editparts.length) {
            CanonicalEditPolicy editPolicy;
            EditPart editPart = (EditPart)editparts[i];
            if (editPart != null && (editPolicy = ToggleCanonicalModeCommand.getCanonicalEditPolicy(editPart)) != null) {
                this._semanticHosts.add(new WeakReference<EObject>(editPolicy.getSemanticHost()));
            }
            ++i;
        }
        this._enable = enable;
    }

    public ToggleCanonicalModeCommand(EObject element, boolean enable) {
        super(DiagramUIMessages.ToggleCanonicalModeCommand_Label);
        this._semanticHosts.add(new WeakReference<EObject>(element));
        this._enable = enable;
    }

    public ToggleCanonicalModeCommand(EditPart target, boolean enable) {
        this(Collections.singletonList(target), enable);
    }

    public static ToggleCanonicalModeCommand getToggleCanonicalModeCommand(Collection editParts, boolean enable) {
        ToggleCanonicalModeCommand cmd = new ToggleCanonicalModeCommand(editParts, enable);
        return cmd.getSemanticHosts().isEmpty() ? null : cmd;
    }

    public static ToggleCanonicalModeCommand getToggleCanonicalModeCommand(ToggleCanonicalModeCommand tcmd, boolean enable) {
        if (tcmd == null || tcmd.getSemanticHosts().isEmpty()) {
            return null;
        }
        ToggleCanonicalModeCommand cmd = new ToggleCanonicalModeCommand(Collections.EMPTY_LIST, enable);
        cmd.setSemanticHosts(tcmd.getSemanticHosts());
        return cmd;
    }

    protected final Collection getSemanticHosts() {
        return this._semanticHosts;
    }

    private final void setSemanticHosts(Collection hosts) {
        this._semanticHosts.clear();
        this._semanticHosts.addAll(hosts);
    }

    protected static CanonicalEditPolicy getCanonicalEditPolicy(EditPart editPart) {
        while (editPart instanceof GroupEditPart) {
            editPart = editPart.getParent();
        }
        return (CanonicalEditPolicy)editPart.getEditPolicy((Object)"Canonical");
    }

    public void execute() {
        if (this._enable && this.domain != null) {
            this.op = new AbstractEMFOperation(this.domain, ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    ToggleCanonicalModeCommand.this.DoEnable(ToggleCanonicalModeCommand.this._enable);
                    return Status.OK_STATUS;
                }
            };
            try {
                this.op.execute(null, null);
            }
            catch (ExecutionException executionException) {
                this.DoEnable(this._enable);
            }
        } else {
            this.DoEnable(this._enable);
        }
    }

    private void DoEnable(boolean enable) {
        for (WeakReference wr : this.getSemanticHosts()) {
            EObject semanticHost = (EObject)wr.get();
            if (semanticHost == null) continue;
            List<CanonicalEditPolicy> ceps = CanonicalEditPolicy.getRegisteredEditPolicies(semanticHost);
            int i = 0;
            while (i < ceps.size()) {
                CanonicalEditPolicy cep = ceps.get(i);
                cep.enableRefresh(enable);
                ++i;
            }
        }
    }

    public void redo() {
        if (this.op != null) {
            try {
                this.op.redo(null, null);
            }
            catch (ExecutionException executionException) {}
        }
        this.DoEnable(this._enable);
    }

    public void undo() {
        this.DoEnable(!this._enable);
        if (this.op != null) {
            try {
                this.op.undo(null, null);
            }
            catch (ExecutionException executionException) {}
        }
    }

    public void setDomain(TransactionalEditingDomain d) {
        this.domain = d;
    }
}

