/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.painter.cell.decorator;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.CellPainterWrapper;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.ColorUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class LightRowBorderDecorator
extends CellPainterWrapper {
    private static final int DIM_DECAY = 4;

    public LightRowBorderDecorator(ICellPainter interiorPainter) {
        super(interiorPainter);
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredWidth(cell, gc, configRegistry) + 4;
    }

    public int getPreferredHeight(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredHeight(cell, gc, configRegistry) + 4;
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        Rectangle interiorBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        Color originalForeground = gc.getForeground();
        gc.setForeground(ColorUtils.getHeaderBorderColor());
        gc.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
        gc.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        gc.setForeground(originalForeground);
    }
}

