/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.config.AbstractUiBindingConfiguration;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.selection.action.SelectCellAction;
import net.sourceforge.nattable.selection.command.ClearAllSelectionsCommand;
import net.sourceforge.nattable.ui.action.IMouseAction;
import net.sourceforge.nattable.ui.binding.UiBindingRegistry;
import net.sourceforge.nattable.ui.matcher.IMouseEventMatcher;
import net.sourceforge.nattable.ui.matcher.MouseEventMatcher;
import net.sourceforge.nattable.viewport.action.ViewportSelectRowAction;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.action.SelectColumnAction;
import org.eclipse.swt.events.MouseEvent;

public class UIBindings
extends AbstractUiBindingConfiguration {
    private final NatTableWidget natTableWidget;

    public UIBindings(NatTableWidget natTableWidget) {
        this.natTableWidget = natTableWidget;
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerFirstMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 3){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                return super.matches(natTable, event, regionLabels) && !UIBindings.this.isAlreadyInSelection(event);
            }
        }, (IMouseAction)new SelectCellAction());
        uiBindingRegistry.registerFirstMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "COLUMN_HEADER", 3){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                return super.matches(natTable, event, regionLabels) && !UIBindings.this.areColumnsSelected();
            }
        }, (IMouseAction)new SelectColumnAction());
        uiBindingRegistry.registerFirstMouseDownBinding(new IMouseEventMatcher(){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                return regionLabels == null;
            }
        }, new IMouseAction(){

            public void run(NatTable natTable, MouseEvent event) {
                natTable.doCommand((ILayerCommand)new ClearAllSelectionsCommand());
                natTable.redraw();
                UIBindings.this.natTableWidget.tableSelectionChanged();
            }
        });
        uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)new MouseEventMatcher(0, "ROW_HEADER", 3), (IMouseAction)new ViewportSelectRowAction(false, false));
    }

    protected boolean areColumnsSelected() {
        if (this.natTableWidget.getSelectedColumns() != null) {
            return this.natTableWidget.getSelectedColumns().size() > 1;
        }
        return false;
    }

    protected boolean isAlreadyInSelection(MouseEvent event) {
        PositionCoordinate cellPosition = this.natTableWidget.getCellPositionAt(event.x, event.y);
        return this.natTableWidget.getSelectedCellsPositionCoordinates().contains(cellPosition);
    }
}

